/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ui.overlay;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import net.imglib2.Interval;
import net.imglib2.realtransform.AffineTransform3D;

public class BoxOverlay {
    final Color activeBackColor = new Color(0x994499);
    final Color activeFrontColor = Color.GREEN;
    final Color canvasColor = new Color(-1329873989, true);
    private double depth = 10.0;
    private double scale = 0.1;
    private final double[] origin = new double[3];

    public void paint(Graphics2D graphics, AffineTransform3D sourceToScreen, Interval sourceInterval, Interval targetInterval, Interval boxScreen) {
        assert (targetInterval.numDimensions() >= 2);
        double perspective = 3.0;
        double screenBoxRatio = 0.75;
        long sourceSize = Math.max(Math.max(sourceInterval.dimension(0), sourceInterval.dimension(1)), sourceInterval.dimension(2));
        long targetSize = Math.max(targetInterval.dimension(0), targetInterval.dimension(1));
        double vx = sourceToScreen.get(0, 0);
        double vy = sourceToScreen.get(1, 0);
        double vz = sourceToScreen.get(2, 0);
        double transformScale = Math.sqrt(vx * vx + vy * vy + vz * vz);
        this.setDepth(3.0 * (double)sourceSize * transformScale);
        double bw = 0.75 * (double)boxScreen.dimension(0);
        double bh = 0.75 * (double)boxScreen.dimension(1);
        this.scale = Math.min(bw / (double)targetInterval.dimension(0), bh / (double)targetInterval.dimension(1));
        double tsScale = transformScale * (double)sourceSize / (double)targetSize;
        if (tsScale > 1.0) {
            this.scale /= tsScale;
        }
        long x = boxScreen.min(0) + boxScreen.dimension(0) / 2L;
        long y = boxScreen.min(1) + boxScreen.dimension(1) / 2L;
        AffineTransform tOld = graphics.getTransform();
        AffineTransform translate = new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, x, y);
        translate.preConcatenate(tOld);
        graphics.setTransform(translate);
        this.origin[0] = targetInterval.min(0) + targetInterval.dimension(0) / 2L;
        this.origin[1] = targetInterval.min(1) + targetInterval.dimension(1) / 2L;
        GeneralPath canvas = new GeneralPath();
        this.renderCanvas(targetInterval, canvas);
        GeneralPath activeFront = new GeneralPath();
        GeneralPath activeBack = new GeneralPath();
        this.renderBox(sourceInterval, sourceToScreen, activeFront, activeBack);
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setPaint(this.activeBackColor);
        graphics.draw(activeBack);
        graphics.setPaint(this.canvasColor);
        graphics.fill(canvas);
        graphics.setPaint(this.activeFrontColor);
        graphics.draw(activeFront);
        double sX0 = sourceInterval.min(0);
        double sY0 = sourceInterval.min(1);
        double sZ0 = sourceInterval.min(2);
        double[] px = new double[]{sX0 + (double)(sourceInterval.dimension(0) / 2L), sY0, sZ0};
        double[] py = new double[]{sX0, sY0 + (double)(sourceInterval.dimension(1) / 2L), sZ0};
        double[] pz = new double[]{sX0, sY0, sZ0 + (double)(sourceInterval.dimension(2) / 2L)};
        double[] qx = new double[3];
        double[] qy = new double[3];
        double[] qz = new double[3];
        sourceToScreen.apply(px, qx);
        sourceToScreen.apply(py, qy);
        sourceToScreen.apply(pz, qz);
        graphics.setPaint(Color.WHITE);
        graphics.setFont(new Font("SansSerif", 0, 8));
        graphics.drawString("x", (float)this.perspectiveX(qx), (float)this.perspectiveY(qx) - 2.0f);
        graphics.drawString("y", (float)this.perspectiveX(qy), (float)this.perspectiveY(qy) - 2.0f);
        graphics.drawString("z", (float)this.perspectiveX(qz), (float)this.perspectiveY(qz) - 2.0f);
        graphics.setTransform(tOld);
    }

    public void setScale(double scale) {
        this.scale = scale;
    }

    public void setDepth(double depth) {
        this.depth = depth;
        this.origin[2] = -depth;
    }

    private double perspectiveX(double[] p) {
        return this.scale * (p[0] - this.origin[0]) / (p[2] - this.origin[2]) * this.depth;
    }

    private double perspectiveY(double[] p) {
        return this.scale * (p[1] - this.origin[1]) / (p[2] - this.origin[2]) * this.depth;
    }

    private void splitEdge(double[] a, double[] b, GeneralPath before, GeneralPath behind) {
        double[] t = new double[3];
        if (a[2] <= 0.0) {
            before.moveTo(this.perspectiveX(a), this.perspectiveY(a));
            if (b[2] <= 0.0) {
                before.lineTo(this.perspectiveX(b), this.perspectiveY(b));
            } else {
                double d = a[2] / (a[2] - b[2]);
                t[0] = (b[0] - a[0]) * d + a[0];
                t[1] = (b[1] - a[1]) * d + a[1];
                before.lineTo(this.perspectiveX(t), this.perspectiveY(t));
                behind.moveTo(this.perspectiveX(t), this.perspectiveY(t));
                behind.lineTo(this.perspectiveX(b), this.perspectiveY(b));
            }
        } else {
            behind.moveTo(this.perspectiveX(a), this.perspectiveY(a));
            if (b[2] > 0.0) {
                behind.lineTo(this.perspectiveX(b), this.perspectiveY(b));
            } else {
                double d = a[2] / (a[2] - b[2]);
                t[0] = (b[0] - a[0]) * d + a[0];
                t[1] = (b[1] - a[1]) * d + a[1];
                behind.lineTo(this.perspectiveX(t), this.perspectiveY(t));
                before.moveTo(this.perspectiveX(t), this.perspectiveY(t));
                before.lineTo(this.perspectiveX(b), this.perspectiveY(b));
            }
        }
    }

    private void renderCanvas(Interval targetInterval, GeneralPath canvas) {
        double tX0 = targetInterval.min(0);
        double tX1 = targetInterval.max(0);
        double tY0 = targetInterval.min(1);
        double tY1 = targetInterval.max(1);
        double[] c000 = new double[]{tX0, tY0, 0.0};
        double[] c100 = new double[]{tX1, tY0, 0.0};
        double[] c010 = new double[]{tX0, tY1, 0.0};
        double[] c110 = new double[]{tX1, tY1, 0.0};
        canvas.moveTo(this.perspectiveX(c000), this.perspectiveY(c000));
        canvas.lineTo(this.perspectiveX(c100), this.perspectiveY(c100));
        canvas.lineTo(this.perspectiveX(c110), this.perspectiveY(c110));
        canvas.lineTo(this.perspectiveX(c010), this.perspectiveY(c010));
        canvas.closePath();
    }

    private void renderBox(Interval sourceInterval, AffineTransform3D transform, GeneralPath front, GeneralPath back) {
        double sX0 = sourceInterval.min(0);
        double sX1 = sourceInterval.max(0);
        double sY0 = sourceInterval.min(1);
        double sY1 = sourceInterval.max(1);
        double sZ0 = sourceInterval.min(2);
        double sZ1 = sourceInterval.max(2);
        double[] p000 = new double[]{sX0, sY0, sZ0};
        double[] p100 = new double[]{sX1, sY0, sZ0};
        double[] p010 = new double[]{sX0, sY1, sZ0};
        double[] p110 = new double[]{sX1, sY1, sZ0};
        double[] p001 = new double[]{sX0, sY0, sZ1};
        double[] p101 = new double[]{sX1, sY0, sZ1};
        double[] p011 = new double[]{sX0, sY1, sZ1};
        double[] p111 = new double[]{sX1, sY1, sZ1};
        double[] q000 = new double[3];
        double[] q100 = new double[3];
        double[] q010 = new double[3];
        double[] q110 = new double[3];
        double[] q001 = new double[3];
        double[] q101 = new double[3];
        double[] q011 = new double[3];
        double[] q111 = new double[3];
        transform.apply(p000, q000);
        transform.apply(p100, q100);
        transform.apply(p010, q010);
        transform.apply(p110, q110);
        transform.apply(p001, q001);
        transform.apply(p101, q101);
        transform.apply(p011, q011);
        transform.apply(p111, q111);
        this.splitEdge(q000, q100, front, back);
        this.splitEdge(q100, q110, front, back);
        this.splitEdge(q110, q010, front, back);
        this.splitEdge(q010, q000, front, back);
        this.splitEdge(q001, q101, front, back);
        this.splitEdge(q101, q111, front, back);
        this.splitEdge(q111, q011, front, back);
        this.splitEdge(q011, q001, front, back);
        this.splitEdge(q000, q001, front, back);
        this.splitEdge(q100, q101, front, back);
        this.splitEdge(q110, q111, front, back);
        this.splitEdge(q010, q011, front, back);
    }
}

