/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ui.overlay;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import net.imglib2.ui.OverlayRenderer;
import net.imglib2.ui.RenderTarget;

public class BufferedImageOverlayRenderer
implements OverlayRenderer,
RenderTarget {
    protected BufferedImage bufferedImage = null;
    protected BufferedImage pendingImage = null;
    protected boolean pending = false;
    protected volatile int width = 0;
    protected volatile int height = 0;

    @Override
    public synchronized BufferedImage setBufferedImage(BufferedImage img) {
        BufferedImage tmp = this.pendingImage;
        this.pendingImage = img;
        this.pending = true;
        return tmp;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drawOverlays(Graphics g) {
        BufferedImageOverlayRenderer bufferedImageOverlayRenderer = this;
        synchronized (bufferedImageOverlayRenderer) {
            if (this.pending) {
                BufferedImage tmp = this.bufferedImage;
                this.bufferedImage = this.pendingImage;
                this.pendingImage = tmp;
                this.pending = false;
            }
        }
        if (this.bufferedImage != null) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            g.drawImage(this.bufferedImage, 0, 0, this.getWidth(), this.getHeight(), null);
        }
    }

    @Override
    public void setCanvasSize(int width, int height) {
        this.width = width;
        this.height = height;
    }
}

