/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ui.viewer;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import net.imglib2.RandomAccessible;
import net.imglib2.converter.Converter;
import net.imglib2.realtransform.AffineTransform2D;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.ui.AffineTransformType2D;
import net.imglib2.ui.InteractiveDisplayCanvasComponent;
import net.imglib2.ui.TransformEventHandler2D;
import net.imglib2.ui.util.Defaults;
import net.imglib2.ui.util.InterpolatingSource;
import net.imglib2.ui.viewer.InteractiveRealViewer;

public class InteractiveViewer2D<T extends NumericType<T>>
extends InteractiveRealViewer<AffineTransform2D, InteractiveDisplayCanvasComponent<AffineTransform2D>> {
    public InteractiveViewer2D(int width, int height, RandomAccessible<T> source, AffineTransform2D sourceTransform, Converter<? super T, ARGBType> converter) {
        this(width, height, new InterpolatingSource<T, AffineTransform2D>(source, sourceTransform, converter));
    }

    public InteractiveViewer2D(int width, int height, RandomAccessible<T> source, Converter<? super T, ARGBType> converter) {
        this(width, height, source, new AffineTransform2D(), converter);
    }

    public InteractiveViewer2D(int width, int height, final InterpolatingSource<T, AffineTransform2D> interpolatingSource) {
        super(AffineTransformType2D.instance, new InteractiveDisplayCanvasComponent<AffineTransform2D>(width, height, TransformEventHandler2D.factory()), Defaults.rendererFactory(AffineTransformType2D.instance, interpolatingSource));
        ((InteractiveDisplayCanvasComponent)this.display).addHandler(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 73) {
                    interpolatingSource.switchInterpolation();
                    InteractiveViewer2D.this.requestRepaint();
                }
            }
        });
    }
}

