/*
 * Decompiled with CFR 0.152.
 */
package icy.action;

import icy.action.IcyAbstractAction;
import icy.gui.dialog.IdConfirmDialog;
import icy.gui.dialog.MessageDialog;
import icy.gui.frame.progress.FailedAnnounceFrame;
import icy.gui.main.MainFrame;
import icy.gui.sequence.tools.SequenceCanvasResizeFrame;
import icy.gui.sequence.tools.SequenceDimensionAdjustFrame;
import icy.gui.sequence.tools.SequenceDimensionConvertFrame;
import icy.gui.sequence.tools.SequenceDimensionExtendFrame;
import icy.gui.sequence.tools.SequenceDimensionMergeFrame;
import icy.gui.sequence.tools.SequenceResizeFrame;
import icy.gui.viewer.Viewer;
import icy.image.cache.ImageCache;
import icy.main.Icy;
import icy.resource.ResourceUtil;
import icy.resource.icon.IcyIcon;
import icy.roi.ROI;
import icy.sequence.DimensionId;
import icy.sequence.Sequence;
import icy.sequence.SequenceDataIterator;
import icy.sequence.SequenceUtil;
import icy.system.SystemUtil;
import icy.system.thread.ThreadUtil;
import icy.type.DataIteratorUtil;
import icy.type.DataType;
import icy.undo.IcyUndoManager;
import icy.util.ClassUtil;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JToggleButton;

public class SequenceOperationActions {
    public static IcyAbstractAction cloneSequenceAction = new IcyAbstractAction("Duplicate", new IcyIcon(ResourceUtil.ICON_COPY), "Duplicate sequence", "Create a fresh copy of the sequence", true, "Duplicating sequence..."){
        private static final long serialVersionUID = 6907103082567189377L;

        @Override
        public boolean doAction(ActionEvent e) {
            final Viewer viewer = Icy.getMainInterface().getActiveViewer();
            if (viewer == null) {
                return false;
            }
            Sequence seq = viewer.getSequence();
            if (seq == null) {
                return false;
            }
            try {
                final Sequence out = SequenceUtil.getCopy(seq);
                ThreadUtil.invokeLater(new Runnable(){
                    final /* synthetic */ 1 this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void run() {
                        Viewer vout = new Viewer(out);
                        vout.getLut().copyFrom(viewer.getLut());
                    }
                });
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return true;
        }

        @Override
        public boolean isEnabled() {
            return super.isEnabled() && Icy.getMainInterface().getActiveSequence() != null;
        }
    };
    public static IcyAbstractAction convertUByteScaledSequenceAction = new SequenceConvertAction(DataType.UBYTE, true);
    public static IcyAbstractAction convertUByteSequenceAction = new SequenceConvertAction(DataType.UBYTE, false);
    public static IcyAbstractAction convertByteScaledSequenceAction = new SequenceConvertAction(DataType.BYTE, true);
    public static IcyAbstractAction convertByteSequenceAction = new SequenceConvertAction(DataType.BYTE, false);
    public static IcyAbstractAction convertUShortScaledSequenceAction = new SequenceConvertAction(DataType.USHORT, true);
    public static IcyAbstractAction convertUShortSequenceAction = new SequenceConvertAction(DataType.USHORT, false);
    public static IcyAbstractAction convertShortScaledSequenceAction = new SequenceConvertAction(DataType.SHORT, true);
    public static IcyAbstractAction convertShortSequenceAction = new SequenceConvertAction(DataType.SHORT, false);
    public static IcyAbstractAction convertUIntScaledSequenceAction = new SequenceConvertAction(DataType.UINT, true);
    public static IcyAbstractAction convertUIntSequenceAction = new SequenceConvertAction(DataType.UINT, false);
    public static IcyAbstractAction convertIntScaledSequenceAction = new SequenceConvertAction(DataType.INT, true);
    public static IcyAbstractAction convertIntSequenceAction = new SequenceConvertAction(DataType.INT, false);
    public static IcyAbstractAction convertFloatScaledSequenceAction = new SequenceConvertAction(DataType.FLOAT, true);
    public static IcyAbstractAction convertFloatSequenceAction = new SequenceConvertAction(DataType.FLOAT, false);
    public static IcyAbstractAction convertDoubleScaledSequenceAction = new SequenceConvertAction(DataType.DOUBLE, true);
    public static IcyAbstractAction convertDoubleSequenceAction = new SequenceConvertAction(DataType.DOUBLE, false);
    public static IcyAbstractAction argbSequenceAction = new SequenceColorAction(2);
    public static IcyAbstractAction rgbSequenceAction = new SequenceColorAction(1);
    public static IcyAbstractAction graySequenceAction = new SequenceColorAction(10);
    public static IcyAbstractAction cropSequenceAction = new IcyAbstractAction("Fast crop", new IcyIcon(ResourceUtil.ICON_CUT), "Fast crop image", "Crop an image from a ROI", true, "Doing image crop..."){
        private static final long serialVersionUID = 2928113834852115366L;

        @Override
        public boolean doAction(ActionEvent e) {
            Viewer viewer = Icy.getMainInterface().getActiveViewer();
            if (viewer == null) {
                return false;
            }
            Sequence seq = viewer.getSequence();
            if (seq == null) {
                return false;
            }
            ArrayList<ROI> rois = seq.getROIs();
            int size = rois.size();
            if (size == 0) {
                MessageDialog.showDialog("There is no ROI in the current sequence.\nYou need a ROI to define the region to crop.", 1);
                return false;
            }
            if (size > 1) {
                rois = seq.getSelectedROIs();
                size = rois.size();
                if (size == 0) {
                    MessageDialog.showDialog("You need to select a ROI to do this operation.", 1);
                    return false;
                }
                if (size > 1) {
                    MessageDialog.showDialog("You must have only one selected ROI to do this operation.", 1);
                    return false;
                }
            }
            ROI roi = (ROI)rois.get(0);
            try {
                final Sequence out = SequenceUtil.getSubSequence(seq, roi);
                ThreadUtil.invokeLater(new Runnable(){
                    final /* synthetic */ 2 this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void run() {
                        new Viewer(out);
                    }
                });
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return true;
        }

        @Override
        public boolean isEnabled() {
            return super.isEnabled() && Icy.getMainInterface().getActiveSequence() != null;
        }
    };
    public static IcyAbstractAction canvasResizeAction = new IcyAbstractAction("Canvas size...", new IcyIcon(ResourceUtil.ICON_CROP), "Canvas resize", "Resize the canvas without changing image size."){
        private static final long serialVersionUID = 9156831541828750627L;

        @Override
        public boolean doAction(ActionEvent e) {
            Sequence sequence = Icy.getMainInterface().getActiveSequence();
            if (sequence != null) {
                new SequenceCanvasResizeFrame(sequence);
                return true;
            }
            return false;
        }

        @Override
        public boolean isEnabled() {
            return super.isEnabled() && Icy.getMainInterface().getActiveSequence() != null;
        }
    };
    public static IcyAbstractAction imageResizeAction = new IcyAbstractAction("Image size...", new IcyIcon(ResourceUtil.ICON_FIT_CANVAS), "Image resize", "Resize the image."){
        private static final long serialVersionUID = -4731940627380446776L;

        @Override
        public boolean doAction(ActionEvent e) {
            Sequence sequence = Icy.getMainInterface().getActiveSequence();
            if (sequence != null) {
                new SequenceResizeFrame(sequence);
                return true;
            }
            return false;
        }

        @Override
        public boolean isEnabled() {
            return super.isEnabled() && Icy.getMainInterface().getActiveSequence() != null;
        }
    };
    public static IcyAbstractAction extractAllChannelAction = new ExtractChannelAction(-1);
    public static IcyAbstractAction[] extractChannelActions = new IcyAbstractAction[]{new ExtractChannelAction(0), new ExtractChannelAction(1), new ExtractChannelAction(2), new ExtractChannelAction(3), new ExtractChannelAction(4), new ExtractChannelAction(5)};
    public static IcyAbstractAction[] removeChannelActions = new IcyAbstractAction[]{new RemoveChannelAction(0), new RemoveChannelAction(1), new RemoveChannelAction(2), new RemoveChannelAction(3), new RemoveChannelAction(4), new RemoveChannelAction(5)};
    public static IcyAbstractAction mergeChannelsAction = new MergeDimensionAction(DimensionId.C);
    public static IcyAbstractAction reverseSlicesAction = new IcyAbstractAction("Reverse order", new IcyIcon(ResourceUtil.ICON_LAYER_REVERSE_V), "Reverse Z slices", "Reverse Z slices order", true, "Reversing slices..."){
        private static final long serialVersionUID = -4731940627380446776L;

        @Override
        public boolean doAction(ActionEvent e) {
            Sequence sequence = Icy.getMainInterface().getActiveSequence();
            if (sequence != null) {
                SequenceUtil.reverseZ(sequence);
                return true;
            }
            return false;
        }
    };
    public static IcyAbstractAction extractSliceAction = new IcyAbstractAction("Extract slice", new IcyIcon(ResourceUtil.ICON_LAYER_EXTRACT_V), "Extract current Z slice", "Create a new sequence by extracting current Z slice of active sequence.", false, "Extracting slice..."){
        private static final long serialVersionUID = -3731161374656240419L;

        @Override
        public boolean doAction(ActionEvent e) {
            int z;
            Sequence sequence;
            final Viewer viewer = Icy.getMainInterface().getActiveViewer();
            if (viewer != null && (sequence = viewer.getSequence()) != null && (z = viewer.getPositionZ()) != -1) {
                final Sequence out = SequenceUtil.extractSlice(sequence, z);
                ThreadUtil.invokeLater(new Runnable(){
                    final /* synthetic */ 6 this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void run() {
                        Viewer vout = new Viewer(out);
                        vout.getLut().copyFrom(viewer.getLut());
                    }
                });
                return true;
            }
            return false;
        }

        @Override
        public boolean isEnabled() {
            Viewer viewer = Icy.getMainInterface().getActiveViewer();
            int z = viewer == null ? -1 : viewer.getPositionZ();
            return super.isEnabled() && z != -1;
        }
    };
    public static IcyAbstractAction removeSliceAction = new IcyAbstractAction("Remove slice", new IcyIcon(ResourceUtil.ICON_LAYER_REMOVE_V), "Remove current Z slice", "Remove the current Z slice of active sequence.", false, "Removing slice..."){
        private static final long serialVersionUID = -6588564641490390145L;

        @Override
        public boolean doAction(ActionEvent e) {
            int z;
            Viewer viewer = Icy.getMainInterface().getActiveViewer();
            int n = z = viewer == null ? -1 : viewer.getPositionZ();
            if (z != -1) {
                SequenceUtil.removeZAndShift(viewer.getSequence(), z);
                return true;
            }
            return false;
        }

        @Override
        public boolean isEnabled() {
            Viewer viewer = Icy.getMainInterface().getActiveViewer();
            int z = viewer == null ? -1 : viewer.getPositionZ();
            return super.isEnabled() && z != -1;
        }
    };
    public static IcyAbstractAction addSlicesAction = new IcyAbstractAction("Add...", new IcyIcon(ResourceUtil.ICON_LAYER_ADD_V), "Add slice(s)", "Extends Z dimension by adding empty or duplicating slices."){
        private static final long serialVersionUID = -1967473595758834348L;

        @Override
        public boolean doAction(ActionEvent e) {
            Sequence sequence = Icy.getMainInterface().getActiveSequence();
            if (sequence != null) {
                new SequenceDimensionExtendFrame(Icy.getMainInterface().getActiveSequence(), DimensionId.Z);
                return true;
            }
            return false;
        }

        @Override
        public boolean isEnabled() {
            Sequence sequence = Icy.getMainInterface().getActiveSequence();
            return super.isEnabled() && sequence != null && !sequence.isEmpty();
        }
    };
    public static IcyAbstractAction mergeSlicesAction = new MergeDimensionAction(DimensionId.Z);
    public static IcyAbstractAction removeSlicesAction = new IcyAbstractAction("Remove...", new IcyIcon(ResourceUtil.ICON_LAYER_REMOVE_ADV_V), "Advanced slice remove", "Advanced Z slice remove operation."){
        private static final long serialVersionUID = -1899409406755437158L;

        @Override
        public boolean doAction(ActionEvent e) {
            Sequence sequence = Icy.getMainInterface().getActiveSequence();
            if (sequence != null) {
                new SequenceDimensionAdjustFrame(sequence, DimensionId.Z);
                return true;
            }
            return false;
        }

        @Override
        public boolean isEnabled() {
            return super.isEnabled() && Icy.getMainInterface().getActiveSequence() != null;
        }
    };
    public static IcyAbstractAction reverseFramesAction = new IcyAbstractAction("Reverse order", new IcyIcon(ResourceUtil.ICON_LAYER_REVERSE_H), "Reverse T frames", "Reverse T frames order", true, "Reversing frames..."){
        private static final long serialVersionUID = 2403122454093281595L;

        @Override
        public boolean doAction(ActionEvent e) {
            Sequence sequence = Icy.getMainInterface().getActiveSequence();
            if (sequence != null) {
                SequenceUtil.reverseT(sequence);
                return true;
            }
            return false;
        }

        @Override
        public boolean isEnabled() {
            return super.isEnabled() && Icy.getMainInterface().getActiveSequence() != null;
        }
    };
    public static IcyAbstractAction extractFrameAction = new IcyAbstractAction("Extract frame", new IcyIcon(ResourceUtil.ICON_LAYER_EXTRACT_H), "Extract current T frame", "Create a new sequence by extracting current T frame of active sequence.", false, "Extracting frame..."){
        private static final long serialVersionUID = -5809053788547447661L;

        @Override
        public boolean doAction(ActionEvent e) {
            int t;
            Sequence sequence;
            final Viewer viewer = Icy.getMainInterface().getActiveViewer();
            if (viewer != null && (sequence = viewer.getSequence()) != null && (t = viewer.getPositionT()) != -1) {
                final Sequence out = SequenceUtil.extractFrame(sequence, t);
                ThreadUtil.invokeLater(new Runnable(){
                    final /* synthetic */ 11 this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void run() {
                        Viewer vout = new Viewer(out);
                        vout.getLut().copyFrom(viewer.getLut());
                    }
                });
                return true;
            }
            return false;
        }

        @Override
        public boolean isEnabled() {
            Viewer viewer = Icy.getMainInterface().getActiveViewer();
            int t = viewer == null ? -1 : viewer.getPositionT();
            return super.isEnabled() && t != -1;
        }
    };
    public static IcyAbstractAction removeFrameAction = new IcyAbstractAction("Remove frame", new IcyIcon(ResourceUtil.ICON_LAYER_REMOVE_H), "Remove current T frame", "Remove the current T frame of active sequence.", false, "Removing frame..."){
        private static final long serialVersionUID = -6113522706924858672L;

        @Override
        public boolean doAction(ActionEvent e) {
            int t;
            Viewer viewer = Icy.getMainInterface().getActiveViewer();
            int n = t = viewer == null ? -1 : viewer.getPositionT();
            if (t != -1) {
                SequenceUtil.removeTAndShift(viewer.getSequence(), t);
                return true;
            }
            return false;
        }

        @Override
        public boolean isEnabled() {
            Viewer viewer = Icy.getMainInterface().getActiveViewer();
            int t = viewer == null ? -1 : viewer.getPositionT();
            return super.isEnabled() && t != -1;
        }
    };
    public static IcyAbstractAction addFramesAction = new IcyAbstractAction("Add...", new IcyIcon(ResourceUtil.ICON_LAYER_ADD_H), "Add frame(s)", "Extends T dimension by adding empty or duplicating frames."){
        private static final long serialVersionUID = -6106326145960291510L;

        @Override
        public boolean doAction(ActionEvent e) {
            Sequence sequence = Icy.getMainInterface().getActiveSequence();
            if (sequence != null) {
                new SequenceDimensionExtendFrame(Icy.getMainInterface().getActiveSequence(), DimensionId.T);
                return true;
            }
            return false;
        }

        @Override
        public boolean isEnabled() {
            Sequence sequence = Icy.getMainInterface().getActiveSequence();
            return super.isEnabled() && sequence != null && !sequence.isEmpty();
        }
    };
    public static IcyAbstractAction mergeFramesAction = new MergeDimensionAction(DimensionId.T);
    public static IcyAbstractAction removeFramesAction = new IcyAbstractAction("Remove...", new IcyIcon(ResourceUtil.ICON_LAYER_REMOVE_ADV_H), "Advanced frame remove", "Advanced T frame remove operation."){
        private static final long serialVersionUID = -7963804798009814712L;

        @Override
        public boolean doAction(ActionEvent e) {
            Sequence sequence = Icy.getMainInterface().getActiveSequence();
            if (sequence != null) {
                new SequenceDimensionAdjustFrame(sequence, DimensionId.T);
                return true;
            }
            return false;
        }

        @Override
        public boolean isEnabled() {
            return super.isEnabled() && Icy.getMainInterface().getActiveSequence() != null;
        }
    };
    public static IcyAbstractAction convertToSlicesAction = new IcyAbstractAction("Convert to stack", new IcyIcon(ResourceUtil.ICON_LAYER_V1), "Convert to stack", "Set all images in Z dimension.", true, "Converting to stack..."){
        private static final long serialVersionUID = 5987495169612852524L;

        @Override
        public boolean doAction(ActionEvent e) {
            Viewer viewer = Icy.getMainInterface().getActiveViewer();
            if (viewer != null) {
                Sequence sequence = viewer.getSequence();
                int t = viewer.getPositionT();
                if (sequence != null) {
                    SequenceUtil.convertToStack(sequence);
                    viewer.setPositionZ(t);
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean isEnabled() {
            return super.isEnabled() && Icy.getMainInterface().getActiveSequence() != null;
        }
    };
    public static IcyAbstractAction convertToFramesAction = new IcyAbstractAction("Convert to time", new IcyIcon(ResourceUtil.ICON_LAYER_H1), "Convert to time sequence", "Set all images in T dimension.", true, "Converting to time..."){
        private static final long serialVersionUID = -6555855298812635009L;

        @Override
        public boolean doAction(ActionEvent e) {
            Viewer viewer = Icy.getMainInterface().getActiveViewer();
            if (viewer != null) {
                Sequence sequence = viewer.getSequence();
                int z = viewer.getPositionZ();
                if (sequence != null) {
                    SequenceUtil.convertToTime(sequence);
                    viewer.setPositionT(z);
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean isEnabled() {
            return super.isEnabled() && Icy.getMainInterface().getActiveSequence() != null;
        }
    };
    public static IcyAbstractAction advancedZTConvertAction = new IcyAbstractAction("Advanced...", new IcyIcon(ResourceUtil.ICON_COG), "Advanced dimension conversion", "Advanced dimension conversion operation."){
        private static final long serialVersionUID = 110261266295404071L;

        @Override
        public boolean doAction(ActionEvent e) {
            Sequence sequence = Icy.getMainInterface().getActiveSequence();
            if (sequence != null) {
                new SequenceDimensionConvertFrame(sequence);
                return true;
            }
            return false;
        }

        @Override
        public boolean isEnabled() {
            Sequence sequence = Icy.getMainInterface().getActiveSequence();
            return super.isEnabled() && sequence != null && !sequence.isEmpty();
        }
    };
    @Deprecated
    public static IcyAbstractAction fillSequenceAction = new IcyAbstractAction("Fill", new IcyIcon(ResourceUtil.ICON_BRUSH), "Fill ROI content", "Fill content of the selected ROI with specified value", true, "Fill ROI content"){
        private static final long serialVersionUID = 110261266295404071L;

        @Override
        public boolean doAction(ActionEvent e) {
            MainFrame mainFrame;
            Sequence sequence = Icy.getMainInterface().getActiveSequence();
            if (sequence != null && (mainFrame = Icy.getMainInterface().getMainFrame()) != null) {
                double value = Icy.getMainInterface().getROIRibbonTask().getFillValue();
                try {
                    for (ROI roi : sequence.getSelectedROIs()) {
                        DataIteratorUtil.set(new SequenceDataIterator(sequence, roi, true), value);
                    }
                }
                catch (InterruptedException e1) {
                    MessageDialog.showDialog("Operation interrupted", e1.getLocalizedMessage(), 0);
                }
                sequence.dataChanged();
                return true;
            }
            return false;
        }

        @Override
        public boolean isEnabled() {
            Sequence sequence = Icy.getMainInterface().getActiveSequence();
            return super.isEnabled() && sequence != null && !sequence.isEmpty();
        }
    };
    public static IcyAbstractAction undoAction = new IcyAbstractAction("Undo", new IcyIcon(ResourceUtil.ICON_UNDO), "Undo last operation (Ctrl+Z)", 90, SystemUtil.getMenuCtrlMask()){
        private static final long serialVersionUID = 5773755313377178022L;

        @Override
        public boolean doAction(ActionEvent e) {
            return Icy.getMainInterface().undo();
        }

        @Override
        public boolean isEnabled() {
            IcyUndoManager undoManager = Icy.getMainInterface().getUndoManager();
            if (super.isEnabled() && undoManager != null) {
                return undoManager.canUndo();
            }
            return false;
        }
    };
    public static IcyAbstractAction redoAction = new IcyAbstractAction("Redo", new IcyIcon(ResourceUtil.ICON_REDO), "Redo last operation (Ctrl+Y)", 89, SystemUtil.getMenuCtrlMask()){
        private static final long serialVersionUID = 1288382252962040008L;

        @Override
        public boolean doAction(ActionEvent e) {
            return Icy.getMainInterface().redo();
        }

        @Override
        public boolean isEnabled() {
            IcyUndoManager undoManager = Icy.getMainInterface().getUndoManager();
            if (super.isEnabled() && undoManager != null) {
                return undoManager.canRedo();
            }
            return false;
        }
    };
    public static IcyAbstractAction undoClearAction = new IcyAbstractAction("Clear history", new IcyIcon(ResourceUtil.ICON_TRASH), "Clear all history (will release some memory"){
        private static final long serialVersionUID = 1251314072585735122L;

        @Override
        public boolean doAction(ActionEvent e) {
            IcyUndoManager undoManager = Icy.getMainInterface().getUndoManager();
            if (undoManager != null) {
                undoManager.discardAllEdits();
                return true;
            }
            return false;
        }

        @Override
        public boolean isEnabled() {
            IcyUndoManager undoManager = Icy.getMainInterface().getUndoManager();
            if (super.isEnabled() && undoManager != null) {
                return undoManager.canUndo() || undoManager.canRedo();
            }
            return false;
        }
    };
    public static IcyAbstractAction undoClearAllButLastAction = new IcyAbstractAction("Clear all but last", new IcyIcon(ResourceUtil.ICON_CLEAR_BEFORE), "Clear all history but the last operation (can release some memory)"){
        private static final long serialVersionUID = 5773755313377178022L;

        @Override
        public boolean doAction(ActionEvent e) {
            IcyUndoManager undoManager = Icy.getMainInterface().getUndoManager();
            if (undoManager != null) {
                undoManager.discardOldEdits(1);
                undoManager.discardFutureEdits();
                return true;
            }
            return false;
        }

        @Override
        public boolean isEnabled() {
            IcyUndoManager undoManager = Icy.getMainInterface().getUndoManager();
            if (super.isEnabled() && undoManager != null) {
                return undoManager.canUndo();
            }
            return false;
        }
    };

    public static IcyAbstractAction getConvertSequenceAction(DataType dataType, boolean scaled) {
        switch (dataType) {
            case UBYTE: {
                if (scaled) {
                    return convertUByteScaledSequenceAction;
                }
                return convertUByteSequenceAction;
            }
            case BYTE: {
                if (scaled) {
                    return convertByteScaledSequenceAction;
                }
                return convertByteSequenceAction;
            }
            case USHORT: {
                if (scaled) {
                    return convertUShortScaledSequenceAction;
                }
                return convertUShortSequenceAction;
            }
            case SHORT: {
                if (scaled) {
                    return convertShortScaledSequenceAction;
                }
                return convertShortSequenceAction;
            }
            case UINT: {
                if (scaled) {
                    return convertUIntScaledSequenceAction;
                }
                return convertUIntSequenceAction;
            }
            case INT: {
                if (scaled) {
                    return convertIntScaledSequenceAction;
                }
                return convertIntSequenceAction;
            }
            case FLOAT: {
                if (scaled) {
                    return convertFloatScaledSequenceAction;
                }
                return convertFloatSequenceAction;
            }
            case DOUBLE: {
                if (scaled) {
                    return convertDoubleScaledSequenceAction;
                }
                return convertDoubleSequenceAction;
            }
        }
        return null;
    }

    public static List<IcyAbstractAction> getAllActions() {
        ArrayList<IcyAbstractAction> result = new ArrayList<IcyAbstractAction>();
        for (Field field : SequenceOperationActions.class.getFields()) {
            Class<?> type = field.getType();
            try {
                if (ClassUtil.isSubClass(type, IcyAbstractAction[].class)) {
                    result.addAll(Arrays.asList((IcyAbstractAction[])field.get(null)));
                    continue;
                }
                if (!ClassUtil.isSubClass(type, IcyAbstractAction.class)) continue;
                result.add((IcyAbstractAction)field.get(null));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    static class SequenceConvertAction
    extends IcyAbstractAction {
        private static final long serialVersionUID = 614601313456867774L;
        final DataType dataType;
        final boolean scaled;

        public SequenceConvertAction(DataType dataType, boolean scaled) {
            super(dataType.toString(true), new IcyIcon(ResourceUtil.ICON_BAND_RIGHT), "Convert to " + dataType.toString(true), "Convert sequence data type to " + dataType.toString(true), true, "Converting sequence to " + dataType.toString(false) + " ...");
            this.dataType = dataType;
            this.scaled = scaled;
        }

        @Override
        public boolean doAction(ActionEvent e) {
            Sequence sequence;
            final Viewer viewer = Icy.getMainInterface().getActiveViewer();
            if (viewer != null && (sequence = viewer.getSequence()) != null) {
                try {
                    final Sequence out = SequenceUtil.convertToType(Icy.getMainInterface().getActiveSequence(), this.dataType, this.scaled);
                    ThreadUtil.invokeLater(new Runnable(){
                        final /* synthetic */ SequenceConvertAction this$0;
                        {
                            this.this$0 = this$0;
                        }

                        @Override
                        public void run() {
                            Viewer vout = new Viewer(out);
                            vout.getLut().setColorMaps(viewer.getLut(), false);
                        }
                    });
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return true;
            }
            return false;
        }

        @Override
        public boolean isEnabled() {
            return super.isEnabled() && Icy.getMainInterface().getActiveSequence() != null;
        }
    }

    static class SequenceColorAction
    extends IcyAbstractAction {
        private static final long serialVersionUID = 3775617713982984867L;
        private static final Image[] images = new Image[]{null, ResourceUtil.ICON_RGB_COLOR, ResourceUtil.ICON_ARGB_COLOR, null, null, null, null, null, null, null, ResourceUtil.ICON_GRAY_COLOR, null, null, null, null, null};
        private static final String[] names = new String[]{null, "RGB image", "ARGB image", null, null, null, null, null, null, null, "Gray image", null, null, null, null, null};
        private static final String[] titles = new String[]{null, "Build RGB image", "Build ARGB image", null, null, null, null, null, null, null, "Build gray image", null, null, null, null, null};
        private static final String[] tooltips = new String[]{null, "Create a RGB color rendered version of the current sequence.\nResulting sequence is 3 channels with unsigned byte (8 bits) data type.", "Create an ARGB color (support transparency) rendered version of the current sequence.\nResulting sequence is 4 channels with unsigned byte (8 bits) data type.", null, null, null, null, null, null, null, "Create a gray rendered version of the current sequence.\nResulting sequence is single channel with unsigned byte (8 bits) data type.", null, null, null, null, null};
        private static final String[] processMessages = new String[]{null, "Converting to RGB image...", "Converting to ARGB image...", null, null, null, null, null, null, null, "Converting to gray image...", null, null, null, null, null};
        final int imageType;

        public SequenceColorAction(int imageType) {
            super(names[imageType], new IcyIcon(images[imageType], false), titles[imageType], tooltips[imageType], true, processMessages[imageType]);
            this.imageType = imageType;
        }

        @Override
        public boolean doAction(ActionEvent e) {
            Sequence sequence;
            Viewer viewer = Icy.getMainInterface().getActiveViewer();
            if (viewer != null && (sequence = viewer.getSequence()) != null) {
                try {
                    Sequence out = SequenceUtil.convertColor(sequence, this.imageType, viewer.getLut());
                    Icy.getMainInterface().addSequence(out);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return true;
            }
            return false;
        }

        @Override
        public boolean isEnabled() {
            Sequence sequence = Icy.getMainInterface().getActiveSequence();
            return super.isEnabled() && sequence != null && !sequence.isEmpty();
        }
    }

    public static class ExtractChannelAction
    extends IcyAbstractAction {
        private static final long serialVersionUID = -8722922231336771871L;
        final int channel;

        public ExtractChannelAction(int channel) {
            super(channel == -1 ? "all channels" : "channel " + channel, new IcyIcon(ResourceUtil.ICON_INDENT_DECREASE), channel == -1 ? "Extract all channels" : "Extract channel " + channel, channel == -1 ? "Separate all channels of active sequence" : "Create a new single channel sequence from channel " + channel + " of active sequence", true, channel == -1 ? "Extracting channel(s)..." : "Extracting channel " + channel + "...");
            this.channel = channel;
        }

        @Override
        public boolean doAction(ActionEvent e) {
            Sequence sequence = Icy.getMainInterface().getActiveSequence();
            if (sequence != null) {
                try {
                    if (this.channel == -1) {
                        for (int c = 0; c < sequence.getSizeC(); ++c) {
                            Icy.getMainInterface().addSequence(SequenceUtil.extractChannel(sequence, c));
                        }
                    } else {
                        Icy.getMainInterface().addSequence(SequenceUtil.extractChannel(sequence, this.channel));
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return true;
            }
            return false;
        }

        @Override
        public boolean isEnabled() {
            Sequence seq = Icy.getMainInterface().getActiveSequence();
            return super.isEnabled() && seq != null && this.channel < seq.getSizeC();
        }
    }

    public static class RemoveChannelAction
    extends IcyAbstractAction {
        private static final long serialVersionUID = 66288944320765300L;
        final int channel;

        public RemoveChannelAction(int channel) {
            super("channel " + channel, new IcyIcon(ResourceUtil.ICON_INDENT_REMOVE), "Remove channel " + channel, "Remove channel " + channel + " from active sequence", true, "Removing channel " + channel + "...");
            this.channel = channel;
        }

        @Override
        public boolean doAction(ActionEvent e) {
            Sequence sequence = Icy.getMainInterface().getActiveSequence();
            if (sequence != null) {
                try {
                    boolean canUndo = sequence.createUndoPoint("Channel " + this.channel + "removed");
                    if (!canUndo && !IdConfirmDialog.confirm("Not enough memory to undo the operation, do you want to continue ?", "ChannelRemoveNoUndoConfirm")) {
                        return false;
                    }
                    SequenceUtil.removeChannel(sequence, this.channel);
                    if (!canUndo) {
                        sequence.clearUndoManager();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return true;
            }
            return false;
        }

        @Override
        public boolean isEnabled() {
            Sequence seq = Icy.getMainInterface().getActiveSequence();
            return super.isEnabled() && seq != null && this.channel < seq.getSizeC();
        }
    }

    public static class MergeDimensionAction
    extends IcyAbstractAction {
        private static final long serialVersionUID = -3859065456632266213L;
        private static final String[] titles = new String[]{null, null, null, "Merge channels", "Merge Z slices", "Merge T frames"};
        private static final String[] tooltips = new String[]{null, null, null, "Merge channels from severals input sequences to build a new sequence.", "Merge Z slices from severals input sequences to build a new sequence.", "Merge T frames from severals input sequences to build a new sequence."};
        final DimensionId dim;

        public MergeDimensionAction(DimensionId dim) {
            super("Merge...", new IcyIcon(ResourceUtil.ICON_INDENT_INCREASE), titles[dim.ordinal()], tooltips[dim.ordinal()]);
            this.dim = dim;
        }

        @Override
        public boolean doAction(ActionEvent e) {
            new SequenceDimensionMergeFrame(this.dim);
            return true;
        }
    }

    public static class ToggleVirtualSequenceAction
    extends IcyAbstractAction {
        private static final long serialVersionUID = -2210853124199344868L;

        public ToggleVirtualSequenceAction(boolean selected) {
            super("Virtual", new IcyIcon(ResourceUtil.ICON_HDD_STREAM), "Enable/Disable virtual mode (data streaming) for this sequence");
            this.setSelected(selected);
            this.setBgProcess(true);
        }

        public ToggleVirtualSequenceAction() {
            this(false);
        }

        @Override
        public boolean doAction(ActionEvent e) {
            JToggleButton btn = e.getSource() instanceof JToggleButton ? (JToggleButton)e.getSource() : null;
            boolean value = btn != null ? btn.isSelected() : this.isSelected();
            Sequence sequence = Icy.getMainInterface().getActiveSequence();
            boolean result = false;
            String errMess = "";
            try {
                if (sequence != null) {
                    sequence.setVirtual(value);
                }
                result = true;
            }
            catch (OutOfMemoryError error) {
                errMess = "Not enough available memory to put back the sequence in memory (still in virtual state).";
                result = false;
            }
            catch (UnsupportedOperationException error) {
                errMess = "Image cache engine is disable.";
                result = false;
            }
            catch (Throwable error) {
                errMess = error.getMessage();
                result = false;
            }
            if (!result) {
                if (!value) {
                    new FailedAnnounceFrame(errMess);
                }
                if (btn != null) {
                    btn.setSelected(!value);
                }
                this.setSelected(!value);
            }
            if (btn != null) {
                if (btn.isSelected()) {
                    btn.setToolTipText("Disable virtual sequence (caching)");
                } else {
                    btn.setToolTipText("Enable virtual sequence (caching)");
                }
            }
            return result;
        }

        @Override
        public void setSelected(boolean value) {
            super.setSelected(value);
            if (!ImageCache.isEnabled()) {
                this.setDescription("Image cache is disabled, cannot use virtual sequence");
            } else if (value) {
                this.setDescription("Disable virtual sequence (caching)");
            } else {
                this.setDescription("Enable virtual sequence (caching)");
            }
        }

        @Override
        public boolean isEnabled() {
            return super.isEnabled() && ImageCache.isEnabled();
        }
    }
}

