/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.frame.error;

import icy.gui.component.IcyTextField;
import icy.preferences.GeneralPreferences;
import icy.system.IcyExceptionHandler;
import icy.util.StringUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.border.TitledBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class ErrorReportPanel
extends JPanel {
    private static final long serialVersionUID = -6672076887465746832L;
    JTextPane errorMessageTextPane;
    JTextPane commentTextPane;
    IcyTextField emailTextField;
    JButton reportButton;
    JButton closeButton;
    JLabel label;

    public ErrorReportPanel(Icon icon, String title, String message) {
        this.initialize();
        if (!StringUtil.isEmpty(title)) {
            this.label.setText(title);
        }
        if (icon != null) {
            this.label.setIcon(icon);
        }
        try {
            this.errorMessageTextPane.getStyledDocument().insertString(this.errorMessageTextPane.getStyledDocument().getLength(), message, new SimpleAttributeSet());
        }
        catch (BadLocationException e) {
            System.err.println("PluginErrorReport(...) error :");
            IcyExceptionHandler.showErrorMessage(e, true);
        }
        this.errorMessageTextPane.setCaretPosition(0);
        final Document doc = this.commentTextPane.getDocument();
        try {
            SimpleAttributeSet attributes = new SimpleAttributeSet();
            StyleConstants.setItalic(attributes, true);
            StyleConstants.setForeground(attributes, Color.GRAY);
            doc.insertString(0, "Please type here your comment", attributes);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        this.commentTextPane.addMouseListener(new MouseAdapter(this){
            boolean firstClickDone = false;
            final /* synthetic */ ErrorReportPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!this.firstClickDone) {
                    this.this$0.commentTextPane.setText("");
                    SimpleAttributeSet attributes = new SimpleAttributeSet();
                    StyleConstants.setItalic(attributes, false);
                    StyleConstants.setForeground(attributes, Color.BLACK);
                    try {
                        doc.insertString(0, " ", attributes);
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                    this.firstClickDone = true;
                }
            }
        });
        this.emailTextField.setText(GeneralPreferences.getUserEmail());
    }

    ErrorReportPanel() {
        this(null, "Test", "An error occured");
    }

    private void initialize() {
        this.label = new JLabel("An error occured !", 0);
        this.errorMessageTextPane = new JTextPane();
        this.errorMessageTextPane.setEditable(false);
        this.errorMessageTextPane.setContentType("text/html");
        JScrollPane messageScrollPane = new JScrollPane(this.errorMessageTextPane);
        JPanel messagePanel = new JPanel();
        messagePanel.setBorder(new TitledBorder(null, "Message", 4, 2, null, null));
        messagePanel.setLayout(new BorderLayout(0, 0));
        messagePanel.add((Component)messageScrollPane, "Center");
        JPanel userPanel = new JPanel();
        userPanel.setBorder(new TitledBorder(null, "Comment", 4, 2, null, null));
        userPanel.setLayout(new BorderLayout(0, 0));
        this.reportButton = new JButton("Report");
        this.closeButton = new JButton("Close");
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.add(this.reportButton);
        buttonsPanel.add(this.closeButton);
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new BorderLayout(0, 0));
        bottomPanel.add((Component)userPanel, "Center");
        JPanel commentPanel = new JPanel();
        userPanel.add((Component)commentPanel, "Center");
        commentPanel.setLayout(new BorderLayout(0, 0));
        this.commentTextPane = new JTextPane();
        this.commentTextPane.setEditable(true);
        JScrollPane scComment = new JScrollPane(this.commentTextPane);
        commentPanel.add((Component)scComment, "North");
        scComment.setPreferredSize(new Dimension(23, 60));
        scComment.setMinimumSize(new Dimension(23, 60));
        JPanel emailPanel = new JPanel();
        userPanel.add((Component)emailPanel, "South");
        GridBagLayout gbl_emailPanel = new GridBagLayout();
        gbl_emailPanel.columnWidths = new int[]{0, 0, 0};
        gbl_emailPanel.rowHeights = new int[]{0, 0};
        gbl_emailPanel.columnWeights = new double[]{0.0, 1.0, Double.MIN_VALUE};
        gbl_emailPanel.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        emailPanel.setLayout(gbl_emailPanel);
        JLabel lblEmail = new JLabel("Your email");
        GridBagConstraints gbc_lblEmail = new GridBagConstraints();
        gbc_lblEmail.insets = new Insets(0, 0, 0, 5);
        gbc_lblEmail.anchor = 17;
        gbc_lblEmail.gridx = 0;
        gbc_lblEmail.gridy = 0;
        emailPanel.add((Component)lblEmail, gbc_lblEmail);
        this.emailTextField = new IcyTextField();
        this.emailTextField.setToolTipText("You can enter your email so the developer can contact you if you wish");
        GridBagConstraints gbc_emailTextField = new GridBagConstraints();
        gbc_emailTextField.fill = 2;
        gbc_emailTextField.gridx = 1;
        gbc_emailTextField.gridy = 0;
        emailPanel.add((Component)this.emailTextField, gbc_emailTextField);
        this.emailTextField.setColumns(10);
        bottomPanel.add((Component)buttonsPanel, "South");
        this.setLayout(new BorderLayout(0, 0));
        this.add((Component)this.label, "North");
        this.add((Component)messagePanel, "Center");
        this.add((Component)bottomPanel, "South");
    }

    public String getReportMessage() throws BadLocationException {
        String email = this.emailTextField.getText();
        Document commentDoc = this.commentTextPane.getDocument();
        Document errorDoc = this.errorMessageTextPane.getDocument();
        String comment = commentDoc.getText(0, commentDoc.getLength());
        String result = "";
        if (!StringUtil.isEmpty(email)) {
            result = result + "Email: " + email + "\n";
            GeneralPreferences.setUserEmail(email);
        }
        if (!StringUtil.isEmpty(comment)) {
            result = result + "Comment:\n" + comment + "\n\n";
        }
        result = result + errorDoc.getText(0, errorDoc.getLength());
        return result;
    }
}

