/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.util;

import icy.common.listener.weak.WeakComponentListener;
import icy.common.listener.weak.WeakIcyFrameListener;
import icy.common.listener.weak.WeakWindowListener;
import icy.gui.component.ExternalizablePanel;
import icy.gui.frame.IcyFrame;
import icy.gui.frame.IcyFrameAdapter;
import icy.gui.frame.IcyFrameEvent;
import icy.gui.main.MainFrame;
import icy.gui.util.ComponentUtil;
import icy.preferences.IcyPreferences;
import icy.preferences.XMLPreferences;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JComponent;
import javax.swing.JFrame;

public class WindowPositionSaver {
    private static final String ID_EXTERNALIZED = "Externalized";
    private static final String ID_PANELIZED = "Panelized";
    private static final String ID_XC = "XC";
    private static final String ID_YC = "YC";
    private static final String ID_WC = "WidthC";
    private static final String ID_HC = "HeightC";
    private static final String ID_XI = "XI";
    private static final String ID_YI = "YI";
    private static final String ID_WI = "WidthI";
    private static final String ID_HI = "HeightI";
    private static final String ID_MAXIMIZEDI = "MaximizedI";
    private static final String ID_XE = "XE";
    private static final String ID_YE = "YE";
    private static final String ID_WE = "WidthE";
    private static final String ID_HE = "HeightE";
    private static final String ID_MAXIMIZEDE = "MaximizedE";
    final XMLPreferences preferences;
    private final MainFrame mainFrame;
    private final IcyFrame icyFrame;
    private final ExternalizablePanel extPanel;
    private final JFrame jFrame;
    private final JComponent component;
    private final boolean hasLoc;
    private final boolean hasDim;
    final WindowAdapter windowAdapter;
    final IcyFrameAdapter icyFrameAdapter;
    final ComponentAdapter componentAdapter;
    final ExternalizablePanel.StateListener stateListener;

    private WindowPositionSaver(MainFrame mainFrame, IcyFrame icyFrame, final ExternalizablePanel extPanel, JFrame jFrame, JComponent component, String key, Point defLoc, Dimension defDim) {
        this.preferences = IcyPreferences.root().node(key);
        this.mainFrame = mainFrame;
        this.icyFrame = icyFrame;
        this.extPanel = extPanel;
        this.jFrame = jFrame;
        this.component = component;
        this.hasLoc = defLoc != null;
        boolean bl = this.hasDim = defDim != null;
        if (this.hasLoc) {
            this.loadLocation(defLoc);
        }
        if (this.hasDim) {
            this.loadDimension(defDim);
        }
        this.loadState();
        this.componentAdapter = new ComponentAdapter(this){
            final /* synthetic */ WindowPositionSaver this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void componentResized(ComponentEvent e) {
                if (extPanel == null || e.getSource() == extPanel) {
                    this.this$0.saveAll();
                }
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                if (extPanel == null || e.getSource() == extPanel) {
                    this.this$0.saveAll();
                }
            }

            @Override
            public void componentShown(ComponentEvent e) {
                this.this$0.saveAll();
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                this.this$0.saveAll();
            }
        };
        this.windowAdapter = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                WindowPositionSaver.this.saveAll();
            }
        };
        this.icyFrameAdapter = new IcyFrameAdapter(){

            @Override
            public void icyFrameClosing(IcyFrameEvent e) {
                WindowPositionSaver.this.saveAll();
            }
        };
        this.stateListener = new ExternalizablePanel.StateListener(){

            @Override
            public void stateChanged(ExternalizablePanel source, boolean externalized) {
                WindowPositionSaver.this.saveAll();
            }
        };
        if (mainFrame != null) {
            mainFrame.addWindowListener(new WeakWindowListener(this.windowAdapter));
            mainFrame.addComponentListener(new WeakComponentListener(this.componentAdapter));
        } else if (icyFrame != null) {
            icyFrame.addFrameListener(new WeakIcyFrameListener(this.icyFrameAdapter));
            icyFrame.addComponentListener(new WeakComponentListener(this.componentAdapter));
        } else if (extPanel != null) {
            extPanel.addComponentListener(new WeakComponentListener(this.componentAdapter));
            extPanel.addStateListener(new ExternalizablePanel.WeakStateListener(this.stateListener));
            extPanel.getFrame().addFrameListener(new WeakIcyFrameListener(this.icyFrameAdapter));
            extPanel.getFrame().addComponentListener(new WeakComponentListener(this.componentAdapter));
        } else if (jFrame != null) {
            jFrame.addWindowListener(new WeakWindowListener(this.windowAdapter));
            jFrame.addComponentListener(new WeakComponentListener(this.componentAdapter));
        } else if (component != null) {
            component.addComponentListener(new WeakComponentListener(this.componentAdapter));
        }
        this.checkVisibility();
    }

    public WindowPositionSaver(MainFrame frame, String key, Point defLoc, Dimension defDim) {
        this(frame, null, null, null, null, key, defLoc, defDim);
    }

    public WindowPositionSaver(MainFrame frame, String key, Point defLoc) {
        this(frame, null, null, null, null, key, defLoc, null);
    }

    public WindowPositionSaver(MainFrame frame, String key, Dimension defDim) {
        this(frame, null, null, null, null, key, null, defDim);
    }

    public WindowPositionSaver(IcyFrame frame, String key, Point defLoc, Dimension defDim) {
        this(null, frame, null, null, null, key, defLoc, defDim);
    }

    public WindowPositionSaver(IcyFrame frame, String key, Point defLoc) {
        this(null, frame, null, null, null, key, defLoc, null);
    }

    public WindowPositionSaver(IcyFrame frame, String key, Dimension defDim) {
        this(null, frame, null, null, null, key, null, defDim);
    }

    public WindowPositionSaver(ExternalizablePanel extPanel, String key, Point defLoc, Dimension defDim) {
        this(null, null, extPanel, null, null, key, defLoc, defDim);
    }

    public WindowPositionSaver(ExternalizablePanel extPanel, String key, Point defLoc) {
        this(null, null, extPanel, null, null, key, defLoc, null);
    }

    public WindowPositionSaver(ExternalizablePanel extPanel, String key, Dimension defDim) {
        this(null, null, extPanel, null, null, key, null, defDim);
    }

    public WindowPositionSaver(JFrame frame, String key, Point defLoc, Dimension defDim) {
        this(null, null, null, frame, null, key, defLoc, defDim);
    }

    public WindowPositionSaver(JFrame frame, String key, Point defLoc) {
        this(null, null, null, frame, null, key, defLoc, null);
    }

    public WindowPositionSaver(JFrame frame, String key, Dimension defDim) {
        this(null, null, null, frame, null, key, null, defDim);
    }

    public WindowPositionSaver(JComponent component, String key, Point defLoc, Dimension defDim) {
        this(null, null, null, null, component, key, defLoc, defDim);
    }

    public WindowPositionSaver(JComponent component, String key, Point defLoc) {
        this(null, null, null, null, component, key, defLoc, null);
    }

    public WindowPositionSaver(JComponent component, String key, Dimension defDim) {
        this(null, null, null, null, component, key, null, defDim);
    }

    public XMLPreferences getPreferences() {
        return this.preferences;
    }

    public void loadLocation(Point defaultPos) {
        int y;
        int x;
        if (defaultPos == null) {
            x = 0;
            y = 0;
        } else {
            x = defaultPos.x;
            y = defaultPos.y;
        }
        Point positionC = new Point(this.preferences.getInt(ID_XC, x), this.preferences.getInt(ID_YC, y));
        Point positionI = new Point(this.preferences.getInt(ID_XI, x), this.preferences.getInt(ID_YI, y));
        Point positionE = new Point(this.preferences.getInt(ID_XE, x), this.preferences.getInt(ID_YE, y));
        if (this.mainFrame != null) {
            this.mainFrame.setLocation(positionE);
        } else if (this.icyFrame != null) {
            this.icyFrame.setLocationInternal(positionI);
            this.icyFrame.setLocationExternal(positionE);
        } else if (this.extPanel != null) {
            this.extPanel.setLocation(positionC);
            IcyFrame f = this.extPanel.getFrame();
            f.setLocationInternal(positionI);
            f.setLocationExternal(positionE);
        } else if (this.jFrame != null) {
            this.jFrame.setLocation(positionE);
        } else if (this.component != null) {
            this.component.setLocation(positionC);
        }
    }

    public void loadDimension(Dimension defaultDim) {
        int h;
        int w;
        if (defaultDim == null) {
            w = 300;
            h = 300;
        } else {
            w = defaultDim.width;
            h = defaultDim.height;
        }
        int widthC = Math.max(this.preferences.getInt(ID_WC, w), 10);
        int heightC = Math.max(this.preferences.getInt(ID_HC, h), 10);
        int widthI = Math.max(this.preferences.getInt(ID_WI, w), 10);
        int heightI = Math.max(this.preferences.getInt(ID_HI, h), 10);
        int widthE = Math.max(this.preferences.getInt(ID_WE, w), 10);
        int heightE = Math.max(this.preferences.getInt(ID_HE, h), 10);
        Dimension dimC = new Dimension(widthC, heightC);
        Dimension dimI = new Dimension(widthI, heightI);
        Dimension dimE = new Dimension(widthE, heightE);
        if (this.mainFrame != null) {
            this.mainFrame.setSize(dimE);
        } else if (this.icyFrame != null) {
            this.icyFrame.setPreferredSizeExternal(dimE);
            this.icyFrame.setSizeExternal(dimE);
            this.icyFrame.setPreferredSizeInternal(dimI);
            this.icyFrame.setSizeInternal(dimI);
        } else if (this.extPanel != null) {
            this.extPanel.setPreferredSize(dimC);
            IcyFrame f = this.extPanel.getFrame();
            f.setPreferredSizeExternal(dimE);
            f.setSizeExternal(dimE);
            f.setPreferredSizeInternal(dimI);
            f.setSizeInternal(dimI);
        } else if (this.jFrame != null) {
            this.jFrame.setPreferredSize(dimE);
            this.jFrame.setSize(dimE);
        } else if (this.component != null) {
            this.component.setPreferredSize(dimC);
        }
    }

    public void loadState() {
        boolean externalized = this.preferences.getBoolean(ID_EXTERNALIZED, false);
        boolean panelized = this.preferences.getBoolean(ID_PANELIZED, true);
        boolean maximizedE = this.preferences.getBoolean(ID_MAXIMIZEDE, false);
        boolean maximizedI = this.preferences.getBoolean(ID_MAXIMIZEDI, false);
        if (this.mainFrame != null) {
            ComponentUtil.setMaximized((Frame)((Object)this.mainFrame), maximizedE);
        } else if (this.icyFrame != null) {
            if (externalized) {
                this.icyFrame.externalize();
            } else {
                this.icyFrame.internalize();
            }
            this.icyFrame.setMaximizedExternal(maximizedE);
            this.icyFrame.setMaximizedInternal(maximizedI);
        } else if (this.extPanel != null) {
            IcyFrame f = this.extPanel.getFrame();
            if (externalized) {
                f.externalize();
            } else {
                f.internalize();
            }
            f.setMaximizedExternal(maximizedE);
            f.setMaximizedInternal(maximizedI);
            if (panelized) {
                this.extPanel.internalize();
            } else {
                this.extPanel.externalize();
            }
        } else if (this.jFrame != null) {
            ComponentUtil.setMaximized(this.jFrame, maximizedE);
        }
    }

    public void checkVisibility() {
        if (!this.hasLoc) {
            return;
        }
        if (this.icyFrame != null) {
            if (this.icyFrame.getVisibleRect().isEmpty()) {
                Point location = this.icyFrame.getLocation();
                if (location.x < 0 || location.x > 700 || location.y < 0 || location.y > 500) {
                    this.icyFrame.setLocation(100, 100);
                }
            }
        } else if (this.extPanel != null) {
            if (this.extPanel.getVisibleRect().isEmpty()) {
                Point location = this.extPanel.getLocation();
                if (location.x < 0 || location.x > 500 || location.y < 0 || location.y > 300) {
                    this.extPanel.setLocation(100, 100);
                }
            }
        } else if (this.component != null && this.component.getVisibleRect().isEmpty()) {
            Point location = this.component.getLocation();
            if (location.x < 0 || location.x > 500 || location.y < 0 || location.y > 300) {
                this.component.setLocation(100, 100);
            }
        }
    }

    public void saveLocation() {
        if (this.mainFrame != null) {
            if (!ComponentUtil.isMaximized((Frame)((Object)this.mainFrame)) && !ComponentUtil.isMinimized((Frame)((Object)this.mainFrame))) {
                this.preferences.putInt(ID_XE, this.mainFrame.getX());
                this.preferences.putInt(ID_YE, this.mainFrame.getY());
            }
        } else if (this.icyFrame != null) {
            if (!this.icyFrame.isMaximizedExternal() && !this.icyFrame.isMinimizedExternal()) {
                this.preferences.putInt(ID_XE, this.icyFrame.getXExternal());
                this.preferences.putInt(ID_YE, this.icyFrame.getYExternal());
            }
            if (!this.icyFrame.isMaximizedInternal() && !this.icyFrame.isMinimizedInternal()) {
                this.preferences.putInt(ID_XI, this.icyFrame.getXInternal());
                this.preferences.putInt(ID_YI, this.icyFrame.getYInternal());
            }
        } else if (this.extPanel != null) {
            this.preferences.putInt(ID_XC, this.extPanel.getX());
            this.preferences.putInt(ID_YC, this.extPanel.getY());
            IcyFrame f = this.extPanel.getFrame();
            if (!f.isMaximizedExternal() && !f.isMinimizedExternal()) {
                this.preferences.putInt(ID_XE, f.getXExternal());
                this.preferences.putInt(ID_YE, f.getYExternal());
            }
            if (!f.isMaximizedInternal() && !f.isMinimizedInternal()) {
                this.preferences.putInt(ID_XI, f.getXInternal());
                this.preferences.putInt(ID_YI, f.getYInternal());
            }
        } else if (this.jFrame != null) {
            if (!ComponentUtil.isMaximized(this.jFrame) && !ComponentUtil.isMinimized(this.jFrame)) {
                this.preferences.putInt(ID_XE, this.jFrame.getX());
                this.preferences.putInt(ID_YE, this.jFrame.getY());
            }
        } else if (this.component != null) {
            this.preferences.putInt(ID_XC, this.component.getX());
            this.preferences.putInt(ID_YC, this.component.getY());
        }
    }

    public void saveDimension() {
        if (this.mainFrame != null) {
            if (!ComponentUtil.isMaximized((Frame)((Object)this.mainFrame)) && !ComponentUtil.isMinimized((Frame)((Object)this.mainFrame))) {
                Dimension dim = this.mainFrame.isDetachedMode() ? new Dimension(this.mainFrame.getWidth(), this.mainFrame.getPreviousHeight()) : this.mainFrame.getSize();
                this.preferences.putInt(ID_WE, dim.width);
                this.preferences.putInt(ID_HE, dim.height);
            }
        } else if (this.icyFrame != null) {
            if (!this.icyFrame.isMaximizedExternal() && !this.icyFrame.isMinimizedExternal()) {
                this.preferences.putInt(ID_WE, this.icyFrame.getWidthExternal());
                this.preferences.putInt(ID_HE, this.icyFrame.getHeightExternal());
            }
            if (!this.icyFrame.isMaximizedInternal() && !this.icyFrame.isMinimizedInternal()) {
                this.preferences.putInt(ID_WI, this.icyFrame.getWidthInternal());
                this.preferences.putInt(ID_HI, this.icyFrame.getHeightInternal());
            }
        } else if (this.extPanel != null) {
            this.preferences.putInt(ID_WC, this.extPanel.getWidth());
            this.preferences.putInt(ID_HC, this.extPanel.getHeight());
            IcyFrame f = this.extPanel.getFrame();
            if (!f.isMaximizedExternal() && !f.isMinimizedExternal()) {
                this.preferences.putInt(ID_WE, f.getWidthExternal());
                this.preferences.putInt(ID_HE, f.getHeightExternal());
            }
            if (!f.isMaximizedInternal() && !f.isMinimizedInternal()) {
                this.preferences.putInt(ID_WI, f.getWidthInternal());
                this.preferences.putInt(ID_HI, f.getHeightInternal());
            }
        } else if (this.jFrame != null) {
            if (!ComponentUtil.isMaximized(this.jFrame) && !ComponentUtil.isMinimized(this.jFrame)) {
                this.preferences.putInt(ID_WE, this.jFrame.getWidth());
                this.preferences.putInt(ID_HE, this.jFrame.getHeight());
            }
        } else if (this.component != null) {
            this.preferences.putInt(ID_WC, this.component.getWidth());
            this.preferences.putInt(ID_HC, this.component.getHeight());
        }
    }

    public void saveState() {
        if (this.mainFrame != null) {
            boolean b = this.mainFrame.isDetachedMode() ? this.mainFrame.getPreviousMaximized() : ComponentUtil.isMaximized((Frame)((Object)this.mainFrame));
            this.preferences.putBoolean(ID_MAXIMIZEDE, b);
        }
        if (this.icyFrame != null) {
            this.preferences.putBoolean(ID_EXTERNALIZED, this.icyFrame.isExternalized());
            this.preferences.putBoolean(ID_MAXIMIZEDI, this.icyFrame.isMaximizedInternal());
            this.preferences.putBoolean(ID_MAXIMIZEDE, this.icyFrame.isMaximizedExternal());
        } else if (this.extPanel != null) {
            this.preferences.putBoolean(ID_PANELIZED, this.extPanel.isInternalized());
            IcyFrame f = this.extPanel.getFrame();
            this.preferences.putBoolean(ID_EXTERNALIZED, f.isExternalized());
            this.preferences.putBoolean(ID_MAXIMIZEDI, f.isMaximizedInternal());
            this.preferences.putBoolean(ID_MAXIMIZEDE, f.isMaximizedExternal());
        } else if (this.jFrame != null) {
            this.preferences.putBoolean(ID_MAXIMIZEDE, ComponentUtil.isMaximized(this.jFrame));
        }
    }

    public void saveAll() {
        if (this.hasLoc) {
            this.saveLocation();
        }
        if (this.hasDim) {
            this.saveDimension();
        }
        this.saveState();
    }
}

