/*
 * Decompiled with CFR 0.152.
 */
package icy.image.colormodel;

import icy.image.colormodel.IcyColorModel;
import icy.image.colorspace.IcyColorSpace;
import icy.image.lut.LUT;
import icy.type.DataType;

public class UByteColorModel
extends IcyColorModel {
    public UByteColorModel(int numComponents, int[] bits) {
        super(numComponents, DataType.UBYTE, bits);
    }

    public UByteColorModel(IcyColorSpace colorSpace, int[] bits) {
        super(colorSpace, DataType.UBYTE, bits);
    }

    @Override
    public int getRGB(Object pixel) {
        byte[] pix = (byte[])pixel;
        int[] scaledData = new int[this.numComponents];
        for (int comp = 0; comp < this.numComponents; ++comp) {
            scaledData[comp] = (int)this.colormapScalers[comp].scale(pix[comp] & 0xFF);
        }
        return this.getIcyColorSpace().toRGBUnnorm(scaledData);
    }

    @Override
    public int getRGB(Object pixel, LUT lut) {
        byte[] pix = (byte[])pixel;
        int[] scaledData = new int[this.numComponents];
        for (int comp = 0; comp < this.numComponents; ++comp) {
            scaledData[comp] = (int)lut.getLutChannel(comp).getScaler().scale(pix[comp] & 0xFF);
        }
        return lut.getColorSpace().toRGBUnnorm(scaledData);
    }

    @Override
    public int[] getComponents(Object pixel, int[] components, int offset) {
        int[] result;
        if (components == null) {
            result = new int[offset + this.numComponents];
        } else {
            if (components.length - offset < this.numComponents) {
                throw new IllegalArgumentException("Length of components array < number of components in model");
            }
            result = components;
        }
        byte[] data = (byte[])pixel;
        int len = data.length;
        for (int i = 0; i < len; ++i) {
            result[offset + i] = data[i] & 0xFF;
        }
        return result;
    }

    @Override
    public Object getDataElements(int[] components, int offset, Object obj) {
        if (components.length - offset < this.numComponents) {
            throw new IllegalArgumentException("Component array too small (should be " + this.numComponents);
        }
        int len = components.length;
        byte[] pixel = obj == null ? new byte[this.numComponents] : (byte[])obj;
        for (int i = 0; i < len; ++i) {
            pixel[i] = (byte)components[offset + i];
        }
        return pixel;
    }

    @Override
    public Object getDataElements(float[] normComponents, int offset, Object obj) {
        byte[] pixel = obj == null ? new byte[this.numComponents] : (byte[])obj;
        int c = 0;
        int nc = offset;
        while (c < this.numComponents) {
            pixel[c] = (byte)this.normalScalers[c].unscale(normComponents[nc]);
            ++c;
            ++nc;
        }
        return pixel;
    }

    @Override
    public float[] getNormalizedComponents(Object pixel, float[] normComponents, int normOffset) {
        float[] result = normComponents == null ? new float[this.numComponents + normOffset] : normComponents;
        byte[] data = (byte[])pixel;
        int c = 0;
        int nc = normOffset;
        while (c < this.numComponents) {
            result[nc] = (float)this.normalScalers[c].scale(data[c] & 0xFF);
            ++c;
            ++nc;
        }
        return result;
    }
}

