/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.blocks.lang;

import icy.file.xml.XMLPersistent;
import icy.gui.plugin.PluginErrorReport;
import icy.network.NetworkUtil;
import icy.plugin.PluginDescriptor;
import icy.plugin.PluginInstaller;
import icy.plugin.PluginRepositoryLoader;
import icy.plugin.abstract_.Plugin;
import icy.util.ClassUtil;
import icy.util.StringUtil;
import icy.util.XMLUtil;
import java.awt.Dimension;
import java.awt.Point;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.lang.Link;
import plugins.adufour.blocks.lang.Loop;
import plugins.adufour.blocks.lang.WorkFlow;
import plugins.adufour.blocks.tools.Display;
import plugins.adufour.blocks.tools.input.InputBlock;
import plugins.adufour.blocks.tools.output.OutputBlock;
import plugins.adufour.blocks.util.BlockListener;
import plugins.adufour.blocks.util.BlocksException;
import plugins.adufour.blocks.util.BlocksFinder;
import plugins.adufour.blocks.util.BlocksML;
import plugins.adufour.blocks.util.BlocksReloadedException;
import plugins.adufour.blocks.util.NoSuchVariableException;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.blocks.util.VarListListener;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarMutable;
import plugins.adufour.vars.lang.VarMutableArray;
import plugins.adufour.vars.util.MutableType;
import plugins.adufour.vars.util.VarListener;

public class BlockDescriptor
implements Runnable,
VarListener,
VarListListener,
XMLPersistent {
    private Integer id = this.hashCode();
    private Block block;
    private WorkFlow container;
    private final HashSet<BlockListener> listeners = new HashSet();
    public final VarList inputVars;
    public final VarList outputVars;
    private final Point location = new Point();
    private final Dimension dimension = new Dimension(0, 0);
    private boolean collapsed = false;
    private BlockStatus status = BlockStatus.DIRTY;
    private boolean finalBlock;
    private String definedName = null;
    private boolean keepResults = true;
    private String commandLineID = "";

    public BlockDescriptor() {
        this.inputVars = new VarList();
        this.inputVars.addVarListListener(this);
        this.outputVars = new VarList();
        this.outputVars.addVarListListener(this);
    }

    public BlockDescriptor(int ID, Block block) {
        this();
        this.block = block;
        try {
            block.declareInput(this.inputVars);
            block.declareOutput(this.outputVars);
        }
        catch (RuntimeException e) {
            String blockName = block.getClass().getName();
            String devId = blockName.substring("plugins.".length());
            devId = devId.substring(0, devId.indexOf(46));
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            pw.write("Unable to insert block: " + block.getClass().getName() + "\n");
            pw.write("Reason: " + e.getClass().getName() + ": " + e.getMessage() + "\n");
            pw.write("Stack trace:\n");
            e.printStackTrace(pw);
            PluginErrorReport.report(null, devId, sw.toString());
        }
        if (ID != -1) {
            this.id = ID;
        }
    }

    @Deprecated
    public BlockDescriptor(int ID, Block block, WorkFlow owner, Point location) {
        this(ID, block);
        this.container = owner;
        this.setLocation(location.x, location.y);
    }

    public void addInput(String uid, Var<?> variable) throws IllegalArgumentException {
        this.inputVars.add(uid, variable);
    }

    public void addOutput(String uid, Var<?> variable) throws IllegalArgumentException {
        this.outputVars.add(uid, variable);
    }

    public void addBlockListener(BlockListener listener) {
        this.listeners.add(listener);
    }

    public void addBlockPanelListener(BlockListener listener) {
        this.listeners.add(listener);
    }

    public void removeBlockListener(BlockListener listener) {
        this.listeners.remove(listener);
    }

    public void removeBlockPanelListener(BlockListener listener) {
        this.listeners.remove(listener);
    }

    public Block getBlock() {
        return this.block;
    }

    public WorkFlow getContainer() {
        return this.container;
    }

    public Dimension getDimension() {
        return this.dimension;
    }

    public Integer getID() {
        return this.id;
    }

    public Point getLocation() {
        return this.location;
    }

    public String getName() {
        String pluginName;
        String blockName = this.block.getClass().getSimpleName();
        if (this.block instanceof Plugin && ((Plugin)((Object)this.block)).getDescriptor() != null && !(pluginName = ((Plugin)((Object)this.block)).getDescriptor().getName()).equalsIgnoreCase(blockName)) {
            return pluginName;
        }
        if (blockName.endsWith("block")) {
            blockName = blockName.substring(0, blockName.lastIndexOf("block"));
        } else if (blockName.endsWith("Block")) {
            blockName = blockName.substring(0, blockName.lastIndexOf("Block"));
        }
        return BlocksFinder.getFlattened(blockName);
    }

    public BlockStatus getStatus() {
        return this.status;
    }

    public String getVarID(Var<?> variable) throws NoSuchVariableException {
        if (this.inputVars.contains(variable)) {
            String varID = this.inputVars.getID(variable);
            if (!this.isWorkFlow() || varID.contains(":")) {
                return varID;
            }
            return ((WorkFlow)this.block).getInputVarID(variable);
        }
        String varID = this.outputVars.getID(variable);
        if (!this.isWorkFlow() || varID.contains(":")) {
            return varID;
        }
        return ((WorkFlow)this.block).getOutputVarID(variable);
    }

    public boolean isCollapsed() {
        return this.collapsed;
    }

    public boolean isFinalBlock() {
        return this.finalBlock;
    }

    public boolean isLoop() {
        return this.block instanceof Loop;
    }

    public boolean isInput() {
        return this.block instanceof InputBlock;
    }

    public boolean isOutput() {
        return this.block instanceof OutputBlock;
    }

    public boolean isSingleBlock() {
        return this.block instanceof Display || this.block instanceof InputBlock || this.block instanceof OutputBlock;
    }

    public boolean isWorkFlow() {
        return this.block instanceof WorkFlow;
    }

    public boolean isTopLevelWorkFlow() {
        return this.isWorkFlow() && ((WorkFlow)this.block).isTopLevel();
    }

    public void setCollapsed(boolean collapsed) {
        if (this.collapsed == collapsed) {
            return;
        }
        this.collapsed = collapsed;
        for (BlockListener l : this.listeners) {
            l.blockCollapsed(this, collapsed);
        }
    }

    public void setContainer(WorkFlow container) {
        this.container = container;
    }

    public void setFinalBlock(boolean finalBlock) {
        this.finalBlock = finalBlock;
    }

    public void setDimension(int width, int height) {
        if (this.dimension.width == width && this.dimension.height == height) {
            return;
        }
        this.dimension.setSize(width, height);
        for (BlockListener l : this.listeners) {
            l.blockDimensionChanged(this, width, height);
        }
    }

    public void setID(int id) {
        this.id = id;
    }

    public <T> void setInput(String varID, T value) throws NoSuchVariableException {
        Var<T> input = this.inputVars.get(varID);
        if (input == null) {
            throw new NoSuchVariableException(this, varID);
        }
        input.setValue(value);
    }

    public void setLocation(int x, int y) {
        if (this.location.x == x && this.location.y == y) {
            return;
        }
        this.location.move(x, y);
        for (BlockListener l : this.listeners) {
            l.blockLocationChanged(this, x, y);
        }
    }

    public <T> void setOutput(String varID, T value) throws NoSuchVariableException {
        Var<T> output = this.outputVars.get(varID);
        if (output == null) {
            throw new NoSuchVariableException(this, varID);
        }
        output.setValue(value);
    }

    public void setStatus(BlockStatus newStatus) {
        BlockDescriptor wfDescriptor;
        if (this.status == newStatus) {
            return;
        }
        this.status = newStatus;
        for (BlockListener listener : this.listeners) {
            listener.blockStatusChanged(this, this.status);
        }
        if (this.status == BlockStatus.DIRTY && this.container != null && (wfDescriptor = this.container.getBlockDescriptor()).getStatus() != BlockStatus.RUNNING) {
            wfDescriptor.setStatus(BlockStatus.DIRTY);
        }
    }

    public void removeInput(Var<?> inputVar) {
        if (!this.inputVars.contains(inputVar)) {
            return;
        }
        this.inputVars.setVisible(inputVar, false);
        this.inputVars.remove(inputVar);
    }

    public void removeOutput(Var<?> outputVar) {
        if (!this.outputVars.contains(outputVar)) {
            return;
        }
        this.outputVars.setVisible(outputVar, false);
        this.outputVars.remove(outputVar);
    }

    public void reset() {
        this.setStatus(BlockStatus.DIRTY);
        for (Var<?> var : this.outputVars) {
            var.setValue(var.getDefaultValue());
        }
        if (this.isWorkFlow()) {
            ((WorkFlow)this.block).reset();
        }
    }

    @Override
    public void run() {
        if (this.keepResults && this.status == BlockStatus.READY) {
            return;
        }
        this.setStatus(BlockStatus.RUNNING);
        try {
            this.block.run();
            this.setStatus(this.keepResults ? BlockStatus.READY : BlockStatus.DIRTY);
        }
        catch (RuntimeException e) {
            BlockStatus error = BlockStatus.ERROR;
            error.setUserMessage(e.getMessage());
            this.setStatus(error);
            throw e;
        }
    }

    public void valueChanged(Var source, Object oldValue, Object newValue) {
        if (this.inputVars.contains(source)) {
            this.setStatus(BlockStatus.DIRTY);
        }
        for (BlockListener listener : this.listeners) {
            listener.blockVariableChanged(this, source, newValue);
        }
    }

    public void referenceChanged(Var source, Var oldReference, Var newReference) {
        this.setStatus(BlockStatus.DIRTY);
    }

    public String toString() {
        return this.getContainer().getBlockDescriptor().getName() + "." + this.getName();
    }

    @Override
    public void variableAdded(VarList list, Var<?> variable) {
        variable.addListener(this);
        for (BlockListener listener : this.listeners) {
            listener.blockVariableAdded(this, variable);
        }
    }

    @Override
    public void variableRemoved(VarList list, Var<?> variable) {
        variable.removeListener(this);
        for (BlockListener listener : this.listeners) {
            listener.blockVariableAdded(this, variable);
        }
    }

    private Class<? extends Block> installRequiredBlock(String pluginClassName, String blockType) throws ClassNotFoundException {
        Class<?> clazz = null;
        try {
            clazz = ClassUtil.findClass(blockType);
        }
        catch (ClassNotFoundException e) {
            if (!NetworkUtil.hasInternetAccess() || this.getClass().getClassLoader() == ClassLoader.getSystemClassLoader()) {
                throw new BlocksException("Plugin " + blockType + " is missing, but no internet connection is available.\nTry again later", true);
            }
            PluginDescriptor pd = PluginRepositoryLoader.getPlugin(pluginClassName);
            if (pd == null) {
                throw e;
            }
            PluginInstaller.install(pd, false);
            throw new BlocksReloadedException();
        }
        return clazz;
    }

    @Override
    public boolean loadFromXML(Node node) {
        boolean noWarnings = true;
        Element blockNode = (Element)node;
        String blockType = XMLUtil.getAttributeValue(blockNode, "blockType", null);
        try {
            Class<? extends Block> blockClass = this.installRequiredBlock(XMLUtil.getAttributeValue(blockNode, "className", null), blockType);
            this.block = blockClass.newInstance();
            if (this.block == null) {
                throw new BlocksException("Couldn't create block from class " + blockClass.getName(), true);
            }
            this.block.declareInput(this.inputVars);
            this.block.declareOutput(this.outputVars);
            this.setID(XMLUtil.getAttributeIntValue(blockNode, "ID", -1));
            int width = XMLUtil.getAttributeIntValue(blockNode, "width", 500);
            int height = XMLUtil.getAttributeIntValue(blockNode, "height", 500);
            this.setDimension(width, height);
            int xPos = XMLUtil.getAttributeIntValue(blockNode, "xLocation", -1);
            int yPos = XMLUtil.getAttributeIntValue(blockNode, "yLocation", -1);
            this.setLocation(xPos, yPos);
            Element varRoot = XMLUtil.getElement(blockNode, "variables");
            Element inVarRoot = XMLUtil.getElement(varRoot, "input");
            for (Element varNode : XMLUtil.getElements(inVarRoot)) {
                String type;
                String uid = XMLUtil.getAttributeValue(varNode, "ID", null);
                Var var = this.inputVars.get(uid);
                if (var == null) {
                    if (noWarnings) {
                        System.err.println("Error(s) while loading protocol:");
                        noWarnings = false;
                    }
                    System.err.println(new NoSuchVariableException(this, uid).getMessage());
                    continue;
                }
                if (var instanceof MutableType && (type = XMLUtil.getAttributeValue(varNode, "type", null)) != null) {
                    if (var instanceof VarMutable) {
                        Class<?> mutableType = BlocksML.getPrimitiveType(type);
                        if (mutableType == null) {
                            mutableType = Class.forName(type);
                        }
                        ((MutableType)((Object)var)).setType(mutableType);
                    } else if (var instanceof VarMutableArray) {
                        ((MutableType)((Object)var)).setType(Class.forName("[L" + type + ";"));
                    }
                }
                var.loadFromXML(varNode);
                this.inputVars.setVisible(var, XMLUtil.getAttributeBooleanValue(varNode, "visible", false));
            }
            Element outVarRoot = XMLUtil.getElement(varRoot, "output");
            for (Element varNode : XMLUtil.getElements(outVarRoot)) {
                String type;
                String uid = XMLUtil.getAttributeValue(varNode, "ID", null);
                Var var = this.outputVars.get(uid);
                if (var == null) {
                    if (noWarnings) {
                        System.err.println("Error(s) while loading protocol:");
                        noWarnings = false;
                    }
                    System.err.println(new NoSuchVariableException(this, uid).getMessage());
                    continue;
                }
                this.outputVars.setVisible(var, XMLUtil.getAttributeBooleanValue(varNode, "visible", false));
                if (!(var instanceof MutableType) || (type = XMLUtil.getAttributeValue(varNode, "type", null)) == null) continue;
                if (var instanceof VarMutable) {
                    Class<?> mutableType = BlocksML.getPrimitiveType(type);
                    ((MutableType)((Object)var)).setType(mutableType != null ? mutableType : Class.forName(type));
                    continue;
                }
                if (!(var instanceof VarMutableArray)) continue;
                ((MutableType)((Object)var)).setType(Class.forName("[L" + type + ";"));
            }
        }
        catch (ClassNotFoundException e1) {
            throw new BlocksException("Cannot create block (" + e1.getMessage() + ") => class not found", true);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return noWarnings;
    }

    @Override
    public boolean saveToXML(Node node) {
        return false;
    }

    public void setDefinedName(String s) {
        this.definedName = s;
    }

    public String getDefinedName() {
        if (this.definedName == null || this.definedName.isEmpty()) {
            return this.getName();
        }
        return this.definedName;
    }

    public static BlockDescriptor findBlockDescriptor(int blockId, List<BlockDescriptor> blocks) {
        for (BlockDescriptor bd : blocks) {
            if (bd.getID() != blockId) continue;
            return bd;
        }
        return null;
    }

    public static BlockDescriptor findInputBlockDescriptor(String commandLineId, List<BlockDescriptor> blocks) {
        for (BlockDescriptor block : blocks) {
            if (!block.isInput() || !StringUtil.equals(block.getCommandLineID(), commandLineId)) continue;
            return block;
        }
        return null;
    }

    public static BlockDescriptor findOutputBlockDescriptor(String commandLineId, List<BlockDescriptor> blocks) {
        for (BlockDescriptor block : blocks) {
            if (!block.isOutput() || !StringUtil.equals(block.getCommandLineID(), commandLineId)) continue;
            return block;
        }
        return null;
    }

    private static BlockDescriptor getBlockDescriptor(int blockId, Set<BlockDescriptor> bds) {
        for (BlockDescriptor bd : bds) {
            if (bd.getID() != blockId) continue;
            return bd;
        }
        return null;
    }

    private String getNewVarId(String oldVarId, Map<BlockDescriptor, BlockDescriptor> copies) {
        int index = oldVarId.indexOf(":");
        if (index == -1) {
            return oldVarId;
        }
        String result = "";
        int blockId = StringUtil.parseInt(oldVarId.substring(0, index), 0);
        BlockDescriptor bd = BlockDescriptor.getBlockDescriptor(blockId, copies.keySet());
        BlockDescriptor nbd = copies.get(bd);
        if (nbd != null) {
            result = nbd.getID().toString();
        }
        return result + ":" + this.getNewVarId(oldVarId.substring(index + 1), copies);
    }

    public BlockDescriptor clone(boolean embedding) {
        return this.clone(embedding, new HashMap<BlockDescriptor, BlockDescriptor>());
    }

    public BlockDescriptor clone(boolean embedding, Map<BlockDescriptor, BlockDescriptor> copies) {
        Var newVar;
        String oldID;
        Class<Block> blockClass = this.getBlock().getClass().asSubclass(Block.class);
        WorkFlow wf = null;
        WorkFlow wfCpy = null;
        BlockDescriptor cpy = null;
        Block newBlock = null;
        try {
            newBlock = blockClass.newInstance();
        }
        catch (InstantiationException e1) {
            e1.printStackTrace();
        }
        catch (IllegalAccessException e1) {
            e1.printStackTrace();
        }
        cpy = newBlock instanceof WorkFlow ? ((WorkFlow)newBlock).getBlockDescriptor() : new BlockDescriptor(-1, newBlock);
        cpy.setDefinedName(this.getDefinedName());
        cpy.setLocation(this.getLocation().x + 12, this.getLocation().y + 12);
        cpy.setDimension(this.getDimension().width, this.getDimension().height);
        cpy.setCollapsed(this.isCollapsed());
        for (Var<?> oldVar : this.inputVars) {
            oldID = this.inputVars.getID(oldVar);
            if (oldID.contains(":") && this.getBlock() instanceof WorkFlow) continue;
            newVar = cpy.inputVars.get(oldID);
            if (newVar == null) {
                newVar = new VarMutable(oldVar.getName(), oldVar.getType());
                cpy.inputVars.addRuntimeVariable(oldID, (VarMutable)newVar);
            } else {
                if (newVar instanceof VarMutable) {
                    ((VarMutable)newVar).setType(oldVar.getType());
                }
                ((Var)newVar).setValue(oldVar.getValue());
            }
            cpy.inputVars.setVisible(newVar, this.inputVars.isVisible(oldVar));
        }
        for (Var<?> oldVar : this.outputVars) {
            oldID = this.outputVars.getID(oldVar);
            if (oldID.contains(":") && this.getBlock() instanceof WorkFlow) continue;
            newVar = cpy.outputVars.get(oldID);
            if (newVar == null) {
                newVar = new VarMutable(oldVar.getName(), oldVar.getType());
                cpy.outputVars.addRuntimeVariable(oldID, (VarMutable)newVar);
            } else {
                if (newVar instanceof VarMutable) {
                    newVar.setType(oldVar.getType());
                }
                ((Var)newVar).setValue(oldVar.getValue());
            }
            cpy.outputVars.setVisible(newVar, this.outputVars.isVisible(oldVar));
        }
        if (this.getBlock() instanceof WorkFlow) {
            BlockDescriptor nbd;
            BlockDescriptor bd;
            String newVarID;
            String varID;
            int blockID;
            int index;
            String oldID2;
            BlockDescriptor tmp;
            wf = (WorkFlow)this.getBlock();
            wfCpy = (WorkFlow)cpy.getBlock();
            if (wf.getBlockSelection().isEmpty() || embedding) {
                for (BlockDescriptor bd2 : wf) {
                    tmp = bd2.clone(true, copies);
                    copies.put(bd2, tmp);
                    wfCpy.addBlock(tmp);
                    wfCpy.selectBlock(tmp);
                }
                BlockDescriptor.cloneLinks(wf.getLinksIterator(), copies, wfCpy);
            } else {
                for (BlockDescriptor bd2 : wf.getBlockSelection()) {
                    tmp = bd2.clone(true, copies);
                    copies.put(bd2, tmp);
                    wfCpy.addBlock(tmp);
                    wfCpy.selectBlock(tmp);
                }
                BlockDescriptor.cloneLinks(wf.getLinkSelection(), copies, wfCpy);
            }
            for (Var oldVar : this.inputVars) {
                oldID2 = this.inputVars.getID(oldVar);
                index = oldID2.indexOf(":");
                if (index == -1) continue;
                blockID = StringUtil.parseInt(oldID2.substring(0, index), 0);
                varID = oldID2.substring(index + 1);
                newVarID = this.getNewVarId(varID, copies);
                bd = wf.getBlockByID(blockID);
                nbd = copies.get(bd);
                Var inputVar = nbd.inputVars.get(newVarID);
                if (inputVar == null) continue;
                if (!cpy.inputVars.contains(inputVar)) {
                    cpy.addInput(wfCpy.getInputVarID(inputVar), inputVar);
                }
                cpy.inputVars.setVisible(inputVar, this.inputVars.isVisible(oldVar));
            }
            for (Var oldVar : this.outputVars) {
                oldID2 = this.outputVars.getID(oldVar);
                index = oldID2.indexOf(":");
                if (index == -1) continue;
                blockID = StringUtil.parseInt(oldID2.substring(0, index), 0);
                varID = oldID2.substring(index + 1);
                newVarID = this.getNewVarId(varID, copies);
                bd = wf.getBlockByID(blockID);
                nbd = copies.get(bd);
                Var outputVar = nbd.outputVars.get(newVarID);
                if (outputVar == null) continue;
                if (!cpy.outputVars.contains(outputVar)) {
                    cpy.addOutput(wfCpy.getInputVarID(outputVar), outputVar);
                }
                cpy.outputVars.setVisible(outputVar, this.outputVars.isVisible(oldVar));
            }
        }
        return cpy;
    }

    private static void cloneLinks(Iterable<Link<?>> iterable, Map<BlockDescriptor, BlockDescriptor> copies, WorkFlow dest) {
        for (Link<?> l : iterable) {
            if (l.srcBlock.getBlock() instanceof Loop || l.dstBlock.getBlock() instanceof Loop) {
                System.err.println("Warning : cannot copy a link to a loop variable");
                continue;
            }
            if (l.srcBlock.getBlock() instanceof WorkFlow || l.dstBlock.getBlock() instanceof WorkFlow) {
                System.err.println("Warning : cannot copy a link to an exposed variable");
                continue;
            }
            try {
                dest.addLink(copies.get(l.srcBlock), copies.get((Object)l.srcBlock).inputVars.get(l.srcBlock.inputVars.getID(l.srcVar)), copies.get(l.dstBlock), copies.get((Object)l.dstBlock).inputVars.get(l.dstBlock.inputVars.getID(l.dstVar)));
            }
            catch (NoSuchVariableException nsve) {
                dest.addLink(copies.get(l.srcBlock), copies.get((Object)l.srcBlock).outputVars.get(l.srcBlock.outputVars.getID(l.srcVar)), copies.get(l.dstBlock), copies.get((Object)l.dstBlock).inputVars.get(l.dstBlock.inputVars.getID(l.dstVar)));
            }
        }
    }

    public boolean keepsResults() {
        return this.keepResults;
    }

    public void keepResults(boolean keep) {
        this.keepResults = keep;
    }

    public String getCommandLineID() {
        return this.commandLineID;
    }

    public void setCommandLineID(String id) {
        this.commandLineID = id;
    }

    public Var<?> getVariable() {
        return this.inputVars.first();
    }

    public static enum BlockStatus {
        DIRTY("This block is ready to run"),
        RUNNING("This block is currently running..."),
        READY("This block is up to date"),
        ERROR("This block did not run properly");

        public final String defaultErrorMessage;
        private String optionalUserMessage = "";

        private BlockStatus(String message) {
            this.defaultErrorMessage = message;
        }

        public String getUserMessage() {
            return this.optionalUserMessage;
        }

        public void setUserMessage(String message) {
            this.optionalUserMessage = message != null ? message : "";
        }

        public String toString() {
            return this.defaultErrorMessage + (this.optionalUserMessage.isEmpty() ? "" : ":\n" + this.optionalUserMessage);
        }
    }
}

