/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.blocks.lang;

import icy.common.exception.UnsupportedFormatException;
import icy.file.Loader;
import icy.file.SequenceFileImporter;
import icy.sequence.MetaDataUtil;
import java.io.File;
import java.io.IOException;
import plugins.adufour.blocks.lang.Batch;
import plugins.adufour.vars.gui.FileMode;
import plugins.adufour.vars.gui.model.FileTypeModel;
import plugins.adufour.vars.lang.VarFile;
import plugins.adufour.vars.lang.VarSequence;
import plugins.adufour.vars.util.VarException;
import plugins.kernel.importer.LociImporterPlugin;

public class SequenceSeriesBatch
extends Batch {
    private VarFile multiSeriesFile;
    private int nbSeries;
    private VarSequence element;

    public VarFile getBatchSource() {
        if (this.multiSeriesFile == null) {
            this.multiSeriesFile = new VarFile("Series file", null);
            this.multiSeriesFile.setDefaultEditorModel(new FileTypeModel(null, FileMode.FILES, null, false));
        }
        return this.multiSeriesFile;
    }

    public VarSequence getBatchElement() {
        if (this.element == null) {
            this.element = new VarSequence("Sequence", null);
        }
        return this.element;
    }

    @Override
    public void initializeLoop() {
        if (this.multiSeriesFile.getValue() == null) {
            throw new VarException(this.multiSeriesFile, "No file indicated");
        }
        File f = (File)this.multiSeriesFile.getValue();
        if (f.isDirectory()) {
            throw new VarException(this.multiSeriesFile, f.getAbsolutePath() + " is not a file");
        }
        String path = f.getPath();
        try {
            SequenceFileImporter importer = Loader.getSequenceFileImporter(path, true);
            if (importer instanceof LociImporterPlugin) {
                ((LociImporterPlugin)importer).setGroupFiles(false);
            }
            this.nbSeries = MetaDataUtil.getNumSeries(Loader.getOMEXMLMetaData(importer, path));
        }
        catch (UnsupportedFormatException e) {
            throw new VarException(this.multiSeriesFile, path + " is not an imaging file");
        }
        catch (IOException e) {
            throw new VarException(this.multiSeriesFile, "Unable to read " + path);
        }
    }

    @Override
    public void beforeIteration() {
        String path = ((File)this.multiSeriesFile.getValue()).getPath();
        SequenceFileImporter importer = Loader.getSequenceFileImporter(path, true);
        if (importer instanceof LociImporterPlugin) {
            ((LociImporterPlugin)importer).setGroupFiles(false);
        }
        this.element.setValue(Loader.loadSequence(importer, path, this.getIterationCounter().getValue(), true));
    }

    @Override
    public boolean isStopConditionReached() {
        return this.getIterationCounter().getValue() == this.nbSeries;
    }
}

