/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.blocks.tools.io;

import icy.file.FileUtil;
import icy.plugin.abstract_.Plugin;
import java.io.File;
import plugins.adufour.blocks.tools.io.IOBlock;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.gui.FileMode;
import plugins.adufour.vars.gui.model.FileTypeModel;
import plugins.adufour.vars.lang.VarBoolean;
import plugins.adufour.vars.lang.VarFile;
import plugins.adufour.vars.lang.VarString;
import plugins.adufour.vars.util.VarException;

public class CreateFile
extends Plugin
implements IOBlock {
    VarFile parentFolder = new VarFile("Base folder", new File(System.getProperty("user.home")));
    VarString fileName = new VarString("File name", "newFile");
    VarFile file = new VarFile("New file", null);
    VarBoolean overwrite = new VarBoolean("Overwrite", false);

    @Override
    public void declareInput(VarList inputMap) {
        this.parentFolder.setDefaultEditorModel(new FileTypeModel(((File)this.parentFolder.getValue()).getPath(), FileMode.FOLDERS, null, true));
        inputMap.add("parent folder", this.parentFolder);
        inputMap.add("file name", this.fileName);
        inputMap.add("overwrite", this.overwrite);
    }

    @Override
    public void declareOutput(VarList outputMap) {
        outputMap.add("new file", this.file);
    }

    @Override
    public void run() {
        File parent = (File)this.parentFolder.getValue();
        if (parent == null || !parent.exists() || !parent.isDirectory()) {
            throw new VarException(this.parentFolder, "The parent folder does not exist or is not a folder");
        }
        if (((String)this.fileName.getValue()).isEmpty()) {
            throw new VarException(this.fileName, "The name of the file cannot be empty");
        }
        File newFile = new File(this.parentFolder + File.separator + (String)this.fileName.getValue());
        if (!newFile.exists()) {
            FileUtil.createFile(newFile);
        } else if (!newFile.isDirectory() && !((Boolean)this.overwrite.getValue()).booleanValue()) {
            throw new VarException(this.fileName, "Cannot create file " + newFile.getPath() + "\n=> A file with this name already exists");
        }
        this.file.setValue(newFile);
    }
}

