/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.ezplug;

import icy.gui.frame.IcyExternalFrame;
import icy.gui.frame.IcyFrame;
import icy.gui.frame.IcyInternalFrame;
import icy.main.Icy;
import icy.system.IcyHandledException;
import icy.system.thread.ThreadUtil;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import plugins.adufour.ezplug.EzComponent;
import plugins.adufour.ezplug.EzExternalFrame;
import plugins.adufour.ezplug.EzGroup;
import plugins.adufour.ezplug.EzInternalFrame;
import plugins.adufour.ezplug.EzPanel;
import plugins.adufour.ezplug.EzVar;

public class EzDialog
extends IcyFrame
implements EzGroup.FoldListener {
    public static final int FONT_SIZE = 16;
    private static final boolean USE_SKIN_COLOR_SCHEME = true;
    protected static File currentParametersPath = null;
    protected Color logoTitleColor;
    private JPanel jPanelParameters;
    private final List<Object> components = new ArrayList<Object>();
    private JDialog dialog;
    private boolean isDialog = false;
    public final Runnable fullPackingTask = new Runnable(){

        @Override
        public void run() {
            EzDialog.this.repack(true);
        }
    };

    public EzDialog(String title) {
        this(title, true);
    }

    protected EzDialog(String title, final boolean isDialog) {
        super(title, true, true, false, true);
        this.isDialog = isDialog;
        ThreadUtil.invokeNow(new Runnable(){

            @Override
            public void run() {
                EzDialog.this.jPanelParameters = new JPanel();
                EzDialog.this.jPanelParameters.setLayout(new BoxLayout(EzDialog.this.jPanelParameters, 0));
                EzDialog.this.jPanelParameters.setBorder(BorderFactory.createEmptyBorder(3, 0, 3, 0));
                if (isDialog) {
                    EzDialog.this.dialog = new JDialog();
                    EzDialog.this.dialog.setTitle(EzDialog.this.getTitle());
                    EzDialog.this.dialog.setLayout(new BorderLayout());
                    EzDialog.this.dialog.add((Component)EzDialog.this.jPanelParameters, "Center");
                    EzDialog.this.dialog.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
                    EzDialog.this.dialog.setLocationRelativeTo(Icy.getMainInterface().getMainFrame().getDesktopPane());
                    EzDialog.this.dialog.pack();
                } else {
                    EzDialog.this.getContentPane().add((Component)EzDialog.this.jPanelParameters, "Center");
                    EzDialog.this.pack();
                    EzDialog.this.setOptimalLocation();
                }
            }
        });
    }

    protected void setOptimalLocation() {
        Point location = new Point();
        if (this.isExternalized()) {
            location = Icy.getMainInterface().getMainFrame().getLocationOnScreen();
            location.y += Icy.getMainInterface().getMainFrame().getHeight();
        }
        boolean validLocation = false;
        Dimension screenDim = this.getToolkit().getScreenSize();
        block0: while (!validLocation) {
            ArrayList<Container> comps = this.isInternalized() ? new ArrayList<JInternalFrame>(Arrays.asList(Icy.getMainInterface().getDesktopPane().getAllFrames())) : Icy.getMainInterface().getExternalFrames();
            for (Component component : comps) {
                if (this.getFrame() == component || !component.isShowing()) continue;
                Point point = this.isInternalized() ? component.getLocation() : component.getLocationOnScreen();
                Point wLoc = point;
                if (!(wLoc.distanceSq(location) < 400.0)) continue;
                Dimension dim = component.getPreferredSize();
                location.x += dim.width;
                if (location.x > screenDim.width - dim.width) {
                    location.x = 0;
                    location.y += dim.height;
                    if (location.y > screenDim.height - dim.height) {
                        location.x = 0;
                        location.y = 0;
                        break;
                    }
                }
                validLocation = false;
                continue block0;
            }
            validLocation = true;
        }
        this.setLocation(location);
    }

    @Override
    protected IcyInternalFrame createInternalFrame(String title, boolean resizable, boolean closable, boolean maximizable, boolean iconifiable) {
        return new EzInternalFrame(title, resizable, closable, maximizable, iconifiable);
    }

    @Override
    protected IcyExternalFrame createExternalFrame(String title) {
        return new EzExternalFrame(title);
    }

    public void addComponent(Component component) {
        this.components.add(component);
    }

    public void addEzComponent(EzComponent component) {
        this.addEzComponent(component, true);
    }

    protected void addEzComponent(EzComponent component, boolean isSingle) {
        if (component instanceof EzPanel) {
            EzPanel panel = (EzPanel)component;
            if (panel instanceof EzGroup) {
                ((EzGroup)panel).addFoldListener(this);
            }
            for (EzComponent groupComponent : panel) {
                this.addEzComponent(groupComponent, false);
            }
        }
        component.setUI(this);
        if (component instanceof EzVar) {
            EzVar var = (EzVar)component;
            var.variable.addListener(var);
        }
        if (isSingle) {
            this.components.add(component);
        }
    }

    @Override
    public void foldStateChanged(boolean newState) {
        this.repack(true);
    }

    public void repack(boolean updateParametersPanel) {
        if (updateParametersPanel) {
            this.jPanelParameters.removeAll();
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.insets = new Insets(2, 5, 2, 5);
            gbc.fill = 1;
            gbc.gridwidth = 0;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            ArrayList columns = new ArrayList();
            ArrayList<Object> currentColumn = new ArrayList<Object>();
            columns.add(currentColumn);
            for (Object component : this.components) {
                if (component instanceof JSeparator && ((JSeparator)component).getOrientation() == 1) {
                    currentColumn = new ArrayList();
                    columns.add(currentColumn);
                    continue;
                }
                currentColumn.add(component);
            }
            for (int i = 0; i < columns.size(); ++i) {
                List column = (List)columns.get(i);
                if (i > 0 && column.size() > 0) {
                    this.jPanelParameters.add(new JSeparator(1));
                }
                JPanel columnContainer = new JPanel(new GridBagLayout());
                for (Object object : column) {
                    if (object instanceof EzComponent) {
                        ((EzComponent)object).addToContainer(columnContainer);
                        continue;
                    }
                    if (object instanceof Component) {
                        Component component = (Component)object;
                        GridBagLayout gridbag = (GridBagLayout)columnContainer.getLayout();
                        component.setFocusable(false);
                        gbc.weighty = 1.0;
                        if (component instanceof JButton) {
                            gbc.weighty = 0.0;
                        }
                        gridbag.setConstraints(component, gbc);
                        columnContainer.add(component);
                        continue;
                    }
                    throw new UnsupportedOperationException("Cannot add a " + object.getClass().getSimpleName() + " to the graphical interface");
                }
                this.jPanelParameters.add(columnContainer);
            }
            this.jPanelParameters.validate();
            this.jPanelParameters.repaint();
        }
        if (this.isDialog) {
            this.dialog.getContentPane().validate();
            this.dialog.getContentPane().repaint();
            this.dialog.pack();
        } else {
            this.pack();
        }
    }

    public void showDialog() {
        this.showDialog(true);
    }

    public void showDialog(final boolean modal) {
        if (!this.isDialog) {
            throw new IcyHandledException("Cannot show an IcyFrame as a Dialog. Use setVisible(true) instead.");
        }
        ThreadUtil.invokeNow(new Runnable(){

            @Override
            public void run() {
                EzDialog.this.repack(true);
                EzDialog.this.dialog.setLocationRelativeTo(null);
                EzDialog.this.dialog.setModal(modal);
                EzDialog.this.dialog.setVisible(true);
                if (modal) {
                    EzDialog.this.hideDialog();
                }
            }
        });
    }

    @Override
    public void close() {
        if (this.isDialog) {
            this.hideDialog();
        }
        super.close();
    }

    public void hideDialog() {
        if (!this.isDialog) {
            return;
        }
        ThreadUtil.invokeNow(new Runnable(){

            @Override
            public void run() {
                EzDialog.this.dialog.setVisible(false);
            }
        });
    }

    @Override
    public void onClosed() {
        for (Object object : this.components) {
            if (!(object instanceof EzComponent)) continue;
            ((EzComponent)object).dispose();
        }
        this.components.clear();
        this.jPanelParameters.removeAll();
        super.onClosed();
    }

    public static void paintTitlePane(Graphics2D graphics, int width, int height, String title, boolean internal) {
        EzDialog.paintBackground(width, height, internal, graphics);
        SubstanceColorScheme colors = SubstanceLookAndFeel.getCurrentSkin().getColorScheme((Component)new JButton(), ComponentState.PRESSED_SELECTED);
        graphics.setColor(colors.isDark() ? Color.white : colors.getUltraDarkColor().darker().darker());
        graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        FontMetrics m = graphics.getFontMetrics();
        int titleWidth = m.stringWidth(title);
        int titleHeight = m.getHeight() - 6;
        graphics.drawString(title, (width - titleWidth) / 2, (height + titleHeight) / 2);
    }

    private static void paintBackground(int width, int height, boolean internal, Graphics2D graphics) {
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        SubstanceColorScheme colors = SubstanceLookAndFeel.getCurrentSkin().getColorScheme((Component)new JButton(), ComponentState.PRESSED_SELECTED);
        Color brightColor = colors.getUltraLightColor().brighter();
        Color darkColor = colors.getDarkColor();
        graphics.setPaint(new GradientPaint(0.0f, 0.0f, brightColor, 0.0f, height, darkColor));
        if (internal) {
            float ray = (float)Math.max(width, height) * 0.05f;
            float finalRay = Math.min(ray * 2.0f, 20.0f);
            graphics.fill(new RoundRectangle2D.Double(0.0, 0.0, width, height, finalRay, finalRay));
            graphics.fillRect(0, height / 2, width, height / 2);
        } else {
            graphics.fill(new Rectangle2D.Double(0.0, 0.0, width, height));
        }
        graphics.setPaint(new GradientPaint(0.0f, 0.0f, brightColor, 0.0f, height * 2, darkColor));
        graphics.setComposite(AlphaComposite.getInstance(3, 0.7f));
        graphics.fillOval(-width + width / 2, height / 3, width * 2, height * 3);
    }
}

