/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.vars.gui.swing;

import icy.system.thread.ThreadUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Array;
import java.util.List;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import plugins.adufour.vars.gui.model.ValueSelectionModel;
import plugins.adufour.vars.gui.model.VarEditorModel;
import plugins.adufour.vars.gui.swing.SwingVarEditor;
import plugins.adufour.vars.lang.Var;

public class ComboBox<T>
extends SwingVarEditor<T> {
    private ActionListener actionListener;

    public ComboBox(Var<T> variable) throws IllegalArgumentException {
        super(variable);
    }

    private static String arrayToString(Object array) {
        int length = Array.getLength(array);
        String s = length == 0 ? "" : Array.get(array, 0).toString();
        for (int i = 1; i < length; ++i) {
            s = s + " " + Array.get(array, i).toString();
        }
        return s;
    }

    @Override
    public JComponent createEditorComponent() throws IllegalArgumentException {
        VarEditorModel cons = this.variable.getDefaultEditorModel();
        List defaultValues = null;
        boolean freeInput = true;
        Object defaultValue = this.variable.getDefaultValue();
        if (cons != null) {
            if (cons instanceof ValueSelectionModel) {
                ValueSelectionModel constraint = (ValueSelectionModel)cons;
                defaultValues = constraint.getValidValues();
                freeInput = constraint.isFreeInput();
                defaultValue = constraint.getDefaultValue();
            } else {
                throw new IllegalArgumentException("Variable " + this.variable.getName() + " must have a value-type constraint");
            }
        }
        JComboBox<Object> jComboBox = defaultValues == null ? new JComboBox() : new JComboBox<Object>(defaultValues.toArray());
        jComboBox.setEditable(freeInput);
        jComboBox.setSelectedItem(defaultValue);
        this.actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ComboBox.this.variable.getReference() == null) {
                    ComboBox.this.updateVariableValue();
                }
            }
        };
        jComboBox.setRenderer(this.createRenderer());
        if (jComboBox.isEditable()) {
            jComboBox.setEditor(this.createEditor());
        }
        return jComboBox;
    }

    protected ListCellRenderer<T> createRenderer() {
        return new ListCellRenderer<T>(){

            @Override
            public Component getListCellRendererComponent(JList<? extends T> list, T value, int index, boolean isSelected, boolean cellHasFocus) {
                String s = "";
                if (value != null) {
                    s = value.getClass().isArray() ? ComboBox.arrayToString(value) : value.toString();
                }
                return new JLabel(s);
            }
        };
    }

    protected ComboBoxEditor createEditor() {
        return new ComboBoxEditor(){
            final JTextField jTextField = new JTextField();
            final Color defaultColor = this.jTextField.getForeground();
            final Color errorColor = Color.red;

            @Override
            public void addActionListener(ActionListener l) {
            }

            @Override
            public Component getEditorComponent() {
                this.jTextField.setFocusable(true);
                Dimension dim = this.jTextField.getPreferredSize();
                dim.height = 20;
                this.jTextField.setPreferredSize(dim);
                return this.jTextField;
            }

            public T getItem() {
                Object item = null;
                try {
                    item = ComboBox.this.variable.parse(this.jTextField.getText());
                    this.jTextField.setForeground(this.defaultColor);
                    this.jTextField.setToolTipText(null);
                }
                catch (NumberFormatException nfE) {
                    item = null;
                    this.jTextField.setForeground(this.errorColor);
                    this.jTextField.setToolTipText("Cannot parse input into a " + ComboBox.this.getVariable().getClass().getSimpleName());
                }
                return item;
            }

            @Override
            public void removeActionListener(ActionListener l) {
            }

            @Override
            public void selectAll() {
                this.jTextField.selectAll();
            }

            @Override
            public void setItem(Object item) {
                if (item == null) {
                    this.jTextField.setText("");
                } else {
                    this.jTextField.setText(item.getClass().isArray() ? ComboBox.arrayToString(item) : item.toString());
                }
            }
        };
    }

    public void setDefaultValues(final T[] values, final int defaultValueIndex, final boolean allowUserInput) {
        ThreadUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                JComponent jComboBox = ComboBox.this.getEditorComponent();
                ((JComboBox)jComboBox).removeAllItems();
                for (Object value : values) {
                    ((JComboBox)jComboBox).addItem(value);
                }
                ComboBox.this.variable.setDefaultEditorModel(new ValueSelectionModel<int>((T[])values, defaultValueIndex, allowUserInput));
                ((JComboBox)jComboBox).setEditable(allowUserInput);
            }
        });
    }

    protected void updateVariableValue() {
        this.variable.setValue(((JComboBox)this.getEditorComponent()).getSelectedItem());
    }

    @Override
    protected void updateInterfaceValue() {
        ((JComboBox)this.getEditorComponent()).getModel().setSelectedItem(this.variable.getValue());
    }

    @Override
    public void dispose() {
        super.dispose();
        JComponent jComboBox = this.getEditorComponent();
        ((JComboBox)jComboBox).setRenderer(new DefaultListCellRenderer());
        ((JComboBox)jComboBox).setModel(new DefaultComboBoxModel());
    }

    @Override
    public JComboBox<T> getEditorComponent() {
        return (JComboBox)super.getEditorComponent();
    }

    @Override
    protected void activateListeners() {
        ((JComboBox)this.getEditorComponent()).addActionListener(this.actionListener);
    }

    @Override
    protected void deactivateListeners() {
        ((JComboBox)this.getEditorComponent()).removeActionListener(this.actionListener);
    }
}

