/*
 * Decompiled with CFR 0.152.
 */
package icy.action;

import icy.action.CanvasActions;
import icy.action.FileActions;
import icy.action.GeneralActions;
import icy.action.IcyAbstractAction;
import icy.action.PreferencesActions;
import icy.action.RoiActions;
import icy.action.SequenceOperationActions;
import icy.action.ViewerActions;
import icy.action.WindowActions;
import icy.gui.main.ActiveSequenceListener;
import icy.main.Icy;
import icy.sequence.Sequence;
import icy.sequence.SequenceEvent;
import java.util.ArrayList;
import java.util.List;

public class ActionManager {
    public static List<IcyAbstractAction> actions = null;
    private static ActiveSequenceListener activeSequenceListener;

    public static synchronized void init() {
        if (actions == null) {
            actions = new ArrayList<IcyAbstractAction>();
            actions.addAll(FileActions.getAllActions());
            actions.addAll(GeneralActions.getAllActions());
            actions.addAll(PreferencesActions.getAllActions());
            actions.addAll(SequenceOperationActions.getAllActions());
            actions.addAll(RoiActions.getAllActions());
            actions.addAll(CanvasActions.getAllActions());
            actions.addAll(ViewerActions.getAllActions());
            actions.addAll(WindowActions.getAllActions());
            activeSequenceListener = new ActiveSequenceListener(){

                @Override
                public void sequenceDeactivated(Sequence sequence) {
                }

                @Override
                public void sequenceActivated(Sequence sequence) {
                    for (IcyAbstractAction action : actions) {
                        action.enabledChanged();
                    }
                }

                @Override
                public void activeSequenceChanged(SequenceEvent event) {
                }
            };
            Icy.getMainInterface().addActiveSequenceListener(activeSequenceListener);
        }
    }
}

