/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.component;

import icy.common.listener.weak.WeakListener;
import icy.gui.frame.IcyFrame;
import icy.gui.frame.IcyFrameAdapter;
import icy.gui.frame.IcyFrameEvent;
import icy.gui.util.WindowPositionSaver;
import icy.main.Icy;
import icy.util.StringUtil;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.Point;
import java.util.EventListener;
import javax.swing.JPanel;

public class ExternalizablePanel
extends JPanel {
    private static final long serialVersionUID = -7690543443681714719L;
    protected final Frame frame;
    private Container parent;
    private boolean internalizationAutorized;
    private boolean externalizationAutorized;
    boolean closed;
    final WindowPositionSaver positionSaver;

    public ExternalizablePanel(String title, String key, Point defLoc, Dimension defDim) {
        this.frame = new Frame(title);
        this.parent = null;
        this.internalizationAutorized = true;
        this.externalizationAutorized = true;
        this.closed = false;
        this.positionSaver = !StringUtil.isEmpty(key) ? new WindowPositionSaver(this, "frame/" + key, defLoc, defDim) : null;
    }

    public ExternalizablePanel(String title, String key) {
        this(title, key, new Point(200, 200), new Dimension(400, 300));
    }

    public ExternalizablePanel(String title) {
        this(title, null);
    }

    public ExternalizablePanel() {
        this("", null);
    }

    @Override
    public void addNotify() {
        Container p;
        super.addNotify();
        if (this.parent == null && (p = this.getParent()) != this.frame.getInternalFrame().getContentPane() && p != this.frame.getExternalFrame().getContentPane()) {
            this.parent = p;
        }
    }

    public void close() {
        this.closed = true;
        this.frame.setDefaultCloseOperation(2);
        this.frame.close();
    }

    public void setParent(Container value) {
        this.parent = value;
    }

    public boolean isInternalizationAutorized() {
        return this.internalizationAutorized;
    }

    public void setInternalizationAutorized(boolean internalizationAutorized) {
        this.internalizationAutorized = internalizationAutorized;
    }

    public boolean isExternalizationAutorized() {
        return this.externalizationAutorized;
    }

    public void setExternalizationAutorized(boolean externalizationAutorized) {
        this.externalizationAutorized = externalizationAutorized;
    }

    public void externalize() {
        if (this.isInternalized()) {
            this.externalizeInternal();
        }
    }

    public void internalize() {
        if (this.isExternalized()) {
            this.internalizeInternal();
        }
    }

    void externalizeInternal() {
        if (!this.externalizationAutorized) {
            return;
        }
        if (this.parent != null) {
            this.parent.remove(this);
            this.parent.validate();
        }
        this.frame.add(this, "Center");
        this.frame.validate();
        this.frame.addToDesktopPane();
        this.frame.setVisible(true);
        this.fireStateChange(true);
    }

    void internalizeInternal() {
        if (!this.internalizationAutorized) {
            return;
        }
        this.frame.setVisible(false);
        this.frame.remove(this);
        this.frame.validate();
        this.frame.removeFromMainDesktopPane();
        if (this.parent != null) {
            this.parent.add(this);
            this.parent.validate();
        }
        this.fireStateChange(false);
    }

    public void switchState() {
        if (this.isExternalized()) {
            this.internalizeInternal();
        } else {
            this.externalizeInternal();
        }
    }

    public boolean isInternalized() {
        return !this.frame.isVisible();
    }

    public boolean isExternalized() {
        return this.frame.isVisible();
    }

    public IcyFrame getFrame() {
        return this.frame;
    }

    private void fireStateChange(boolean externalized) {
        for (StateListener l : (StateListener[])this.listenerList.getListeners(StateListener.class)) {
            l.stateChanged(this, externalized);
        }
    }

    public void addStateListener(StateListener l) {
        this.listenerList.add(StateListener.class, l);
    }

    public void removeStateListener(StateListener l) {
        this.listenerList.remove(StateListener.class, l);
    }

    public class Frame
    extends IcyFrame {
        public Frame(String title) throws HeadlessException {
            super(title, true, true, true, true);
            this.setDefaultCloseOperation(0);
            this.addFrameListener(new IcyFrameAdapter(this){
                final /* synthetic */ Frame this$1;
                {
                    this.this$1 = this$1;
                }

                @Override
                public void icyFrameClosing(IcyFrameEvent e) {
                    super.icyFrameClosing(e);
                    if (!this.this$1.ExternalizablePanel.this.closed && !Icy.isExiting() && this.this$1.ExternalizablePanel.this.isExternalized()) {
                        this.this$1.ExternalizablePanel.this.internalizeInternal();
                    }
                }
            });
            this.setLayout(new BorderLayout());
            this.setSize(400, 400);
        }
    }

    public static interface StateListener
    extends EventListener {
        public void stateChanged(ExternalizablePanel var1, boolean var2);
    }

    public static class WeakStateListener
    extends WeakListener<StateListener>
    implements StateListener {
        public WeakStateListener(StateListener listener) {
            super(listener);
        }

        @Override
        public void removeListener(Object source) {
            if (source != null) {
                ((ExternalizablePanel)source).removeStateListener(this);
            }
        }

        @Override
        public void stateChanged(ExternalizablePanel source, boolean externalized) {
            StateListener listener = (StateListener)this.getListener(source);
            if (listener != null) {
                listener.stateChanged(source, externalized);
            }
        }
    }
}

