/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.component.editor;

import java.awt.Component;
import javax.swing.AbstractCellEditor;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableCellEditor;
import javax.swing.tree.TreeCellEditor;

public class SliderCellEditor
extends AbstractCellEditor
implements TableCellEditor,
TreeCellEditor,
ChangeListener {
    private static final long serialVersionUID = -4946926120641246542L;
    private JSlider slider = new JSlider(0, 1000);
    private JTable table;
    private int row;
    private int column;
    boolean liveUpdate;

    public SliderCellEditor(boolean liveUpdate) {
        this.slider.addChangeListener(this);
        this.slider.setRequestFocusEnabled(false);
        this.table = null;
        this.liveUpdate = liveUpdate;
    }

    @Override
    public Object getCellEditorValue() {
        return this.slider.getValue();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.slider.getValueIsAdjusting()) {
            if (this.liveUpdate && this.table != null) {
                int value = this.slider.getValue();
                if ((Integer)this.table.getValueAt(this.row, this.column) != value) {
                    this.table.setValueAt(value, this.row, this.column);
                }
            }
        } else {
            this.stopCellEditing();
        }
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.table = table;
        this.row = row;
        this.column = column;
        int intValue = (Integer)value;
        if (this.slider.getValue() != intValue) {
            this.slider.setValue(intValue);
        }
        this.slider.invalidate();
        return this.slider;
    }

    @Override
    public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
        int intValue = (Integer)value;
        if (this.slider.getValue() != intValue) {
            this.slider.setValue(intValue);
        }
        return this.slider;
    }
}

