/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.component.editor;

import icy.gui.component.SpecialValueSpinner;
import icy.gui.component.model.SpecialValueSpinnerModel;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.InternationalFormatter;
import javax.swing.text.NumberFormatter;

public class SpecialValueSpinnerEditor
extends JSpinner.DefaultEditor {
    private static final long serialVersionUID = -2378027484728815432L;

    public SpecialValueSpinnerEditor(SpecialValueSpinner spinner) {
        this(spinner, (DecimalFormat)NumberFormat.getInstance(spinner.getLocale()));
    }

    public SpecialValueSpinnerEditor(SpecialValueSpinner spinner, String decimalFormatPattern) {
        this(spinner, new DecimalFormat(decimalFormatPattern));
    }

    private SpecialValueSpinnerEditor(SpecialValueSpinner spinner, DecimalFormat format) {
        super(spinner);
        if (!(spinner.getModel() instanceof SpecialValueSpinnerModel)) {
            throw new IllegalArgumentException("model not a SpecialValueSpinnerModel");
        }
        SpecialValueSpinnerModel model = (SpecialValueSpinnerModel)spinner.getModel();
        NumberEditorFormatter formatter = new NumberEditorFormatter(model, format);
        DefaultFormatterFactory factory = new DefaultFormatterFactory(formatter);
        JFormattedTextField ftf = this.getTextField();
        ftf.setEditable(true);
        ftf.setFormatterFactory(factory);
        ftf.setHorizontalAlignment(4);
        try {
            String maxString = ((InternationalFormatter)formatter).valueToString(model.getMinimum());
            String minString = ((InternationalFormatter)formatter).valueToString(model.getMaximum());
            ftf.setColumns(Math.max(maxString.length(), minString.length()));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public DecimalFormat getFormat() {
        return (DecimalFormat)((NumberFormatter)this.getTextField().getFormatter()).getFormat();
    }

    public SpecialValueSpinnerModel getModel() {
        return (SpecialValueSpinnerModel)this.getSpinner().getModel();
    }

    private static class NumberEditorFormatter
    extends NumberFormatter {
        private static final long serialVersionUID = 723313251195326099L;
        private final SpecialValueSpinnerModel model;

        NumberEditorFormatter(SpecialValueSpinnerModel model, NumberFormat format) {
            super(format);
            this.model = model;
            this.setValueClass(model.getValue().getClass());
        }

        public void setMinimum(Comparable min) {
            this.model.setMinimum(min);
        }

        public Comparable getMinimum() {
            return this.model.getMinimum();
        }

        public void setMaximum(Comparable max) {
            this.model.setMaximum(max);
        }

        public Comparable getMaximum() {
            return this.model.getMaximum();
        }

        @Override
        public Object stringToValue(String text) throws ParseException {
            if (text != null && text.equalsIgnoreCase(this.model.getSpecialText())) {
                return this.model.getSpecialValue();
            }
            return super.stringToValue(text);
        }

        @Override
        public String valueToString(Object value) throws ParseException {
            if (value != null && value.equals(this.model.getSpecialValue())) {
                return this.model.getSpecialText();
            }
            return super.valueToString(value);
        }
    }
}

