/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.component.renderer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.plaf.ListUI;
import org.pushingpixels.substance.api.ColorSchemeAssociationKind;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.ComponentStateFacet;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.renderers.SubstanceDefaultComboBoxRenderer;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.ui.SubstanceComboBoxUI;
import org.pushingpixels.substance.internal.ui.SubstanceListUI;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;
import org.pushingpixels.substance.internal.utils.SubstanceStripingUtils;
import org.pushingpixels.substance.internal.utils.SubstanceTextUtilities;
import org.pushingpixels.substance.internal.utils.UpdateOptimizationInfo;

public class CustomComboBoxRenderer
extends SubstanceDefaultComboBoxRenderer {
    private static final long serialVersionUID = -3392789033779535472L;
    private final JComboBox combo;

    public CustomComboBoxRenderer(JComboBox combo) {
        super(combo);
        this.combo = combo;
    }

    public JComboBox getComboBox() {
        return this.combo;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JComponent result = (JComponent)this.getRendererComponent(list, value, index, isSelected);
        ListUI baseListUI = list.getUI();
        ComboBoxUI baseComboUI = this.combo.getUI();
        if (baseListUI instanceof SubstanceListUI && baseComboUI instanceof SubstanceComboBoxUI) {
            SubstanceListUI listUI = (SubstanceListUI)baseListUI;
            SubstanceComboBoxUI comboUI = (SubstanceComboBoxUI)baseComboUI;
            if (index == -1) {
                StateTransitionTracker stateTransitionTracker = comboUI.getTransitionTracker();
                StateTransitionTracker.ModelStateInfo modelStateInfo = stateTransitionTracker.getModelStateInfo();
                ComponentState currState = modelStateInfo.getCurrModelState();
                float comboAlpha = SubstanceColorSchemeUtilities.getAlpha((Component)this.combo, (ComponentState)currState);
                Color fg = SubstanceTextUtilities.getForegroundColor((JComponent)this.combo, (String)((JLabel)result).getText(), (StateTransitionTracker.ModelStateInfo)modelStateInfo, (float)comboAlpha);
                result.setForeground(fg);
            } else {
                StateTransitionTracker.ModelStateInfo modelStateInfo = listUI.getModelStateInfo(index, (Component)result);
                ComponentState currState = listUI.getCellState(index, (Component)result);
                if (modelStateInfo == null) {
                    SubstanceColorScheme scheme = this.getColorSchemeForState(list, index, listUI, currState);
                    result.setForeground(new ColorUIResource(scheme.getForegroundColor()));
                } else {
                    Map activeStates = modelStateInfo.getStateContributionMap();
                    SubstanceColorScheme colorScheme = this.getColorSchemeForState(list, index, listUI, currState);
                    if (currState.isDisabled() || activeStates == null || activeStates.size() == 1) {
                        super.setForeground((Color)new ColorUIResource(colorScheme.getForegroundColor()));
                    } else {
                        float aggrRed = 0.0f;
                        float aggrGreen = 0.0f;
                        float aggrBlue = 0.0f;
                        for (Map.Entry activeEntry : modelStateInfo.getStateContributionMap().entrySet()) {
                            ComponentState activeState = (ComponentState)activeEntry.getKey();
                            float activeContribution = ((StateTransitionTracker.StateContributionInfo)activeEntry.getValue()).getContribution();
                            if (activeContribution == 0.0f) continue;
                            SubstanceColorScheme scheme = this.getColorSchemeForState(list, index, listUI, activeState);
                            Color schemeFg = scheme.getForegroundColor();
                            aggrRed += (float)schemeFg.getRed() * activeContribution;
                            aggrGreen += (float)schemeFg.getGreen() * activeContribution;
                            aggrBlue += (float)schemeFg.getBlue() * activeContribution;
                        }
                        result.setForeground(new ColorUIResource(new Color((int)aggrRed, (int)aggrGreen, (int)aggrBlue)));
                    }
                }
            }
            SubstanceStripingUtils.applyStripedBackground((JComponent)list, (int)index, (JComponent)((Object)this));
        }
        result.setEnabled(this.combo.isEnabled() & this.isEnabled());
        return result;
    }

    protected Component getRendererComponent(JList list, Object value, int index, boolean isSelected) {
        this.setComponentOrientation(list.getComponentOrientation());
        ListUI listUI = list.getUI();
        if (listUI instanceof SubstanceListUI) {
            boolean isDropLocation;
            SubstanceListUI ui = (SubstanceListUI)listUI;
            StateTransitionTracker.ModelStateInfo modelStateInfo = ui.getModelStateInfo(index, (Component)((Object)this));
            ComponentState currState = ui.getCellState(index, (Component)((Object)this));
            JList.DropLocation dropLocation = list.getDropLocation();
            boolean bl = isDropLocation = dropLocation != null && !dropLocation.isInsert() && dropLocation.getIndex() == index;
            if (!isDropLocation && modelStateInfo != null) {
                Map activeStates = modelStateInfo.getStateContributionMap();
                SubstanceColorScheme colorScheme = this.getColorSchemeForState(list, ui, currState);
                if (currState.isDisabled() || activeStates == null || activeStates.size() == 1) {
                    super.setForeground((Color)new ColorUIResource(colorScheme.getForegroundColor()));
                } else {
                    float aggrRed = 0.0f;
                    float aggrGreen = 0.0f;
                    float aggrBlue = 0.0f;
                    for (Map.Entry activeEntry : modelStateInfo.getStateContributionMap().entrySet()) {
                        ComponentState activeState = (ComponentState)activeEntry.getKey();
                        SubstanceColorScheme scheme = this.getColorSchemeForState(list, ui, activeState);
                        Color schemeFg = scheme.getForegroundColor();
                        float contribution = ((StateTransitionTracker.StateContributionInfo)activeEntry.getValue()).getContribution();
                        aggrRed += (float)schemeFg.getRed() * contribution;
                        aggrGreen += (float)schemeFg.getGreen() * contribution;
                        aggrBlue += (float)schemeFg.getBlue() * contribution;
                    }
                    super.setForeground((Color)new ColorUIResource(new Color((int)aggrRed, (int)aggrGreen, (int)aggrBlue)));
                }
            } else {
                SubstanceColorScheme scheme = this.getColorSchemeForState(list, ui, currState);
                if (isDropLocation) {
                    scheme = SubstanceColorSchemeUtilities.getColorScheme((Component)list, (ColorSchemeAssociationKind)ColorSchemeAssociationKind.TEXT_HIGHLIGHT, (ComponentState)currState);
                }
                super.setForeground((Color)new ColorUIResource(scheme.getForegroundColor()));
            }
        } else if (isSelected) {
            this.setForeground(list.getSelectionForeground());
        } else {
            this.setForeground(list.getForeground());
        }
        if (SubstanceLookAndFeel.isCurrentLookAndFeel() && list.getLayoutOrientation() == 0) {
            SubstanceStripingUtils.applyStripedBackground((JComponent)list, (int)index, (JComponent)((Object)this));
        }
        this.updateItem(list, value);
        Insets ins = SubstanceSizeUtils.getListCellRendererInsets((int)SubstanceSizeUtils.getComponentFontSize((Component)list));
        this.setBorder(new EmptyBorder(ins.top, ins.left, ins.bottom, ins.right));
        this.setOpaque(false);
        return this;
    }

    protected void updateItem(JList list, Object value) {
        if (value instanceof Icon) {
            this.setIcon((Icon)value);
            this.setText("");
        } else {
            this.setIcon(null);
            this.setText(value == null ? "" : value.toString());
            this.setToolTipText(value == null ? "" : value.toString());
        }
        this.setEnabled(list.isEnabled());
        this.setFont(list.getFont());
    }

    private SubstanceColorScheme getColorSchemeForState(JList list, SubstanceListUI ui, ComponentState state) {
        UpdateOptimizationInfo updateOptimizationInfo = ui.getUpdateOptimizationInfo();
        if (state == ComponentState.ENABLED) {
            if (updateOptimizationInfo == null) {
                return SubstanceColorSchemeUtilities.getColorScheme((Component)list, (ComponentState)state);
            }
            return updateOptimizationInfo.getDefaultScheme();
        }
        if (updateOptimizationInfo == null) {
            return SubstanceColorSchemeUtilities.getColorScheme((Component)list, (ColorSchemeAssociationKind)ColorSchemeAssociationKind.HIGHLIGHT, (ComponentState)state);
        }
        return updateOptimizationInfo.getHighlightColorScheme(state);
    }

    private SubstanceColorScheme getColorSchemeForState(JList list, int index, SubstanceListUI listUI, ComponentState state) {
        boolean toUseHighlightKindForCurrState = index >= 0 && (state.isFacetActive(ComponentStateFacet.ROLLOVER) || state.isFacetActive(ComponentStateFacet.SELECTION));
        UpdateOptimizationInfo updateOptimizationInfo = listUI.getUpdateOptimizationInfo();
        if (toUseHighlightKindForCurrState) {
            if (updateOptimizationInfo == null) {
                return SubstanceColorSchemeUtilities.getColorScheme((Component)list, (ColorSchemeAssociationKind)ColorSchemeAssociationKind.HIGHLIGHT, (ComponentState)state);
            }
            return updateOptimizationInfo.getHighlightColorScheme(state);
        }
        if (updateOptimizationInfo == null) {
            return SubstanceColorSchemeUtilities.getColorScheme((Component)list, (ComponentState)state);
        }
        return updateOptimizationInfo.getDefaultScheme();
    }
}

