/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.inspector;

import icy.clipboard.Clipboard;
import icy.gui.component.AbstractRoisPanel;
import icy.gui.component.IcyTextField;
import icy.gui.component.SpecialValueSpinner;
import icy.gui.component.button.ColorChooserButton;
import icy.gui.component.model.SpecialValueSpinnerModel;
import icy.main.Icy;
import icy.math.MathUtil;
import icy.resource.ResourceUtil;
import icy.resource.icon.IcyIcon;
import icy.roi.ROI;
import icy.roi.ROIEvent;
import icy.roi.edit.BoundsROIEdit;
import icy.roi.edit.BoundsROIsEdit;
import icy.roi.edit.PositionROIEdit;
import icy.roi.edit.PositionROIsEdit;
import icy.roi.edit.PropertyROIsEdit;
import icy.sequence.Sequence;
import icy.system.thread.ThreadUtil;
import icy.type.point.Point5D;
import icy.type.rectangle.Rectangle5D;
import icy.util.StringUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Semaphore;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JToggleButton;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class RoiControlPanel
extends JPanel
implements ColorChooserButton.ColorChangeListener,
IcyTextField.TextChangeListener,
Clipboard.ClipboardListener,
ChangeListener,
ActionListener {
    private static final long serialVersionUID = 7403770406075917063L;
    JLabel posCFieldLabel;
    JLabel posTFieldLabel;
    JLabel posZFieldLabel;
    JLabel posZSpinnerLabel;
    JLabel posTSpinnerLabel;
    JLabel posCSpinnerLabel;
    IcyTextField posXField;
    IcyTextField posYField;
    IcyTextField posTField;
    IcyTextField posZField;
    IcyTextField sizeXField;
    IcyTextField sizeZField;
    IcyTextField sizeYField;
    IcyTextField sizeTField;
    IcyTextField posCField;
    IcyTextField sizeCField;
    SpecialValueSpinner posZSpinner;
    SpecialValueSpinner posTSpinner;
    SpecialValueSpinner posCSpinner;
    ColorChooserButton colorButton;
    JSlider alphaSlider;
    JSpinner strokeSpinner;
    JToggleButton readOnlyToggle;
    JCheckBox displayNameCheckBox;
    JButton setAsDefaultBtn;
    private final AbstractRoisPanel roisPanel;
    final Semaphore modifyingRoi;
    private final List<Reference<ROI>> modifiedRois;
    final Runnable roiActionsRefresher;
    final Runnable roiPropertiesRefresher;
    IcyIcon icon_locked = new IcyIcon(ResourceUtil.ICON_LOCK_CLOSE);
    IcyIcon icon_unlocked = new IcyIcon(ResourceUtil.ICON_LOCK_OPEN);

    public RoiControlPanel(AbstractRoisPanel roisPanel) {
        this.roisPanel = roisPanel;
        this.modifyingRoi = new Semaphore(1);
        this.modifiedRois = new ArrayList<Reference<ROI>>();
        this.roiActionsRefresher = new Runnable(){

            @Override
            public void run() {
                RoiControlPanel.this.refreshROIActionsInternal();
            }
        };
        this.roiPropertiesRefresher = new Runnable(){

            @Override
            public void run() {
                RoiControlPanel.this.refreshROIPropertiesInternal();
            }
        };
        this.initialize();
        this.colorButton.addColorChangeListener(this);
        this.strokeSpinner.addChangeListener(this);
        this.alphaSlider.addChangeListener(this);
        this.readOnlyToggle.addActionListener(this);
        this.displayNameCheckBox.addActionListener(this);
        this.posXField.addTextChangeListener(this);
        this.posYField.addTextChangeListener(this);
        this.posZField.addTextChangeListener(this);
        this.posZSpinner.addChangeListener(this);
        this.posTField.addTextChangeListener(this);
        this.posTSpinner.addChangeListener(this);
        this.posCField.addTextChangeListener(this);
        this.posCSpinner.addChangeListener(this);
        this.sizeXField.addTextChangeListener(this);
        this.sizeYField.addTextChangeListener(this);
        this.sizeZField.addTextChangeListener(this);
        this.sizeTField.addTextChangeListener(this);
        this.sizeCField.addTextChangeListener(this);
        this.setAsDefaultBtn.addActionListener(this);
        Clipboard.addListener(this);
        this.refreshROIActionsInternal();
        this.refreshROIPropertiesInternal();
    }

    private void initialize() {
        this.setLayout(new BoxLayout(this, 3));
        JPanel actionPanel = new JPanel();
        actionPanel.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), "Properties", 4, 2, null, new Color(0, 0, 0)));
        this.add(actionPanel);
        GridBagLayout gbl_actionPanel = new GridBagLayout();
        gbl_actionPanel.columnWidths = new int[]{0, 0, 0, 60, 0, 0, 0};
        gbl_actionPanel.rowHeights = new int[]{0, 0, 0};
        gbl_actionPanel.columnWeights = new double[]{0.0, 1.0, 0.0, 1.0, 1.0, 0.0, Double.MIN_VALUE};
        gbl_actionPanel.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        actionPanel.setLayout(gbl_actionPanel);
        JLabel lblColor = new JLabel("Color");
        GridBagConstraints gbc_lblColor = new GridBagConstraints();
        gbc_lblColor.anchor = 17;
        gbc_lblColor.insets = new Insets(0, 0, 5, 5);
        gbc_lblColor.gridx = 0;
        gbc_lblColor.gridy = 0;
        actionPanel.add((Component)lblColor, gbc_lblColor);
        this.colorButton = new ColorChooserButton();
        GridBagConstraints gbc_colorButton = new GridBagConstraints();
        gbc_colorButton.fill = 2;
        gbc_colorButton.insets = new Insets(0, 0, 5, 5);
        gbc_colorButton.gridx = 1;
        gbc_colorButton.gridy = 0;
        actionPanel.add((Component)this.colorButton, gbc_colorButton);
        this.colorButton.setToolTipText("ROI color");
        JLabel lblContentOpacity = new JLabel("Opacity");
        GridBagConstraints gbc_lblContentOpacity = new GridBagConstraints();
        gbc_lblContentOpacity.insets = new Insets(0, 0, 5, 5);
        gbc_lblContentOpacity.gridx = 2;
        gbc_lblContentOpacity.gridy = 0;
        actionPanel.add((Component)lblContentOpacity, gbc_lblContentOpacity);
        this.alphaSlider = new JSlider();
        this.alphaSlider.setFocusable(false);
        GridBagConstraints gbc_alphaSlider = new GridBagConstraints();
        gbc_alphaSlider.gridwidth = 2;
        gbc_alphaSlider.fill = 2;
        gbc_alphaSlider.insets = new Insets(0, 0, 5, 5);
        gbc_alphaSlider.gridx = 3;
        gbc_alphaSlider.gridy = 0;
        actionPanel.add((Component)this.alphaSlider, gbc_alphaSlider);
        this.alphaSlider.setPreferredSize(new Dimension(80, 20));
        this.alphaSlider.setMaximumSize(new Dimension(Short.MAX_VALUE, 20));
        this.alphaSlider.setMinimumSize(new Dimension(36, 20));
        this.alphaSlider.setToolTipText("ROI content opacity");
        this.readOnlyToggle = new JToggleButton((Icon)((Object)new IcyIcon(ResourceUtil.ICON_LOCK_CLOSE)));
        this.readOnlyToggle.setSelected(true);
        this.readOnlyToggle.setBorderPainted(false);
        this.readOnlyToggle.setFocusPainted(false);
        this.readOnlyToggle.setIconTextGap(0);
        this.readOnlyToggle.setMaximumSize(new Dimension(29, 29));
        this.readOnlyToggle.setMinimumSize(new Dimension(29, 29));
        this.readOnlyToggle.setPreferredSize(new Dimension(29, 29));
        this.readOnlyToggle.setToolTipText("Enable/Disable ROI edition");
        GridBagConstraints gbc_readOnlyToggle = new GridBagConstraints();
        gbc_readOnlyToggle.insets = new Insets(0, 0, 5, 0);
        gbc_readOnlyToggle.gridwidth = 1;
        gbc_readOnlyToggle.gridx = 5;
        gbc_readOnlyToggle.gridy = 0;
        actionPanel.add((Component)this.readOnlyToggle, gbc_readOnlyToggle);
        JLabel lblNewLabel = new JLabel("Stroke");
        GridBagConstraints gbc_lblNewLabel = new GridBagConstraints();
        gbc_lblNewLabel.anchor = 17;
        gbc_lblNewLabel.insets = new Insets(0, 0, 0, 5);
        gbc_lblNewLabel.gridx = 0;
        gbc_lblNewLabel.gridy = 1;
        actionPanel.add((Component)lblNewLabel, gbc_lblNewLabel);
        this.strokeSpinner = new JSpinner();
        this.strokeSpinner.setToolTipText("ROI stroke size (for visualization only)");
        this.strokeSpinner.setModel(new SpinnerNumberModel(1.0, 1.0, 9.0, 1.0));
        this.strokeSpinner.setMinimumSize(new Dimension(50, 20));
        this.strokeSpinner.setPreferredSize(new Dimension(50, 20));
        GridBagConstraints gbc_strokeSpinner = new GridBagConstraints();
        gbc_strokeSpinner.fill = 2;
        gbc_strokeSpinner.insets = new Insets(0, 0, 0, 5);
        gbc_strokeSpinner.gridx = 1;
        gbc_strokeSpinner.gridy = 1;
        actionPanel.add((Component)this.strokeSpinner, gbc_strokeSpinner);
        this.displayNameCheckBox = new JCheckBox("Show name");
        this.displayNameCheckBox.setToolTipText("Show the ROI name");
        this.displayNameCheckBox.setMargin(new Insets(2, 0, 2, 2));
        this.displayNameCheckBox.setIconTextGap(10);
        this.displayNameCheckBox.setHorizontalTextPosition(10);
        GridBagConstraints gbc_displayNameCheckBox = new GridBagConstraints();
        gbc_displayNameCheckBox.anchor = 17;
        gbc_displayNameCheckBox.insets = new Insets(0, 0, 0, 5);
        gbc_displayNameCheckBox.gridwidth = 2;
        gbc_displayNameCheckBox.gridx = 2;
        gbc_displayNameCheckBox.gridy = 1;
        actionPanel.add((Component)this.displayNameCheckBox, gbc_displayNameCheckBox);
        this.setAsDefaultBtn = new JButton("As default");
        this.setAsDefaultBtn.setEnabled(false);
        this.setAsDefaultBtn.setMargin(new Insets(2, 2, 2, 2));
        this.setAsDefaultBtn.setIconTextGap(0);
        this.setAsDefaultBtn.setToolTipText("Set the current color, opacity, stroke and show name values as the default settings");
        GridBagConstraints gbc_setAsDefaultBtn = new GridBagConstraints();
        gbc_setAsDefaultBtn.fill = 2;
        gbc_setAsDefaultBtn.gridwidth = 2;
        gbc_setAsDefaultBtn.insets = new Insets(0, 0, 0, 5);
        gbc_setAsDefaultBtn.gridx = 4;
        gbc_setAsDefaultBtn.gridy = 1;
        actionPanel.add((Component)this.setAsDefaultBtn, gbc_setAsDefaultBtn);
        JPanel positionAndSizePanel = new JPanel();
        this.add(positionAndSizePanel);
        GridBagLayout gbl_positionAndSizePanel = new GridBagLayout();
        gbl_positionAndSizePanel.columnWidths = new int[]{0, 0, 0};
        gbl_positionAndSizePanel.rowHeights = new int[]{0, 0};
        gbl_positionAndSizePanel.columnWeights = new double[]{1.0, 1.0, Double.MIN_VALUE};
        gbl_positionAndSizePanel.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        positionAndSizePanel.setLayout(gbl_positionAndSizePanel);
        JPanel positionPanel = new JPanel();
        positionPanel.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), "Position", 1, 2, null, new Color(0, 0, 0)));
        GridBagConstraints gbc_positionPanel = new GridBagConstraints();
        gbc_positionPanel.anchor = 11;
        gbc_positionPanel.insets = new Insets(0, 0, 0, 5);
        gbc_positionPanel.fill = 2;
        gbc_positionPanel.gridx = 0;
        gbc_positionPanel.gridy = 0;
        positionAndSizePanel.add((Component)positionPanel, gbc_positionPanel);
        GridBagLayout gbl_positionPanel = new GridBagLayout();
        gbl_positionPanel.columnWidths = new int[]{20, 0, 0};
        gbl_positionPanel.rowHeights = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0};
        gbl_positionPanel.columnWeights = new double[]{0.0, 1.0, Double.MIN_VALUE};
        gbl_positionPanel.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        positionPanel.setLayout(gbl_positionPanel);
        JLabel lblX = new JLabel("X");
        GridBagConstraints gbc_lblX = new GridBagConstraints();
        gbc_lblX.insets = new Insets(0, 0, 5, 5);
        gbc_lblX.gridx = 0;
        gbc_lblX.gridy = 0;
        positionPanel.add((Component)lblX, gbc_lblX);
        this.posXField = new IcyTextField();
        GridBagConstraints gbc_posXField = new GridBagConstraints();
        gbc_posXField.insets = new Insets(0, 0, 5, 0);
        gbc_posXField.fill = 2;
        gbc_posXField.gridx = 1;
        gbc_posXField.gridy = 0;
        positionPanel.add((Component)this.posXField, gbc_posXField);
        this.posXField.setToolTipText("X position of the ROI");
        this.posXField.setColumns(8);
        JLabel lblY = new JLabel("Y");
        GridBagConstraints gbc_lblY = new GridBagConstraints();
        gbc_lblY.insets = new Insets(0, 0, 5, 5);
        gbc_lblY.gridx = 0;
        gbc_lblY.gridy = 1;
        positionPanel.add((Component)lblY, gbc_lblY);
        this.posYField = new IcyTextField();
        GridBagConstraints gbc_posYField = new GridBagConstraints();
        gbc_posYField.fill = 2;
        gbc_posYField.insets = new Insets(0, 0, 5, 0);
        gbc_posYField.gridx = 1;
        gbc_posYField.gridy = 1;
        positionPanel.add((Component)this.posYField, gbc_posYField);
        this.posYField.setToolTipText("Y position of the ROI");
        this.posYField.setColumns(8);
        this.posZFieldLabel = new JLabel("Z");
        GridBagConstraints gbc_posZFieldLabel = new GridBagConstraints();
        gbc_posZFieldLabel.insets = new Insets(0, 0, 5, 5);
        gbc_posZFieldLabel.gridx = 0;
        gbc_posZFieldLabel.gridy = 2;
        positionPanel.add((Component)this.posZFieldLabel, gbc_posZFieldLabel);
        this.posZField = new IcyTextField();
        GridBagConstraints gbc_posZField = new GridBagConstraints();
        gbc_posZField.fill = 2;
        gbc_posZField.insets = new Insets(0, 0, 5, 0);
        gbc_posZField.gridx = 1;
        gbc_posZField.gridy = 2;
        positionPanel.add((Component)this.posZField, gbc_posZField);
        this.posZField.setVisible(false);
        this.posZField.setToolTipText("Z position of the ROI");
        this.posZField.setColumns(8);
        this.posZSpinnerLabel = new JLabel("Z");
        GridBagConstraints gbc_posZSpinnerLabel = new GridBagConstraints();
        gbc_posZSpinnerLabel.insets = new Insets(0, 0, 5, 5);
        gbc_posZSpinnerLabel.gridx = 0;
        gbc_posZSpinnerLabel.gridy = 3;
        positionPanel.add((Component)this.posZSpinnerLabel, gbc_posZSpinnerLabel);
        this.posZSpinner = new SpecialValueSpinner(new SpecialValueSpinnerModel(-1, -1, 0, 1, -1, "ALL"));
        GridBagConstraints gbc_posZSpinner = new GridBagConstraints();
        gbc_posZSpinner.fill = 2;
        gbc_posZSpinner.insets = new Insets(0, 0, 5, 0);
        gbc_posZSpinner.gridx = 1;
        gbc_posZSpinner.gridy = 3;
        positionPanel.add((Component)this.posZSpinner, gbc_posZSpinner);
        this.posZSpinner.setToolTipText("Attach the ROI to a specific Z slice (set to -1 for ALL)");
        this.posTFieldLabel = new JLabel("T");
        GridBagConstraints gbc_posTFieldLabel = new GridBagConstraints();
        gbc_posTFieldLabel.insets = new Insets(0, 0, 5, 5);
        gbc_posTFieldLabel.gridx = 0;
        gbc_posTFieldLabel.gridy = 4;
        positionPanel.add((Component)this.posTFieldLabel, gbc_posTFieldLabel);
        this.posTField = new IcyTextField();
        GridBagConstraints gbc_posTField = new GridBagConstraints();
        gbc_posTField.fill = 2;
        gbc_posTField.insets = new Insets(0, 0, 5, 0);
        gbc_posTField.gridx = 1;
        gbc_posTField.gridy = 4;
        positionPanel.add((Component)this.posTField, gbc_posTField);
        this.posTField.setVisible(false);
        this.posTField.setToolTipText("T position of the ROI");
        this.posTField.setColumns(8);
        this.posTSpinnerLabel = new JLabel("T");
        GridBagConstraints gbc_posTSpinnerLabel = new GridBagConstraints();
        gbc_posTSpinnerLabel.insets = new Insets(0, 0, 5, 5);
        gbc_posTSpinnerLabel.gridx = 0;
        gbc_posTSpinnerLabel.gridy = 5;
        positionPanel.add((Component)this.posTSpinnerLabel, gbc_posTSpinnerLabel);
        this.posTSpinner = new SpecialValueSpinner(new SpecialValueSpinnerModel(-1, -1, 0, 1, -1, "ALL"));
        GridBagConstraints gbc_posTSpinner = new GridBagConstraints();
        gbc_posTSpinner.fill = 2;
        gbc_posTSpinner.insets = new Insets(0, 0, 5, 0);
        gbc_posTSpinner.gridx = 1;
        gbc_posTSpinner.gridy = 5;
        positionPanel.add((Component)this.posTSpinner, gbc_posTSpinner);
        this.posTSpinner.setToolTipText("Attach the ROI to a specific T frame (set to -1 for ALL)");
        this.posCFieldLabel = new JLabel("C");
        GridBagConstraints gbc_posCFieldLabel = new GridBagConstraints();
        gbc_posCFieldLabel.insets = new Insets(0, 0, 5, 5);
        gbc_posCFieldLabel.gridx = 0;
        gbc_posCFieldLabel.gridy = 6;
        positionPanel.add((Component)this.posCFieldLabel, gbc_posCFieldLabel);
        this.posCField = new IcyTextField();
        GridBagConstraints gbc_posCField = new GridBagConstraints();
        gbc_posCField.fill = 2;
        gbc_posCField.insets = new Insets(0, 0, 5, 0);
        gbc_posCField.gridx = 1;
        gbc_posCField.gridy = 6;
        positionPanel.add((Component)this.posCField, gbc_posCField);
        this.posCField.setVisible(false);
        this.posCField.setToolTipText("C position of the ROI");
        this.posCField.setColumns(8);
        this.posCSpinnerLabel = new JLabel("C");
        GridBagConstraints gbc_posCSpinnerLabel = new GridBagConstraints();
        gbc_posCSpinnerLabel.insets = new Insets(0, 0, 0, 5);
        gbc_posCSpinnerLabel.gridx = 0;
        gbc_posCSpinnerLabel.gridy = 7;
        positionPanel.add((Component)this.posCSpinnerLabel, gbc_posCSpinnerLabel);
        this.posCSpinner = new SpecialValueSpinner(new SpecialValueSpinnerModel(-1, -1, 0, 1, -1, "ALL"));
        GridBagConstraints gbc_posCSpinner = new GridBagConstraints();
        gbc_posCSpinner.fill = 2;
        gbc_posCSpinner.gridx = 1;
        gbc_posCSpinner.gridy = 7;
        positionPanel.add((Component)this.posCSpinner, gbc_posCSpinner);
        this.posCSpinner.setToolTipText("Attach the ROI to a specific C channel (set to -1 for ALL)");
        JPanel sizePanel = new JPanel();
        sizePanel.setBorder(new TitledBorder(null, "Dimension", 4, 2, null, null));
        GridBagConstraints gbc_sizePanel = new GridBagConstraints();
        gbc_sizePanel.anchor = 11;
        gbc_sizePanel.fill = 2;
        gbc_sizePanel.gridx = 1;
        gbc_sizePanel.gridy = 0;
        positionAndSizePanel.add((Component)sizePanel, gbc_sizePanel);
        GridBagLayout gbl_sizePanel = new GridBagLayout();
        gbl_sizePanel.columnWidths = new int[]{20, 0, 0};
        gbl_sizePanel.rowHeights = new int[]{0, 0, 0, 0, 0, 0};
        gbl_sizePanel.columnWeights = new double[]{0.0, 1.0, Double.MIN_VALUE};
        gbl_sizePanel.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        sizePanel.setLayout(gbl_sizePanel);
        JLabel lblNewLabel_2 = new JLabel("X");
        GridBagConstraints gbc_lblNewLabel_2 = new GridBagConstraints();
        gbc_lblNewLabel_2.insets = new Insets(0, 0, 5, 5);
        gbc_lblNewLabel_2.gridx = 0;
        gbc_lblNewLabel_2.gridy = 0;
        sizePanel.add((Component)lblNewLabel_2, gbc_lblNewLabel_2);
        this.sizeXField = new IcyTextField();
        GridBagConstraints gbc_sizeXField = new GridBagConstraints();
        gbc_sizeXField.insets = new Insets(0, 0, 5, 0);
        gbc_sizeXField.fill = 2;
        gbc_sizeXField.gridx = 1;
        gbc_sizeXField.gridy = 0;
        sizePanel.add((Component)this.sizeXField, gbc_sizeXField);
        this.sizeXField.setToolTipText("Size of dimension X for the ROI");
        this.sizeXField.setColumns(8);
        JLabel lblY_1 = new JLabel("Y");
        GridBagConstraints gbc_lblY_1 = new GridBagConstraints();
        gbc_lblY_1.insets = new Insets(0, 0, 5, 5);
        gbc_lblY_1.gridx = 0;
        gbc_lblY_1.gridy = 1;
        sizePanel.add((Component)lblY_1, gbc_lblY_1);
        this.sizeYField = new IcyTextField();
        GridBagConstraints gbc_sizeYField = new GridBagConstraints();
        gbc_sizeYField.fill = 2;
        gbc_sizeYField.insets = new Insets(0, 0, 5, 0);
        gbc_sizeYField.gridx = 1;
        gbc_sizeYField.gridy = 1;
        sizePanel.add((Component)this.sizeYField, gbc_sizeYField);
        this.sizeYField.setToolTipText("Size of dimension Y for the ROI");
        this.sizeYField.setColumns(8);
        JLabel sizeZFieldLabel = new JLabel("Z");
        GridBagConstraints gbc_sizeZFieldLabel = new GridBagConstraints();
        gbc_sizeZFieldLabel.insets = new Insets(0, 0, 5, 5);
        gbc_sizeZFieldLabel.gridx = 0;
        gbc_sizeZFieldLabel.gridy = 2;
        sizePanel.add((Component)sizeZFieldLabel, gbc_sizeZFieldLabel);
        this.sizeZField = new IcyTextField();
        GridBagConstraints gbc_sizeZField = new GridBagConstraints();
        gbc_sizeZField.fill = 2;
        gbc_sizeZField.insets = new Insets(0, 0, 5, 0);
        gbc_sizeZField.gridx = 1;
        gbc_sizeZField.gridy = 2;
        sizePanel.add((Component)this.sizeZField, gbc_sizeZField);
        this.sizeZField.setToolTipText("Size of dimension Z for the ROI");
        this.sizeZField.setColumns(8);
        JLabel sizeTFieldLabel = new JLabel("T");
        GridBagConstraints gbc_sizeTFieldLabel = new GridBagConstraints();
        gbc_sizeTFieldLabel.insets = new Insets(0, 0, 5, 5);
        gbc_sizeTFieldLabel.gridx = 0;
        gbc_sizeTFieldLabel.gridy = 3;
        sizePanel.add((Component)sizeTFieldLabel, gbc_sizeTFieldLabel);
        this.sizeTField = new IcyTextField();
        GridBagConstraints gbc_sizeTField = new GridBagConstraints();
        gbc_sizeTField.fill = 2;
        gbc_sizeTField.insets = new Insets(0, 0, 5, 0);
        gbc_sizeTField.gridx = 1;
        gbc_sizeTField.gridy = 3;
        sizePanel.add((Component)this.sizeTField, gbc_sizeTField);
        this.sizeTField.setToolTipText("Size of dimension T for the ROI");
        this.sizeTField.setColumns(8);
        JLabel sizeCFieldLabel = new JLabel("C");
        GridBagConstraints gbc_sizeCFieldLabel = new GridBagConstraints();
        gbc_sizeCFieldLabel.insets = new Insets(0, 0, 0, 5);
        gbc_sizeCFieldLabel.gridx = 0;
        gbc_sizeCFieldLabel.gridy = 4;
        sizePanel.add((Component)sizeCFieldLabel, gbc_sizeCFieldLabel);
        this.sizeCField = new IcyTextField();
        GridBagConstraints gbc_sizeCField = new GridBagConstraints();
        gbc_sizeCField.fill = 2;
        gbc_sizeCField.gridx = 1;
        gbc_sizeCField.gridy = 4;
        sizePanel.add((Component)this.sizeCField, gbc_sizeCField);
        this.sizeCField.setToolTipText("Size of dimension C for the ROI");
        this.sizeCField.setColumns(8);
    }

    public void selectionChanged() {
        this.refreshROIActionsAndProperties();
    }

    List<ROI> getVisibleRois() {
        return this.roisPanel.getVisibleRois();
    }

    List<ROI> getSelectedRois() {
        return this.getSelectedRois(true);
    }

    List<ROI> getSelectedRois(boolean wantReadOnly) {
        List<ROI> selected = this.roisPanel.getSelectedRois();
        if (wantReadOnly) {
            return selected;
        }
        ArrayList<ROI> result = new ArrayList<ROI>(selected.size());
        for (ROI roi : selected) {
            if (roi.isReadOnly()) continue;
            result.add(roi);
        }
        return result;
    }

    static double formatPosition(double pos, double size) {
        if (size == Double.POSITIVE_INFINITY) {
            return -1.0;
        }
        return MathUtil.roundSignificant(pos, 5, true);
    }

    static String getPositionAsString(double pos, double size) {
        if (size == Double.POSITIVE_INFINITY) {
            return "all";
        }
        return StringUtil.toString(MathUtil.roundSignificant(pos, 5, true));
    }

    static double formatSize(double value) {
        return MathUtil.roundSignificant(value, 5, true);
    }

    static String getSizeAsString(double value) {
        if (value == Double.POSITIVE_INFINITY) {
            return "\u221e";
        }
        return StringUtil.toString(RoiControlPanel.formatSize(value));
    }

    public void refreshROIActions() {
        ThreadUtil.runSingle(this.roiActionsRefresher);
    }

    void refreshROIActionsInternal() {
        final Sequence sequence = Icy.getMainInterface().getActiveSequence();
        List<ROI> selectedRois = this.getSelectedRois();
        ROI roi = selectedRois.size() > 0 ? selectedRois.get(0) : null;
        boolean canSetPos = false;
        boolean canSetBnd = false;
        boolean readOnly = true;
        for (ROI r : selectedRois) {
            readOnly &= r.isReadOnly();
            canSetPos |= r.canSetPosition();
            canSetBnd |= r.canSetBounds();
        }
        final boolean hasSelected = roi != null;
        final boolean canSetPosition = canSetPos;
        final boolean canSetBounds = canSetBnd;
        final boolean editable = !readOnly;
        final int dim = roi != null ? roi.getDimension() : 0;
        ThreadUtil.sleep(1);
        ThreadUtil.invokeNow(new Runnable(){
            final /* synthetic */ RoiControlPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                if (this.this$0.modifyingRoi.tryAcquire()) {
                    try {
                        if (sequence != null) {
                            ((SpecialValueSpinnerModel)this.this$0.posZSpinner.getModel()).setMaximum(Integer.valueOf(sequence.getSizeZ() - 1));
                            ((SpecialValueSpinnerModel)this.this$0.posTSpinner.getModel()).setMaximum(Integer.valueOf(sequence.getSizeT() - 1));
                            ((SpecialValueSpinnerModel)this.this$0.posCSpinner.getModel()).setMaximum(Integer.valueOf(sequence.getSizeC() - 1));
                        } else {
                            ((SpecialValueSpinnerModel)this.this$0.posZSpinner.getModel()).setMaximum(Integer.valueOf(0));
                            ((SpecialValueSpinnerModel)this.this$0.posTSpinner.getModel()).setMaximum(Integer.valueOf(0));
                            ((SpecialValueSpinnerModel)this.this$0.posCSpinner.getModel()).setMaximum(Integer.valueOf(0));
                        }
                    }
                    finally {
                        this.this$0.modifyingRoi.release();
                    }
                }
                this.this$0.posXField.setEnabled(canSetPosition && editable);
                this.this$0.posYField.setEnabled(canSetPosition && editable);
                this.this$0.posZField.setEnabled(canSetPosition && editable);
                this.this$0.posTField.setEnabled(canSetPosition && editable);
                this.this$0.posCField.setEnabled(canSetPosition && editable);
                this.this$0.posZSpinner.setEnabled(canSetPosition && editable);
                this.this$0.posTSpinner.setEnabled(canSetPosition && editable);
                this.this$0.posCSpinner.setEnabled(canSetPosition && editable);
                this.this$0.sizeXField.setEnabled(canSetBounds && editable);
                this.this$0.sizeYField.setEnabled(canSetBounds && editable && dim > 1);
                this.this$0.sizeZField.setEnabled(canSetBounds && editable && dim > 2);
                this.this$0.sizeTField.setEnabled(canSetBounds && editable && dim > 3);
                this.this$0.sizeCField.setEnabled(canSetBounds && editable && dim > 4);
                if (dim > 2) {
                    this.this$0.posZField.setVisible(true);
                    this.this$0.posZFieldLabel.setVisible(true);
                    this.this$0.posZSpinner.setVisible(false);
                    this.this$0.posZSpinnerLabel.setVisible(false);
                } else {
                    this.this$0.posZField.setVisible(false);
                    this.this$0.posZFieldLabel.setVisible(false);
                    this.this$0.posZSpinner.setVisible(true);
                    this.this$0.posZSpinnerLabel.setVisible(true);
                }
                if (dim > 3) {
                    this.this$0.posTField.setVisible(true);
                    this.this$0.posTFieldLabel.setVisible(true);
                    this.this$0.posTSpinner.setVisible(false);
                    this.this$0.posTSpinnerLabel.setVisible(false);
                } else {
                    this.this$0.posTField.setVisible(false);
                    this.this$0.posTFieldLabel.setVisible(false);
                    this.this$0.posTSpinner.setVisible(true);
                    this.this$0.posTSpinnerLabel.setVisible(true);
                }
                if (dim > 4) {
                    this.this$0.posCField.setVisible(true);
                    this.this$0.posCFieldLabel.setVisible(true);
                    this.this$0.posCSpinner.setVisible(false);
                    this.this$0.posCSpinnerLabel.setVisible(false);
                } else {
                    this.this$0.posCField.setVisible(false);
                    this.this$0.posCFieldLabel.setVisible(false);
                    this.this$0.posCSpinner.setVisible(true);
                    this.this$0.posCSpinnerLabel.setVisible(true);
                }
                this.this$0.colorButton.setEnabled(hasSelected);
                this.this$0.strokeSpinner.setEnabled(hasSelected);
                this.this$0.alphaSlider.setEnabled(hasSelected);
                this.this$0.readOnlyToggle.setEnabled(hasSelected);
                this.this$0.readOnlyToggle.setSelected(!editable);
                this.this$0.updateReadOnlyButtonState();
                this.this$0.displayNameCheckBox.setEnabled(hasSelected);
                this.this$0.setAsDefaultBtn.setEnabled(hasSelected);
            }
        });
    }

    private void updateReadOnlyButtonState() {
        if (this.readOnlyToggle.isSelected()) {
            this.readOnlyToggle.setIcon((Icon)((Object)this.icon_locked));
        } else {
            this.readOnlyToggle.setIcon((Icon)((Object)this.icon_unlocked));
        }
    }

    public void refreshROIProperties() {
        ThreadUtil.runSingle(this.roiPropertiesRefresher);
    }

    void refreshROIPropertiesInternal() {
        List<ROI> rois = this.getSelectedRois();
        final ROI roi = rois.size() > 0 ? rois.get(0) : null;
        final Rectangle5D bounds = roi != null ? roi.getBounds5D() : null;
        ThreadUtil.sleep(1);
        ThreadUtil.invokeNow(new Runnable(){
            final /* synthetic */ RoiControlPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                if (!this.this$0.modifyingRoi.tryAcquire()) {
                    return;
                }
                try {
                    if (roi != null) {
                        this.this$0.colorButton.setColor(roi.getColor());
                        this.this$0.strokeSpinner.setValue(roi.getStroke());
                        this.this$0.alphaSlider.setValue((int)(roi.getOpacity() * 100.0f));
                        this.this$0.displayNameCheckBox.setSelected(roi.getShowName());
                    } else {
                        this.this$0.colorButton.setColor(Color.gray);
                        this.this$0.strokeSpinner.setValue(1.0);
                        this.this$0.alphaSlider.setValue(0);
                        this.this$0.displayNameCheckBox.setSelected(false);
                    }
                    if (bounds != null) {
                        this.this$0.posXField.setText(RoiControlPanel.getPositionAsString(bounds.getX(), bounds.getSizeX()));
                        this.this$0.posYField.setText(RoiControlPanel.getPositionAsString(bounds.getY(), bounds.getSizeY()));
                        this.this$0.posZSpinner.setValue((int)RoiControlPanel.formatPosition(bounds.getZ(), bounds.getSizeZ()));
                        this.this$0.posZField.setText(RoiControlPanel.getPositionAsString(bounds.getZ(), bounds.getSizeZ()));
                        this.this$0.posTSpinner.setValue((int)RoiControlPanel.formatPosition(bounds.getT(), bounds.getSizeT()));
                        this.this$0.posTField.setText(RoiControlPanel.getPositionAsString(bounds.getT(), bounds.getSizeT()));
                        this.this$0.posCSpinner.setValue((int)RoiControlPanel.formatPosition(bounds.getC(), bounds.getSizeC()));
                        this.this$0.posCField.setText(RoiControlPanel.getPositionAsString(bounds.getC(), bounds.getSizeC()));
                        this.this$0.sizeXField.setText(RoiControlPanel.getSizeAsString(bounds.getSizeX()));
                        this.this$0.sizeYField.setText(RoiControlPanel.getSizeAsString(bounds.getSizeY()));
                        this.this$0.sizeZField.setText(RoiControlPanel.getSizeAsString(bounds.getSizeZ()));
                        this.this$0.sizeTField.setText(RoiControlPanel.getSizeAsString(bounds.getSizeT()));
                        this.this$0.sizeCField.setText(RoiControlPanel.getSizeAsString(bounds.getSizeC()));
                    } else {
                        this.this$0.posXField.setText("");
                        this.this$0.posYField.setText("");
                        this.this$0.posZField.setText("");
                        this.this$0.posTField.setText("");
                        this.this$0.posCField.setText("");
                        this.this$0.posZSpinner.setValue(0);
                        this.this$0.posTSpinner.setValue(0);
                        this.this$0.posCSpinner.setValue(0);
                        this.this$0.sizeXField.setText("");
                        this.this$0.sizeYField.setText("");
                        this.this$0.sizeZField.setText("");
                        this.this$0.sizeTField.setText("");
                        this.this$0.sizeCField.setText("");
                    }
                }
                finally {
                    this.this$0.modifyingRoi.release();
                }
            }
        });
    }

    public void refreshROIActionsAndProperties() {
        ThreadUtil.runSingle(this.roiActionsRefresher);
        ThreadUtil.runSingle(this.roiPropertiesRefresher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void textChanged(IcyTextField source, boolean validate) {
        if (!source.isEnabled()) {
            return;
        }
        if (!validate) {
            this.modifiedRois.clear();
            for (ROI roi : this.getSelectedRois()) {
                this.modifiedRois.add(new WeakReference<ROI>(roi));
            }
            return;
        }
        ArrayList<ROI> rois = new ArrayList<ROI>();
        for (Reference<ROI> ref : this.modifiedRois) {
            ROI roi = ref.get();
            if (roi == null) continue;
            rois.add(roi);
        }
        if (rois.isEmpty()) {
            return;
        }
        if (!this.modifyingRoi.tryAcquire()) {
            return;
        }
        try {
            double value;
            ArrayList<ROI> roiToModify;
            if (source == this.posXField || source == this.posYField || source == this.posZField || source == this.posTField || source == this.posCField) {
                double value2 = StringUtil.parseDouble(source.getText(), Double.NaN);
                if (!Double.isNaN(value2)) {
                    roiToModify = new ArrayList<ROI>();
                    for (ROI roi : rois) {
                        if (roi.isReadOnly() || !roi.canSetPosition()) continue;
                        roiToModify.add(roi);
                    }
                    if (!roiToModify.isEmpty()) {
                        Point5D positionSet = null;
                        if (roiToModify.size() == 1) {
                            ROI roi;
                            roi = (ROI)roiToModify.get(0);
                            Point5D savePosition = roi.getPosition5D();
                            Point5D position = (Point5D)savePosition.clone();
                            if (source == this.posXField) {
                                position.setX(value2);
                            } else if (source == this.posYField) {
                                position.setY(value2);
                            } else if (source == this.posZField) {
                                position.setZ(value2);
                            } else if (source == this.posTField) {
                                position.setT(value2);
                            } else {
                                position.setC(value2);
                            }
                            roi.setPosition5D(position);
                            positionSet = roi.getPosition5D();
                            Icy.getMainInterface().getUndoManager().addEdit(new PositionROIEdit(roi, savePosition, false));
                        } else {
                            ArrayList<Point5D> savePositions = new ArrayList<Point5D>();
                            ArrayList<Point5D> newPositions = new ArrayList<Point5D>();
                            for (ROI roi : roiToModify) {
                                savePositions.add(roi.getPosition5D());
                            }
                            for (ROI roi : roiToModify) {
                                Point5D position = roi.getPosition5D();
                                if (source == this.posXField) {
                                    position.setX(value2);
                                } else if (source == this.posYField) {
                                    position.setY(value2);
                                } else if (source == this.posZField) {
                                    position.setZ(value2);
                                } else if (source == this.posTField) {
                                    position.setT(value2);
                                } else {
                                    position.setC(value2);
                                }
                                roi.setPosition5D(position);
                                if (positionSet == null) {
                                    positionSet = roi.getPosition5D();
                                }
                                newPositions.add(position);
                            }
                            Icy.getMainInterface().getUndoManager().addEdit(new PositionROIsEdit(roiToModify, savePositions, newPositions, false));
                        }
                        if (positionSet != null) {
                            double p = source == this.posXField ? positionSet.getX() : (source == this.posYField ? positionSet.getY() : (source == this.posZField ? positionSet.getZ() : (source == this.posTField ? positionSet.getT() : positionSet.getC())));
                            if (p == Double.NEGATIVE_INFINITY) {
                                p = -1.0;
                            }
                            source.setText(Double.toString(p));
                        }
                    }
                }
            } else if (!(source != this.sizeXField && source != this.sizeYField && source != this.sizeZField && source != this.sizeTField && source != this.sizeCField || Double.isNaN(value = StringUtil.parseDouble(source.getText(), Double.NaN)))) {
                roiToModify = new ArrayList();
                for (ROI roi : rois) {
                    if (roi.isReadOnly() || !roi.canSetPosition()) continue;
                    roiToModify.add(roi);
                }
                if (!roiToModify.isEmpty()) {
                    Rectangle5D boundsSet = null;
                    if (roiToModify.size() == 1) {
                        ROI roi;
                        roi = (ROI)roiToModify.get(0);
                        Rectangle5D saveBounds = roi.getBounds5D();
                        Rectangle5D bounds = (Rectangle5D)saveBounds.clone();
                        if (source == this.sizeXField) {
                            bounds.setSizeX(value);
                        } else if (source == this.sizeYField) {
                            bounds.setSizeY(value);
                        } else if (source == this.sizeZField) {
                            bounds.setSizeZ(value);
                        } else if (source == this.sizeTField) {
                            bounds.setSizeT(value);
                        } else {
                            bounds.setSizeC(value);
                        }
                        roi.setBounds5D(bounds);
                        boundsSet = roi.getBounds5D();
                        Icy.getMainInterface().getUndoManager().addEdit(new BoundsROIEdit(roi, saveBounds, false));
                    } else {
                        ArrayList<Rectangle5D> saveBoundsList = new ArrayList<Rectangle5D>();
                        ArrayList<Rectangle5D> newBoundsList = new ArrayList<Rectangle5D>();
                        for (ROI roi : roiToModify) {
                            saveBoundsList.add(roi.getBounds5D());
                        }
                        for (ROI roi : roiToModify) {
                            Rectangle5D bounds = roi.getBounds5D();
                            if (source == this.sizeXField) {
                                bounds.setSizeX(value);
                            } else if (source == this.sizeYField) {
                                bounds.setSizeY(value);
                            } else if (source == this.sizeZField) {
                                bounds.setSizeZ(value);
                            } else if (source == this.sizeTField) {
                                bounds.setSizeT(value);
                            } else {
                                bounds.setSizeC(value);
                            }
                            roi.setBounds5D(bounds);
                            if (boundsSet == null) {
                                boundsSet = roi.getBounds5D();
                            }
                            newBoundsList.add(bounds);
                        }
                        Icy.getMainInterface().getUndoManager().addEdit(new BoundsROIsEdit(roiToModify, saveBoundsList, newBoundsList, false));
                    }
                    if (boundsSet != null) {
                        double p = source == this.sizeXField ? boundsSet.getSizeX() : (source == this.sizeYField ? boundsSet.getSizeY() : (source == this.sizeZField ? boundsSet.getSizeZ() : (source == this.sizeTField ? boundsSet.getSizeT() : boundsSet.getSizeC())));
                        source.setText(Double.toString(p));
                    }
                }
            }
        }
        finally {
            this.modifyingRoi.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void colorChanged(ColorChooserButton source) {
        if (!source.isEnabled()) {
            return;
        }
        Sequence sequence = Icy.getMainInterface().getActiveSequence();
        if (sequence == null) {
            return;
        }
        if (!this.modifyingRoi.tryAcquire()) {
            return;
        }
        List<ROI> rois = this.getSelectedRois();
        ArrayList<Object> oldValues = new ArrayList<Object>();
        Color color = source.getColor();
        sequence.beginUpdate();
        try {
            for (ROI roi : rois) {
                oldValues.add(roi.getColor());
                roi.setColor(color);
            }
        }
        finally {
            sequence.endUpdate();
            this.modifyingRoi.release();
        }
        sequence.addUndoableEdit(new PropertyROIsEdit(rois, "color", oldValues, color));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stateChanged(ChangeEvent e) {
        block39: {
            if (!(e.getSource() instanceof JComponent)) {
                return;
            }
            JComponent source = (JComponent)e.getSource();
            if (!source.isEnabled()) {
                return;
            }
            Sequence sequence = Icy.getMainInterface().getActiveSequence();
            if (sequence == null) {
                return;
            }
            if (!this.modifyingRoi.tryAcquire()) {
                return;
            }
            try {
                if (source == this.strokeSpinner) {
                    List<ROI> rois = this.getSelectedRois();
                    ArrayList<Object> oldValues = new ArrayList<Object>();
                    double stroke = (Double)this.strokeSpinner.getValue();
                    sequence.beginUpdate();
                    try {
                        for (ROI roi : rois) {
                            oldValues.add(roi.getStroke());
                            roi.setStroke(stroke);
                        }
                    }
                    finally {
                        sequence.endUpdate();
                    }
                    sequence.addUndoableEdit(new PropertyROIsEdit(rois, "stroke", oldValues, stroke));
                    break block39;
                }
                if (source == this.alphaSlider) {
                    List<ROI> rois = this.getSelectedRois();
                    ArrayList<Object> oldValues = new ArrayList<Object>();
                    float opacity = (float)this.alphaSlider.getValue() / 100.0f;
                    sequence.beginUpdate();
                    try {
                        for (ROI roi : rois) {
                            oldValues.add(Float.valueOf(roi.getOpacity()));
                            roi.setOpacity(opacity);
                        }
                    }
                    finally {
                        sequence.endUpdate();
                    }
                    sequence.addUndoableEdit(new PropertyROIsEdit(rois, "opacity", oldValues, Float.valueOf(opacity)));
                    break block39;
                }
                if (source == this.posZSpinner || source == this.posTSpinner || source == this.posCSpinner) {
                    List<ROI> rois = this.getSelectedRois();
                    if (rois == null || rois.isEmpty()) {
                        return;
                    }
                    SpecialValueSpinner spinner = (SpecialValueSpinner)source;
                    double value = ((Integer)spinner.getValue()).intValue();
                    if (!Double.isNaN(value)) {
                        ArrayList<ROI> roiToModify = new ArrayList<ROI>();
                        for (ROI roi : rois) {
                            if (roi.isReadOnly() || !roi.canSetPosition()) continue;
                            roiToModify.add(roi);
                        }
                        if (!roiToModify.isEmpty()) {
                            Point5D positionSet = null;
                            if (roiToModify.size() == 1) {
                                ROI roi;
                                roi = (ROI)roiToModify.get(0);
                                Point5D savePosition = roi.getPosition5D();
                                Point5D position = (Point5D)savePosition.clone();
                                if (source == this.posZSpinner) {
                                    position.setZ(value);
                                } else if (source == this.posTSpinner) {
                                    position.setT(value);
                                } else {
                                    position.setC(value);
                                }
                                roi.setPosition5D(position);
                                positionSet = roi.getPosition5D();
                                Icy.getMainInterface().getUndoManager().addEdit(new PositionROIEdit(roi, savePosition, false));
                            } else {
                                ArrayList<Point5D> savePositions = new ArrayList<Point5D>();
                                ArrayList<Point5D> newPositions = new ArrayList<Point5D>();
                                for (ROI roi : roiToModify) {
                                    savePositions.add(roi.getPosition5D());
                                }
                                for (ROI roi : roiToModify) {
                                    Point5D position = roi.getPosition5D();
                                    if (source == this.posZSpinner) {
                                        position.setZ(value);
                                    } else if (source == this.posTSpinner) {
                                        position.setT(value);
                                    } else {
                                        position.setC(value);
                                    }
                                    roi.setPosition5D(position);
                                    if (positionSet == null) {
                                        positionSet = roi.getPosition5D();
                                    }
                                    newPositions.add(position);
                                }
                                Icy.getMainInterface().getUndoManager().addEdit(new PositionROIsEdit(roiToModify, savePositions, newPositions, false));
                            }
                            if (positionSet != null) {
                                double p = source == this.posZSpinner ? positionSet.getZ() : (source == this.posTSpinner ? positionSet.getT() : positionSet.getC());
                                if (p == Double.NEGATIVE_INFINITY) {
                                    p = -1.0;
                                }
                                spinner.setValue((int)p);
                            }
                        }
                    }
                }
            }
            finally {
                this.modifyingRoi.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        block17: {
            if (!(e.getSource() instanceof JComponent)) {
                return;
            }
            JComponent source = (JComponent)e.getSource();
            if (!source.isEnabled()) {
                return;
            }
            Sequence sequence = Icy.getMainInterface().getActiveSequence();
            if (sequence == null) {
                return;
            }
            if (!this.modifyingRoi.tryAcquire()) {
                return;
            }
            try {
                if (source == this.readOnlyToggle) {
                    for (ROI roi : this.getSelectedRois()) {
                        roi.setReadOnly(this.readOnlyToggle.isSelected());
                        roi.setSelected(true);
                    }
                    if (this.readOnlyToggle.isSelected()) {
                        this.readOnlyToggle.setIcon((Icon)((Object)this.icon_locked));
                    } else {
                        this.readOnlyToggle.setIcon((Icon)((Object)this.icon_unlocked));
                    }
                    break block17;
                }
                if (source == this.displayNameCheckBox) {
                    sequence.beginUpdate();
                    try {
                        boolean display = this.displayNameCheckBox.isSelected();
                        for (ROI roi : this.getSelectedRois()) {
                            roi.setShowName(display);
                        }
                        break block17;
                    }
                    finally {
                        sequence.endUpdate();
                    }
                }
                if (source == this.setAsDefaultBtn) {
                    boolean display = this.displayNameCheckBox.isSelected();
                    Color color = this.colorButton.getColor();
                    double stroke = (Double)this.strokeSpinner.getValue();
                    float opacity = (float)this.alphaSlider.getValue() / 100.0f;
                    ROI.setDefaultColor(color);
                    ROI.setDefaultShowName(display);
                    ROI.setDefaultOpacity(opacity);
                    ROI.setDefaultStroke(stroke);
                }
            }
            finally {
                this.modifyingRoi.release();
            }
        }
    }

    @Override
    public void clipboardChanged() {
        this.refreshROIActions();
    }

    public void roiChanged(ROIEvent event) {
        switch (event.getType()) {
            case ROI_CHANGED: {
                this.refreshROIProperties();
                break;
            }
            case FOCUS_CHANGED: {
                break;
            }
            case PROPERTY_CHANGED: {
                String propertyName = event.getPropertyName();
                if (!"readOnly".equals(propertyName)) break;
                this.refreshROIActions();
                break;
            }
            case SELECTION_CHANGED: {
                break;
            }
        }
    }
}

