/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.inspector;

import icy.action.SequenceOperationActions;
import icy.gui.component.button.IcyButton;
import icy.gui.main.ActiveSequenceListener;
import icy.main.Icy;
import icy.preferences.GeneralPreferences;
import icy.sequence.Sequence;
import icy.sequence.SequenceEvent;
import icy.system.thread.ThreadUtil;
import icy.undo.AbstractIcyUndoableEdit;
import icy.undo.IcyUndoManager;
import icy.undo.IcyUndoManagerListener;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class UndoManagerPanel
extends JPanel
implements ActiveSequenceListener,
ListSelectionListener,
IcyUndoManagerListener,
ChangeListener {
    private static final long serialVersionUID = 1464754827529975860L;
    static final String[] columnNames = new String[]{"", "Action"};
    protected IcyUndoManager undoManager = null;
    AbstractTableModel tableModel;
    ListSelectionModel tableSelectionModel;
    JTable table;
    boolean isSelectionAdjusting = false;
    IcyButton undoButton;
    IcyButton redoButton;
    JSpinner historySizeField;
    IcyButton clearAllButLastButton;
    IcyButton clearAllButton;
    final Runnable refresher;

    public UndoManagerPanel() {
        this.initialize();
        this.historySizeField.setValue(GeneralPreferences.getHistorySize());
        this.historySizeField.addChangeListener(this);
        this.refresher = new Runnable(){

            @Override
            public void run() {
                UndoManagerPanel.this.refreshTableDataAndActions();
            }
        };
        this.refresher.run();
    }

    private void initialize() {
        this.tableModel = new AbstractTableModel(){
            private static final long serialVersionUID = -8573364273165723214L;

            @Override
            public int getColumnCount() {
                return columnNames.length;
            }

            @Override
            public String getColumnName(int column) {
                return columnNames[column];
            }

            @Override
            public int getRowCount() {
                if (UndoManagerPanel.this.undoManager != null) {
                    return UndoManagerPanel.this.undoManager.getEditsCount() + 1;
                }
                return 1;
            }

            @Override
            public Object getValueAt(int row, int column) {
                if (row == 0) {
                    if (column == 0) {
                        return null;
                    }
                    if (UndoManagerPanel.this.undoManager != null) {
                        return "Initial state";
                    }
                    return "No opened sequence";
                }
                if (UndoManagerPanel.this.undoManager != null) {
                    AbstractIcyUndoableEdit edit = UndoManagerPanel.this.undoManager.getEdit(row - 1);
                    switch (column) {
                        case 0: {
                            return edit.getIcon();
                        }
                        case 1: {
                            return edit.getPresentationName();
                        }
                    }
                }
                return "";
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                if (columnIndex == 0) {
                    return Icon.class;
                }
                return String.class;
            }
        };
        this.table = new JTable(this.tableModel);
        this.table.setToolTipText("Click on an action to undo or redo until that point");
        TableColumnModel colModel = this.table.getColumnModel();
        TableColumn col = colModel.getColumn(0);
        col.setPreferredWidth(20);
        col.setMinWidth(20);
        col.setMaxWidth(20);
        col = colModel.getColumn(1);
        col.setPreferredWidth(100);
        col.setMinWidth(60);
        this.table.setRowHeight(20);
        this.table.setColumnSelectionAllowed(false);
        this.table.setRowSelectionAllowed(true);
        this.table.setShowVerticalLines(true);
        this.table.setAutoCreateRowSorter(false);
        this.table.setAutoResizeMode(3);
        this.tableSelectionModel = this.table.getSelectionModel();
        this.tableSelectionModel.addListSelectionListener(this);
        this.tableSelectionModel.setSelectionMode(1);
        JPanel middlePanel = new JPanel();
        middlePanel.setLayout(new BoxLayout(middlePanel, 3));
        middlePanel.add(this.table.getTableHeader());
        JScrollPane sc = new JScrollPane(this.table, 22, 31);
        sc.setToolTipText("");
        middlePanel.add(sc);
        JPanel bottomPanel = new JPanel();
        bottomPanel.setBorder(new EmptyBorder(2, 0, 0, 0));
        bottomPanel.setLayout(new BoxLayout(bottomPanel, 2));
        this.undoButton = new IcyButton(SequenceOperationActions.undoAction);
        this.undoButton.setFlat(true);
        this.undoButton.setHideActionText(true);
        bottomPanel.add(this.undoButton);
        this.redoButton = new IcyButton(SequenceOperationActions.redoAction);
        this.redoButton.setFlat(true);
        this.redoButton.setHideActionText(true);
        bottomPanel.add(this.redoButton);
        Component horizontalGlue = Box.createHorizontalGlue();
        bottomPanel.add(horizontalGlue);
        JLabel lblNewLabel = new JLabel("History size");
        lblNewLabel.setToolTipText("");
        bottomPanel.add(lblNewLabel);
        Component horizontalStrut = Box.createHorizontalStrut(8);
        bottomPanel.add(horizontalStrut);
        this.historySizeField = new JSpinner();
        this.historySizeField.setModel(new SpinnerNumberModel(50, 1, 200, 1));
        this.historySizeField.setToolTipText("Maximum size of the history (lower value will reduce memory usage)");
        bottomPanel.add(this.historySizeField);
        Component horizontalStrut_2 = Box.createHorizontalStrut(8);
        bottomPanel.add(horizontalStrut_2);
        this.clearAllButLastButton = new IcyButton(SequenceOperationActions.undoClearAllButLastAction);
        this.clearAllButLastButton.setFlat(true);
        this.clearAllButLastButton.setHideActionText(true);
        bottomPanel.add(this.clearAllButLastButton);
        this.clearAllButton = new IcyButton(SequenceOperationActions.undoClearAction);
        this.clearAllButton.setFlat(true);
        this.clearAllButton.setHideActionText(true);
        bottomPanel.add(this.clearAllButton);
        this.setLayout(new BorderLayout());
        this.add((Component)middlePanel, "Center");
        this.add((Component)bottomPanel, "South");
    }

    public void setUndoManager(IcyUndoManager value) {
        if (this.undoManager != value) {
            if (this.undoManager != null) {
                this.undoManager.removeListener(this);
            }
            this.undoManager = value;
            if (this.undoManager != null) {
                this.undoManager.addListener(this);
            }
            ThreadUtil.bgRunSingle(this.refresher);
        }
    }

    public AbstractIcyUndoableEdit getLastSelectedEdit() {
        int index;
        if (this.undoManager != null && (index = this.tableSelectionModel.getMaxSelectionIndex()) > 0) {
            return this.undoManager.getSignificantEdit(index - 1);
        }
        return null;
    }

    protected void refreshTableDataAndActions() {
        ThreadUtil.invokeNow(new Runnable(){

            @Override
            public void run() {
                UndoManagerPanel.this.isSelectionAdjusting = true;
                try {
                    UndoManagerPanel.this.tableModel.fireTableDataChanged();
                    if (UndoManagerPanel.this.undoManager != null) {
                        UndoManagerPanel.this.tableSelectionModel.setSelectionInterval(0, UndoManagerPanel.this.undoManager.getNextAddIndex());
                    } else {
                        UndoManagerPanel.this.tableSelectionModel.setSelectionInterval(0, 0);
                    }
                }
                finally {
                    UndoManagerPanel.this.isSelectionAdjusting = false;
                }
                if (UndoManagerPanel.this.undoManager != null) {
                    UndoManagerPanel.this.undoButton.setEnabled(UndoManagerPanel.this.undoManager.canUndo());
                    UndoManagerPanel.this.redoButton.setEnabled(UndoManagerPanel.this.undoManager.canRedo());
                    UndoManagerPanel.this.clearAllButLastButton.setEnabled(UndoManagerPanel.this.undoManager.canUndo());
                    UndoManagerPanel.this.clearAllButton.setEnabled(UndoManagerPanel.this.undoManager.canUndo() || UndoManagerPanel.this.undoManager.canRedo());
                } else {
                    UndoManagerPanel.this.undoButton.setEnabled(false);
                    UndoManagerPanel.this.redoButton.setEnabled(false);
                    UndoManagerPanel.this.clearAllButLastButton.setEnabled(false);
                    UndoManagerPanel.this.clearAllButton.setEnabled(false);
                }
            }
        });
    }

    protected void selectionChanged() {
        if (this.undoManager != null) {
            AbstractIcyUndoableEdit selectedEdit = this.getLastSelectedEdit();
            if (selectedEdit == null) {
                this.undoManager.undoAll();
            } else {
                this.undoManager.undoOrRedoTo(selectedEdit);
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting() || this.isSelectionAdjusting) {
            return;
        }
        if (this.tableSelectionModel.getMinSelectionIndex() != 0) {
            this.tableSelectionModel.setSelectionInterval(0, this.tableSelectionModel.getMaxSelectionIndex());
        } else {
            this.selectionChanged();
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        int value = (Integer)this.historySizeField.getValue();
        for (Sequence sequence : Icy.getMainInterface().getSequences()) {
            IcyUndoManager um = sequence.getUndoManager();
            if (um == null) continue;
            um.setLimit(value);
        }
        GeneralPreferences.setHistorySize(value);
        this.refreshTableDataAndActions();
    }

    @Override
    public void undoManagerChanged(IcyUndoManager source) {
        ThreadUtil.bgRunSingle(this.refresher);
    }

    @Override
    public void sequenceActivated(Sequence sequence) {
        if (sequence == null) {
            this.setUndoManager(null);
        } else {
            this.setUndoManager(sequence.getUndoManager());
        }
    }

    @Override
    public void sequenceDeactivated(Sequence sequence) {
    }

    @Override
    public void activeSequenceChanged(SequenceEvent event) {
    }
}

