/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.main;

import icy.gui.frame.progress.ProgressFrame;
import icy.gui.frame.progress.TaskFrame;
import icy.gui.main.MainFrame;
import icy.main.Icy;
import icy.system.thread.ThreadUtil;
import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;

public class TaskFrameManager
implements Runnable {
    final Thread animThread;
    List<TaskFrameInfo> taskFrameInfos = new ArrayList<TaskFrameInfo>();
    long lastUpdateTime;

    private static Dimension getDesktopSize() {
        MainFrame mainFrame = Icy.getMainInterface().getMainFrame();
        if (mainFrame != null) {
            return mainFrame.getDesktopSize();
        }
        return null;
    }

    public TaskFrameManager() {
        this.animThread = new Thread((Runnable)this, "TaskFrame manager");
        this.lastUpdateTime = System.currentTimeMillis();
    }

    public void init() {
        this.animThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTaskWindow(TaskFrame tFrame, long showDelay, long hideDelay) {
        Dimension desktopSize = TaskFrameManager.getDesktopSize();
        if (desktopSize != null && !tFrame.canRemove()) {
            Point pos = new Point(desktopSize.width + 10, desktopSize.height);
            TaskFrameInfo frameInfo = new TaskFrameInfo(tFrame, pos, showDelay, hideDelay);
            List<TaskFrameInfo> list = this.taskFrameInfos;
            synchronized (list) {
                this.taskFrameInfos.add(frameInfo);
            }
        }
    }

    public void addTaskWindow(TaskFrame tFrame) {
        if (tFrame instanceof ProgressFrame) {
            this.addTaskWindow(tFrame, 0L, 1000L);
        } else {
            this.addTaskWindow(tFrame, 0L, 0L);
        }
    }

    @Override
    public void run() {
        while (true) {
            long currentTime = System.currentTimeMillis();
            long deltaTime = currentTime - this.lastUpdateTime;
            this.lastUpdateTime = currentTime;
            this.animateFrames(deltaTime);
            ThreadUtil.sleep(20);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void animateFrames(long delta) {
        int ind;
        ArrayList<TaskFrameInfo> list;
        Dimension desktopSize = TaskFrameManager.getDesktopSize();
        if (desktopSize == null) {
            return;
        }
        List<TaskFrameInfo> list2 = this.taskFrameInfos;
        synchronized (list2) {
            list = new ArrayList<TaskFrameInfo>(this.taskFrameInfos);
        }
        for (int i = list.size() - 1; i >= 0; --i) {
            TaskFrameInfo info = (TaskFrameInfo)list.get(i);
            TaskFrame frame = info.frame;
            info.showDelay -= delta;
            if (frame.canRemove()) {
                info.hideDelay -= delta;
            }
            if (!info.canHide() || info.visible && info.position.x < desktopSize.width) continue;
            list.remove(i);
            frame.internalClose();
        }
        float currentY = desktopSize.height;
        for (ind = list.size() - 1; ind >= 0; --ind) {
            int h;
            TaskFrameInfo info = (TaskFrameInfo)list.get(ind);
            if (!info.canShow() || !((currentY -= (float)(h = info.frame.getHeight())) < 0.0f)) continue;
            currentY += (float)h;
            break;
        }
        if (ind != -1) {
            for (int i = 0; i <= ind; ++i) {
                TaskFrameInfo info = (TaskFrameInfo)list.get(i);
                info.frame.internalClose();
            }
            list = new ArrayList(list.subList(ind + 1, list.size()));
        }
        for (TaskFrameInfo info : list) {
            float vectY;
            TaskFrame frame = info.frame;
            if (!info.canShow()) continue;
            int targetX = info.canHide() ? desktopSize.width + 20 : desktopSize.width - frame.getWidth();
            Point targetPos = new Point(targetX, (int)currentY);
            Point curPos = info.position;
            float vectX = (float)(targetPos.x - curPos.x) / 10.0f;
            if (vectX != 0.0f && Math.abs(vectX) < 1.0f) {
                vectX = vectX < 0.0f ? -1.0f : 1.0f;
            }
            if ((vectY = (float)(targetPos.y - curPos.y) / 10.0f) != 0.0f && Math.abs(vectY) < 1.0f) {
                vectY = vectY < 0.0f ? -1.0f : 1.0f;
            }
            Point newPos = new Point((int)((float)curPos.x + vectX), (int)((float)curPos.y + vectY));
            if (curPos.x > desktopSize.width) {
                newPos.y = targetPos.y;
            }
            info.position = newPos;
            if (frame.isInternalized()) {
                if (!frame.getLocationInternal().equals(newPos)) {
                    frame.setLocationInternal(newPos);
                }
            } else if (!frame.getLocationExternal().equals(newPos)) {
                frame.setLocationExternal(newPos);
            }
            if (info.canShow() && !info.visible) {
                frame.setVisible(true);
                frame.addToDesktopPane();
                frame.toFront();
                info.visible = true;
            }
            currentY += (float)frame.getHeight();
        }
        this.taskFrameInfos = list;
    }

    private static class TaskFrameInfo {
        final TaskFrame frame;
        Point position;
        long showDelay;
        long hideDelay;
        boolean visible;

        public TaskFrameInfo(TaskFrame frame, Point position, long showDelay, long hideDelay) {
            this.frame = frame;
            this.position = position;
            this.showDelay = showDelay;
            this.hideDelay = hideDelay;
            this.visible = false;
        }

        public boolean canHide() {
            return this.hideDelay < 0L;
        }

        public boolean canShow() {
            return this.showDelay < 0L;
        }
    }
}

