/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.menu;

import icy.action.FileActions;
import icy.action.SequenceOperationActions;
import icy.gui.component.button.IcyCommandButton;
import icy.gui.component.button.IcyCommandMenuButton;
import icy.gui.component.button.IcyCommandToggleMenuButton;
import icy.gui.util.RibbonUtil;
import icy.main.Icy;
import icy.resource.ResourceUtil;
import icy.resource.icon.IcyIcon;
import icy.sequence.Sequence;
import icy.system.thread.ThreadUtil;
import icy.type.DataType;
import icy.util.StringUtil;
import org.pushingpixels.flamingo.api.common.AbstractCommandButton;
import org.pushingpixels.flamingo.api.common.CommandToggleButtonGroup;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.JCommandMenuButton;
import org.pushingpixels.flamingo.api.common.JCommandToggleButton;
import org.pushingpixels.flamingo.api.common.JCommandToggleMenuButton;
import org.pushingpixels.flamingo.api.common.RichTooltip;
import org.pushingpixels.flamingo.api.common.icon.ResizableIcon;
import org.pushingpixels.flamingo.api.common.popup.JCommandPopupMenu;
import org.pushingpixels.flamingo.api.common.popup.JPopupPanel;
import org.pushingpixels.flamingo.api.common.popup.PopupPanelCallback;
import org.pushingpixels.flamingo.api.ribbon.AbstractRibbonBand;
import org.pushingpixels.flamingo.api.ribbon.JRibbonBand;
import org.pushingpixels.flamingo.api.ribbon.RibbonElementPriority;
import org.pushingpixels.flamingo.api.ribbon.RibbonTask;

public class SequenceOperationTask
extends RibbonTask {
    public static final String NAME = "Image / Sequence";
    final FileBand fileBand = (FileBand)this.getBand(0);
    final CopyConvertBand copyConvertBand = (CopyConvertBand)this.getBand(1);
    final RenderingBand colorConvertBand;
    final ZTConversionBand stackConversionBand;
    final PlanarOperationBand planarOperationBand = (PlanarOperationBand)this.getBand(2);
    final ChannelOperationBand channelOperationBand = (ChannelOperationBand)this.getBand(3);
    final ZOperationBand zStackOperationBand = (ZOperationBand)this.getBand(4);
    final TOperationBand tStackOperationBand = (TOperationBand)this.getBand(5);
    final Runnable buttonUpdater;

    public SequenceOperationTask() {
        super(NAME, new AbstractRibbonBand[]{new FileBand(), new CopyConvertBand(), new PlanarOperationBand(), new ChannelOperationBand(), new ZOperationBand(), new TOperationBand(), new ZTConversionBand(), new RenderingBand()});
        this.stackConversionBand = (ZTConversionBand)this.getBand(6);
        this.colorConvertBand = (RenderingBand)this.getBand(7);
        this.fileBand.updateButtonsState();
        this.copyConvertBand.updateButtonsState();
        this.colorConvertBand.updateButtonsState();
        this.channelOperationBand.updateButtonsState();
        this.planarOperationBand.updateButtonsState();
        this.stackConversionBand.updateButtonsState();
        this.zStackOperationBand.updateButtonsState();
        this.tStackOperationBand.updateButtonsState();
        this.buttonUpdater = new Runnable(){

            @Override
            public void run() {
                ThreadUtil.sleep(1);
                ThreadUtil.invokeNow(new Runnable(){

                    @Override
                    public void run() {
                        SequenceOperationTask.this.fileBand.updateButtonsState();
                        SequenceOperationTask.this.copyConvertBand.updateButtonsState();
                        SequenceOperationTask.this.colorConvertBand.updateButtonsState();
                        SequenceOperationTask.this.channelOperationBand.updateButtonsState();
                        SequenceOperationTask.this.planarOperationBand.updateButtonsState();
                        SequenceOperationTask.this.stackConversionBand.updateButtonsState();
                        SequenceOperationTask.this.zStackOperationBand.updateButtonsState();
                        SequenceOperationTask.this.tStackOperationBand.updateButtonsState();
                    }
                });
            }
        };
    }

    @Deprecated
    public double getFillValue() {
        return Icy.getMainInterface().getROIRibbonTask().getFillValue();
    }

    public void onSequenceChange() {
        ThreadUtil.runSingle(this.buttonUpdater);
    }

    public static class FileBand
    extends JRibbonBand {
        private static final long serialVersionUID = -2677243480668715388L;
        public static final String BAND_NAME = "File";
        final IcyCommandButton openButton = new IcyCommandButton(FileActions.openSequenceAction);
        final IcyCommandButton openRegionButton = new IcyCommandButton(FileActions.openSequenceRegionAction);
        final IcyCommandButton saveButton = new IcyCommandButton(FileActions.saveAsSequenceAction);

        public FileBand() {
            super(BAND_NAME, (ResizableIcon)new IcyIcon(ResourceUtil.ICON_DOC));
            this.addCommandButton((AbstractCommandButton)this.openButton, RibbonElementPriority.MEDIUM);
            this.addCommandButton((AbstractCommandButton)this.openRegionButton, RibbonElementPriority.MEDIUM);
            this.addCommandButton((AbstractCommandButton)this.saveButton, RibbonElementPriority.MEDIUM);
            RibbonUtil.setRestrictiveResizePolicies(this);
            this.updateButtonsState();
        }

        void updateButtonsState() {
            Sequence sequence = Icy.getMainInterface().getActiveSequence();
            this.openRegionButton.setEnabled(sequence != null && !StringUtil.isEmpty(sequence.getFilename()) && sequence.hasSelectedROI());
            this.saveButton.setEnabled(Icy.getMainInterface().getActiveSequence() != null);
        }
    }

    public static class CopyConvertBand
    extends JRibbonBand {
        private static final long serialVersionUID = -2677243480668715388L;
        public static final String BAND_NAME = "Copy / Convert";
        final IcyCommandButton cloneButton;
        final IcyCommandButton convertButton;
        final IcyCommandButton convertButtonRaw;

        public CopyConvertBand() {
            super(BAND_NAME, (ResizableIcon)new IcyIcon(ResourceUtil.ICON_TOOLS));
            this.setToolTipText("Copy and data type conversion operation");
            this.cloneButton = new IcyCommandButton(SequenceOperationActions.cloneSequenceAction);
            this.addCommandButton((AbstractCommandButton)this.cloneButton, RibbonElementPriority.MEDIUM);
            this.convertButton = new IcyCommandButton("Conversion", new IcyIcon(ResourceUtil.ICON_BAND_RIGHT));
            this.convertButton.setCommandButtonKind(JCommandButton.CommandButtonKind.POPUP_ONLY);
            this.convertButton.setPopupRichTooltip(new RichTooltip("Data type conversion", "Convert the sequence to the selected data type (values are scaled to fit the new type)"));
            this.convertButton.setPopupCallback(new PopupPanelCallback(){

                public JPopupPanel getPopupPanel(JCommandButton commandButton) {
                    JCommandPopupMenu result = new JCommandPopupMenu();
                    Sequence sequence = Icy.getMainInterface().getActiveSequence();
                    if (sequence != null) {
                        CommandToggleButtonGroup group = new CommandToggleButtonGroup();
                        result.addMenuButton((JCommandToggleMenuButton)CopyConvertBand.getConvertButton(sequence, DataType.UBYTE, true, group));
                        result.addMenuButton((JCommandToggleMenuButton)CopyConvertBand.getConvertButton(sequence, DataType.BYTE, true, group));
                        result.addMenuButton((JCommandToggleMenuButton)CopyConvertBand.getConvertButton(sequence, DataType.USHORT, true, group));
                        result.addMenuButton((JCommandToggleMenuButton)CopyConvertBand.getConvertButton(sequence, DataType.SHORT, true, group));
                        result.addMenuButton((JCommandToggleMenuButton)CopyConvertBand.getConvertButton(sequence, DataType.UINT, true, group));
                        result.addMenuButton((JCommandToggleMenuButton)CopyConvertBand.getConvertButton(sequence, DataType.INT, true, group));
                        result.addMenuButton((JCommandToggleMenuButton)CopyConvertBand.getConvertButton(sequence, DataType.FLOAT, true, group));
                        result.addMenuButton((JCommandToggleMenuButton)CopyConvertBand.getConvertButton(sequence, DataType.DOUBLE, true, group));
                    }
                    return result;
                }
            });
            this.addCommandButton((AbstractCommandButton)this.convertButton, RibbonElementPriority.MEDIUM);
            this.convertButtonRaw = new IcyCommandButton("Raw conversion", new IcyIcon(ResourceUtil.ICON_BAND_RIGHT));
            this.convertButtonRaw.setCommandButtonKind(JCommandButton.CommandButtonKind.POPUP_ONLY);
            this.convertButtonRaw.setPopupRichTooltip(new RichTooltip("Raw data type conversion", "Convert the sequence to the selected data type (values remain unchanged or are clamped in case of overflow)"));
            this.convertButtonRaw.setPopupCallback(new PopupPanelCallback(){

                public JPopupPanel getPopupPanel(JCommandButton commandButton) {
                    JCommandPopupMenu result = new JCommandPopupMenu();
                    Sequence sequence = Icy.getMainInterface().getActiveSequence();
                    if (sequence != null) {
                        CommandToggleButtonGroup group = new CommandToggleButtonGroup();
                        result.addMenuButton((JCommandToggleMenuButton)CopyConvertBand.getConvertButton(sequence, DataType.UBYTE, false, group));
                        result.addMenuButton((JCommandToggleMenuButton)CopyConvertBand.getConvertButton(sequence, DataType.BYTE, false, group));
                        result.addMenuButton((JCommandToggleMenuButton)CopyConvertBand.getConvertButton(sequence, DataType.USHORT, false, group));
                        result.addMenuButton((JCommandToggleMenuButton)CopyConvertBand.getConvertButton(sequence, DataType.SHORT, false, group));
                        result.addMenuButton((JCommandToggleMenuButton)CopyConvertBand.getConvertButton(sequence, DataType.UINT, false, group));
                        result.addMenuButton((JCommandToggleMenuButton)CopyConvertBand.getConvertButton(sequence, DataType.INT, false, group));
                        result.addMenuButton((JCommandToggleMenuButton)CopyConvertBand.getConvertButton(sequence, DataType.FLOAT, false, group));
                        result.addMenuButton((JCommandToggleMenuButton)CopyConvertBand.getConvertButton(sequence, DataType.DOUBLE, false, group));
                    }
                    return result;
                }
            });
            this.addCommandButton((AbstractCommandButton)this.convertButtonRaw, RibbonElementPriority.MEDIUM);
            RibbonUtil.setRestrictiveResizePolicies(this);
            this.updateButtonsState();
        }

        public static IcyCommandToggleMenuButton getConvertButton(Sequence sequence, DataType dataType, boolean scaled, CommandToggleButtonGroup group) {
            IcyCommandToggleMenuButton result = new IcyCommandToggleMenuButton(SequenceOperationActions.getConvertSequenceAction(dataType, scaled));
            group.add((JCommandToggleButton)result);
            if (sequence.getDataType_() == dataType) {
                group.setSelected((JCommandToggleButton)result, true);
                result.setEnabled(false);
            } else {
                group.setSelected((JCommandToggleButton)result, false);
            }
            return result;
        }

        void updateButtonsState() {
            Sequence seq = Icy.getMainInterface().getActiveSequence();
            boolean enabled = seq != null;
            boolean notEmpty = seq != null && !seq.isEmpty();
            this.cloneButton.setEnabled(enabled);
            this.convertButton.setEnabled(notEmpty);
            this.convertButtonRaw.setEnabled(notEmpty);
        }
    }

    public static class PlanarOperationBand
    extends JRibbonBand {
        private static final long serialVersionUID = -7475753600896040618L;
        private static final String BAND_NAME = "Plane (XY)";
        final IcyCommandButton cropButton;
        final IcyCommandButton canvasResizeButton;
        final IcyCommandButton imageResizeButton;

        public PlanarOperationBand() {
            super(BAND_NAME, (ResizableIcon)new IcyIcon(ResourceUtil.ICON_PICTURE));
            this.setToolTipText("XY (plane) operation");
            this.cropButton = new IcyCommandButton(SequenceOperationActions.cropSequenceAction);
            this.addCommandButton((AbstractCommandButton)this.cropButton, RibbonElementPriority.MEDIUM);
            this.canvasResizeButton = new IcyCommandButton(SequenceOperationActions.canvasResizeAction);
            this.addCommandButton((AbstractCommandButton)this.canvasResizeButton, RibbonElementPriority.MEDIUM);
            this.imageResizeButton = new IcyCommandButton(SequenceOperationActions.imageResizeAction);
            this.addCommandButton((AbstractCommandButton)this.imageResizeButton, RibbonElementPriority.MEDIUM);
            RibbonUtil.setRestrictiveResizePolicies(this);
            this.updateButtonsState();
        }

        void updateButtonsState() {
            Sequence seq = Icy.getMainInterface().getActiveSequence();
            boolean enabled = seq != null && !seq.isEmpty();
            this.cropButton.setEnabled(enabled);
            this.canvasResizeButton.setEnabled(enabled);
            this.imageResizeButton.setEnabled(enabled);
        }
    }

    public static class ChannelOperationBand
    extends JRibbonBand {
        private static final long serialVersionUID = -2677243480668715388L;
        public static final String BAND_NAME = "Channel (C)";
        final IcyCommandButton extractButton;
        final IcyCommandButton removeButton;
        final IcyCommandButton mergeButton;

        public ChannelOperationBand() {
            super(BAND_NAME, (ResizableIcon)new IcyIcon(ResourceUtil.ICON_TOOLS));
            this.setToolTipText("Channel operation");
            this.extractButton = new IcyCommandButton("Extract", new IcyIcon(ResourceUtil.ICON_INDENT_DECREASE));
            this.extractButton.setCommandButtonKind(JCommandButton.CommandButtonKind.POPUP_ONLY);
            this.extractButton.setPopupRichTooltip(new RichTooltip("Single channel extraction", "Create a new single channel sequence from selected channel of active sequence."));
            this.extractButton.setPopupCallback(new PopupPanelCallback(){

                public JPopupPanel getPopupPanel(JCommandButton commandButton) {
                    JCommandPopupMenu result = new JCommandPopupMenu();
                    Sequence sequence = Icy.getMainInterface().getActiveSequence();
                    if (sequence != null) {
                        for (int c = 0; c < sequence.getSizeC(); ++c) {
                            IcyCommandMenuButton button = c < SequenceOperationActions.extractChannelActions.length ? new IcyCommandMenuButton(SequenceOperationActions.extractChannelActions[c]) : new IcyCommandMenuButton(new SequenceOperationActions.ExtractChannelAction(c));
                            result.addMenuButton((JCommandMenuButton)button);
                        }
                        result.addMenuButton((JCommandMenuButton)new IcyCommandMenuButton(SequenceOperationActions.extractAllChannelAction));
                    }
                    return result;
                }
            });
            this.addCommandButton((AbstractCommandButton)this.extractButton, RibbonElementPriority.MEDIUM);
            this.removeButton = new IcyCommandButton("Remove", new IcyIcon(ResourceUtil.ICON_INDENT_REMOVE));
            this.removeButton.setCommandButtonKind(JCommandButton.CommandButtonKind.POPUP_ONLY);
            this.removeButton.setPopupRichTooltip(new RichTooltip("Remove channel", "Remove the selected channel from active sequence."));
            this.removeButton.setPopupCallback(new PopupPanelCallback(){

                public JPopupPanel getPopupPanel(JCommandButton commandButton) {
                    JCommandPopupMenu result = new JCommandPopupMenu();
                    Sequence sequence = Icy.getMainInterface().getActiveSequence();
                    if (sequence != null) {
                        for (int c = 0; c < sequence.getSizeC(); ++c) {
                            IcyCommandMenuButton button = c < SequenceOperationActions.removeChannelActions.length ? new IcyCommandMenuButton(SequenceOperationActions.removeChannelActions[c]) : new IcyCommandMenuButton(new SequenceOperationActions.RemoveChannelAction(c));
                            result.addMenuButton((JCommandMenuButton)button);
                        }
                    }
                    return result;
                }
            });
            this.addCommandButton((AbstractCommandButton)this.removeButton, RibbonElementPriority.MEDIUM);
            this.mergeButton = new IcyCommandButton(SequenceOperationActions.mergeChannelsAction);
            this.addCommandButton((AbstractCommandButton)this.mergeButton, RibbonElementPriority.MEDIUM);
            RibbonUtil.setRestrictiveResizePolicies(this);
            this.updateButtonsState();
        }

        void updateButtonsState() {
            Sequence seq = Icy.getMainInterface().getActiveSequence();
            boolean enabled = seq != null;
            boolean several = seq != null && seq.getSizeC() > 1;
            this.extractButton.setEnabled(several);
            this.removeButton.setEnabled(several);
            this.mergeButton.setEnabled(enabled);
        }
    }

    public static class ZOperationBand
    extends JRibbonBand {
        private static final long serialVersionUID = 8301134961618666184L;
        public static final String BAND_NAME = "Stack (Z)";
        final IcyCommandButton reverseButton;
        final IcyCommandButton extractButton;
        final IcyCommandButton removeButton;
        final IcyCommandButton advancedRemoveButton;
        final IcyCommandButton addButton;
        final IcyCommandButton mergeButton;

        public ZOperationBand() {
            super(BAND_NAME, (ResizableIcon)new IcyIcon(ResourceUtil.ICON_LAYER_V1));
            this.setToolTipText("Z (stack) operation");
            this.reverseButton = new IcyCommandButton(SequenceOperationActions.reverseSlicesAction);
            this.addCommandButton((AbstractCommandButton)this.reverseButton, RibbonElementPriority.MEDIUM);
            this.extractButton = new IcyCommandButton(SequenceOperationActions.extractSliceAction);
            this.addCommandButton((AbstractCommandButton)this.extractButton, RibbonElementPriority.MEDIUM);
            this.removeButton = new IcyCommandButton(SequenceOperationActions.removeSliceAction);
            this.addCommandButton((AbstractCommandButton)this.removeButton, RibbonElementPriority.MEDIUM);
            this.startGroup();
            this.addButton = new IcyCommandButton(SequenceOperationActions.addSlicesAction);
            this.addCommandButton((AbstractCommandButton)this.addButton, RibbonElementPriority.MEDIUM);
            this.mergeButton = new IcyCommandButton(SequenceOperationActions.mergeSlicesAction);
            this.addCommandButton((AbstractCommandButton)this.mergeButton, RibbonElementPriority.MEDIUM);
            this.advancedRemoveButton = new IcyCommandButton(SequenceOperationActions.removeSlicesAction);
            this.addCommandButton((AbstractCommandButton)this.advancedRemoveButton, RibbonElementPriority.MEDIUM);
            RibbonUtil.setRestrictiveResizePolicies(this);
            this.updateButtonsState();
        }

        void updateButtonsState() {
            Sequence seq = Icy.getMainInterface().getActiveSequence();
            boolean enabled = seq != null;
            boolean notEmpty = seq != null && !seq.isEmpty();
            boolean several = seq != null && seq.getSizeZ() > 1;
            this.reverseButton.setEnabled(several);
            this.extractButton.setEnabled(several);
            this.removeButton.setEnabled(several);
            this.addButton.setEnabled(notEmpty);
            this.mergeButton.setEnabled(enabled);
            this.advancedRemoveButton.setEnabled(several);
        }
    }

    public static class TOperationBand
    extends JRibbonBand {
        private static final long serialVersionUID = 3728386745443331069L;
        public static final String BAND_NAME = "Frame (T)";
        final IcyCommandButton reverseButton;
        final IcyCommandButton extractButton;
        final IcyCommandButton removeButton;
        final IcyCommandButton advancedRemoveButton;
        final IcyCommandButton addButton;
        final IcyCommandButton mergeButton;

        public TOperationBand() {
            super(BAND_NAME, (ResizableIcon)new IcyIcon(ResourceUtil.ICON_LAYER_H1));
            this.setToolTipText("T (frame) operation");
            this.reverseButton = new IcyCommandButton(SequenceOperationActions.reverseFramesAction);
            this.addCommandButton((AbstractCommandButton)this.reverseButton, RibbonElementPriority.MEDIUM);
            this.extractButton = new IcyCommandButton(SequenceOperationActions.extractFrameAction);
            this.addCommandButton((AbstractCommandButton)this.extractButton, RibbonElementPriority.MEDIUM);
            this.removeButton = new IcyCommandButton(SequenceOperationActions.removeFrameAction);
            this.addCommandButton((AbstractCommandButton)this.removeButton, RibbonElementPriority.MEDIUM);
            this.startGroup();
            this.addButton = new IcyCommandButton(SequenceOperationActions.addFramesAction);
            this.addCommandButton((AbstractCommandButton)this.addButton, RibbonElementPriority.MEDIUM);
            this.mergeButton = new IcyCommandButton(SequenceOperationActions.mergeFramesAction);
            this.addCommandButton((AbstractCommandButton)this.mergeButton, RibbonElementPriority.MEDIUM);
            this.advancedRemoveButton = new IcyCommandButton(SequenceOperationActions.removeFramesAction);
            this.addCommandButton((AbstractCommandButton)this.advancedRemoveButton, RibbonElementPriority.MEDIUM);
            RibbonUtil.setRestrictiveResizePolicies(this);
            this.updateButtonsState();
        }

        void updateButtonsState() {
            Sequence seq = Icy.getMainInterface().getActiveSequence();
            boolean enabled = seq != null;
            boolean notEmpty = seq != null && !seq.isEmpty();
            boolean several = seq != null && seq.getSizeT() > 1;
            this.reverseButton.setEnabled(several);
            this.extractButton.setEnabled(several);
            this.removeButton.setEnabled(several);
            this.addButton.setEnabled(notEmpty);
            this.mergeButton.setEnabled(enabled);
            this.advancedRemoveButton.setEnabled(several);
        }
    }

    public static class ZTConversionBand
    extends JRibbonBand {
        private static final long serialVersionUID = 8210688977085548878L;
        private static final String BAND_NAME = "Z / T conversion";
        final IcyCommandButton convertToZButton;
        final IcyCommandButton convertToTButton;
        final IcyCommandButton advancedConvertButton;

        public ZTConversionBand() {
            super(BAND_NAME, (ResizableIcon)new IcyIcon(ResourceUtil.ICON_LAYER_V2));
            this.setToolTipText("Z/T conversion");
            this.convertToZButton = new IcyCommandButton(SequenceOperationActions.convertToSlicesAction);
            this.addCommandButton((AbstractCommandButton)this.convertToZButton, RibbonElementPriority.MEDIUM);
            this.convertToTButton = new IcyCommandButton(SequenceOperationActions.convertToFramesAction);
            this.addCommandButton((AbstractCommandButton)this.convertToTButton, RibbonElementPriority.MEDIUM);
            this.advancedConvertButton = new IcyCommandButton(SequenceOperationActions.advancedZTConvertAction);
            this.addCommandButton((AbstractCommandButton)this.advancedConvertButton, RibbonElementPriority.MEDIUM);
            RibbonUtil.setRestrictiveResizePolicies(this);
            this.updateButtonsState();
        }

        void updateButtonsState() {
            Sequence seq = Icy.getMainInterface().getActiveSequence();
            boolean severalZ = seq != null && seq.getSizeZ() > 1;
            boolean severalT = seq != null && seq.getSizeT() > 1;
            this.convertToTButton.setEnabled(severalZ);
            this.convertToZButton.setEnabled(severalT);
            this.advancedConvertButton.setEnabled(severalZ || severalT);
        }
    }

    public static class RenderingBand
    extends JRibbonBand {
        private static final long serialVersionUID = -2677243480668715388L;
        public static final String BAND_NAME = "Rendering";
        final IcyCommandButton argbButton;
        final IcyCommandButton rgbButton;
        final IcyCommandButton grayButton;

        public RenderingBand() {
            super(BAND_NAME, (ResizableIcon)new IcyIcon(ResourceUtil.ICON_TOOLS));
            this.setToolTipText("Color and gray rendering");
            this.argbButton = new IcyCommandButton(SequenceOperationActions.argbSequenceAction);
            this.addCommandButton((AbstractCommandButton)this.argbButton, RibbonElementPriority.MEDIUM);
            this.rgbButton = new IcyCommandButton(SequenceOperationActions.rgbSequenceAction);
            this.addCommandButton((AbstractCommandButton)this.rgbButton, RibbonElementPriority.MEDIUM);
            this.grayButton = new IcyCommandButton(SequenceOperationActions.graySequenceAction);
            this.addCommandButton((AbstractCommandButton)this.grayButton, RibbonElementPriority.MEDIUM);
            RibbonUtil.setRestrictiveResizePolicies(this);
            this.updateButtonsState();
        }

        void updateButtonsState() {
            Sequence seq = Icy.getMainInterface().getActiveSequence();
            boolean enabled = seq != null && !seq.isEmpty();
            this.argbButton.setEnabled(enabled);
            this.rgbButton.setEnabled(enabled);
            this.grayButton.setEnabled(enabled);
        }
    }
}

