/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.plugin;

import icy.gui.frame.ActionFrame;
import icy.gui.util.GuiUtil;
import icy.plugin.PluginDescriptor;
import icy.plugin.PluginUpdater;
import icy.system.thread.ThreadUtil;
import icy.util.StringUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class PluginUpdateFrame
extends ActionFrame {
    JList pluginList;
    private DefaultListModel listModel;

    public PluginUpdateFrame(List<PluginDescriptor> toInstallPlugins) {
        super("Plugin Update", true);
        this.setPreferredSize(new Dimension(640, 500));
        JPanel titlePanel = GuiUtil.createCenteredBoldLabel("Select the plugin(s) to update in the list");
        titlePanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        final JTextArea changeLogArea = new JTextArea();
        changeLogArea.setEditable(false);
        final JLabel changeLogTitleLabel = GuiUtil.createBoldLabel("Change log :");
        this.listModel = new DefaultListModel();
        this.pluginList = new JList(this.listModel);
        for (PluginDescriptor plugin : toInstallPlugins) {
            this.listModel.addElement(plugin);
        }
        this.pluginList.setSelectionMode(2);
        this.pluginList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){
            final /* synthetic */ PluginUpdateFrame this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void valueChanged(ListSelectionEvent e) {
                final PluginDescriptor plugin = (PluginDescriptor)this.this$0.pluginList.getSelectedValue();
                if (plugin != null) {
                    ThreadUtil.bgRun(new Runnable(){
                        final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        @Override
                        public void run() {
                            plugin.loadChangeLog();
                            String changeLog = plugin.getChangeLog();
                            if (StringUtil.isEmpty(changeLog)) {
                                this.this$1.changeLogArea.setText("no change log");
                            } else {
                                this.this$1.changeLogArea.setText(changeLog);
                            }
                            this.this$1.changeLogArea.setCaretPosition(0);
                            this.this$1.changeLogTitleLabel.setText(plugin.getName() + " change log");
                        }
                    });
                }
            }
        });
        this.pluginList.setSelectionInterval(0, toInstallPlugins.size() - 1);
        this.getOkBtn().setText("Update");
        this.getCancelBtn().setText("Close");
        this.setCloseAfterAction(false);
        this.setOkAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PluginUpdateFrame.this.doUpdate();
            }
        });
        JScrollPane medScrollPane = new JScrollPane(this.pluginList);
        JScrollPane changeLogScrollPane = new JScrollPane(GuiUtil.createTabArea(changeLogArea, 4));
        JPanel bottomPanel = GuiUtil.createPageBoxPanel(Box.createVerticalStrut(4), GuiUtil.createCenteredLabel(changeLogTitleLabel), Box.createVerticalStrut(4), changeLogScrollPane);
        JPanel mainPanel = this.getMainPanel();
        JSplitPane splitPane = new JSplitPane(0, medScrollPane, bottomPanel);
        mainPanel.add((Component)titlePanel, "North");
        mainPanel.add((Component)splitPane, "Center");
        this.pack();
        this.addToDesktopPane();
        this.setVisible(true);
        this.center();
        this.requestFocus();
        splitPane.setDividerLocation(0.5);
    }

    protected void doUpdate() {
        final ArrayList<PluginDescriptor> plugins = new ArrayList<PluginDescriptor>();
        for (Object value : this.pluginList.getSelectedValues()) {
            plugins.add((PluginDescriptor)value);
        }
        for (PluginDescriptor plugin : plugins) {
            this.listModel.removeElement(plugin);
        }
        if (this.listModel.isEmpty()) {
            this.close();
        }
        ThreadUtil.bgRun(new Runnable(){
            final /* synthetic */ PluginUpdateFrame this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                if (!plugins.isEmpty()) {
                    PluginUpdater.updatePlugins(plugins, true);
                }
            }
        });
    }
}

