/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.util;

import icy.system.SystemUtil;
import icy.util.ReflectionUtil;
import java.awt.Component;
import java.lang.reflect.Method;
import javax.swing.Popup;
import javax.swing.PopupFactory;

public class CustomPopupFactory
extends PopupFactory {
    private final boolean macos = SystemUtil.isMac();
    private Method getPopupMethod = null;
    private int heavy = 0;

    public CustomPopupFactory() {
        if (this.macos) {
            try {
                this.getPopupMethod = ReflectionUtil.getMethod(PopupFactory.class, "getPopup", true, Component.class, Component.class, Integer.TYPE, Integer.TYPE, Integer.TYPE);
                this.heavy = ReflectionUtil.getField(PopupFactory.class, "HEAVY_WEIGHT_POPUP", true).getInt(null);
            }
            catch (Throwable t) {
                this.getPopupMethod = null;
                this.heavy = 0;
            }
        }
    }

    @Override
    public Popup getPopup(Component owner, Component contents, int x, int y) {
        if (this.macos && this.getPopupMethod != null) {
            if (contents == null) {
                throw new IllegalArgumentException("Popup.getPopup must be passed non-null contents");
            }
            try {
                return (Popup)this.getPopupMethod.invoke((Object)this, owner, contents, x, y, this.heavy);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return super.getPopup(owner, contents, x, y);
    }
}

