/*
 * Decompiled with CFR 0.152.
 */
package icy.image;

import icy.image.IcyBufferedImage;
import icy.sequence.Sequence;
import icy.type.DataType;
import icy.type.TypeUtil;
import java.util.concurrent.atomic.AtomicBoolean;

public class IcyBufferedImageCursor {
    private IcyBufferedImage plane;
    private int sizeX;
    private DataType planeType;
    private AtomicBoolean planeChanged;
    private Object planeData;
    private Object currentChannelData;
    private int currentChannel;

    public IcyBufferedImageCursor(IcyBufferedImage plane) {
        this.plane = plane;
        this.sizeX = plane.getSizeX();
        this.planeType = plane.getDataType_();
        plane.lockRaster();
        this.planeData = plane.getDataXYC();
        this.currentChannelData = null;
        this.currentChannel = -1;
        this.planeChanged = new AtomicBoolean(false);
    }

    public IcyBufferedImageCursor(Sequence seq, int t, int z) {
        this(seq.getImage(t, z));
    }

    public double get(int x, int y, int c) throws IndexOutOfBoundsException, RuntimeException {
        Object channelData = this.getChannelData(c);
        switch (this.planeType) {
            case UBYTE: 
            case BYTE: {
                return TypeUtil.toDouble(((byte[])channelData)[x + y * this.sizeX], this.planeType.isSigned());
            }
            case USHORT: 
            case SHORT: {
                return TypeUtil.toDouble(((short[])channelData)[x + y * this.sizeX], this.planeType.isSigned());
            }
            case UINT: 
            case INT: {
                return TypeUtil.toDouble(((int[])channelData)[x + y * this.sizeX], this.planeType.isSigned());
            }
            case FLOAT: {
                return ((float[])channelData)[x + y * this.sizeX];
            }
            case DOUBLE: {
                return ((double[])channelData)[x + y * this.sizeX];
            }
        }
        throw new RuntimeException("Unsupported data type: " + (Object)((Object)this.planeType));
    }

    public synchronized void set(int x, int y, int c, double val) throws IndexOutOfBoundsException, RuntimeException {
        Object channelData = this.getChannelData(c);
        switch (this.planeType) {
            case UBYTE: 
            case BYTE: {
                ((byte[])channelData)[x + y * this.sizeX] = (byte)val;
                break;
            }
            case USHORT: 
            case SHORT: {
                ((short[])channelData)[x + y * this.sizeX] = (short)val;
                break;
            }
            case UINT: 
            case INT: {
                ((int[])channelData)[x + y * this.sizeX] = (int)val;
                break;
            }
            case FLOAT: {
                ((float[])channelData)[x + y * this.sizeX] = (float)val;
                break;
            }
            case DOUBLE: {
                ((double[])channelData)[x + y * this.sizeX] = val;
                break;
            }
            default: {
                throw new RuntimeException("Unsupported data type");
            }
        }
        this.planeChanged.set(true);
    }

    public synchronized void setSafe(int x, int y, int c, double val) throws IndexOutOfBoundsException, RuntimeException {
        Object channelData = this.getChannelData(c);
        switch (this.planeType) {
            case UBYTE: 
            case BYTE: {
                ((byte[])channelData)[x + y * this.sizeX] = (byte)Math.round(this.getSafeValue(val));
                break;
            }
            case USHORT: 
            case SHORT: {
                ((short[])channelData)[x + y * this.sizeX] = (short)Math.round(this.getSafeValue(val));
                break;
            }
            case UINT: 
            case INT: {
                ((int[])channelData)[x + y * this.sizeX] = (int)Math.round(this.getSafeValue(val));
                break;
            }
            case FLOAT: {
                ((float[])channelData)[x + y * this.sizeX] = (float)this.getSafeValue(val);
                break;
            }
            case DOUBLE: {
                ((double[])channelData)[x + y * this.sizeX] = val;
                break;
            }
            default: {
                throw new RuntimeException("Unsupported data type");
            }
        }
        this.planeChanged.set(true);
    }

    private synchronized Object getChannelData(int c) throws IndexOutOfBoundsException, RuntimeException {
        if (this.currentChannel != c) {
            switch (this.planeType) {
                case UBYTE: 
                case BYTE: {
                    this.currentChannelData = ((byte[][])this.planeData)[c];
                    break;
                }
                case USHORT: 
                case SHORT: {
                    this.currentChannelData = ((short[][])this.planeData)[c];
                    break;
                }
                case UINT: 
                case INT: {
                    this.currentChannelData = ((int[][])this.planeData)[c];
                    break;
                }
                case FLOAT: {
                    this.currentChannelData = ((float[][])this.planeData)[c];
                    break;
                }
                case DOUBLE: {
                    this.currentChannelData = ((double[][])this.planeData)[c];
                    break;
                }
                default: {
                    throw new RuntimeException("Unsupported data type: " + (Object)((Object)this.planeType));
                }
            }
            this.currentChannel = c;
        }
        return this.currentChannelData;
    }

    private double getSafeValue(double val) {
        return Math.max(Math.min(val, this.planeType.getMaxValue()), this.planeType.getMinValue());
    }

    public synchronized void commitChanges() {
        this.plane.releaseRaster(this.planeChanged.get());
        if (this.planeChanged.get()) {
            this.plane.dataChanged();
            this.planeChanged.set(false);
        }
    }

    public String toString() {
        return "last channel=" + this.currentChannel;
    }
}

