/*
 * Decompiled with CFR 0.152.
 */
package icy.image;

import icy.image.IcyBufferedImage;
import icy.roi.BooleanMask2D;
import icy.roi.ROI;
import icy.type.DataIterator;
import icy.type.DataType;
import icy.type.collection.array.Array1DUtil;
import java.awt.Rectangle;
import java.util.NoSuchElementException;

public class ImageDataIterator
implements DataIterator {
    protected final IcyBufferedImage image;
    protected final DataType dataType;
    protected final BooleanMask2D mask;
    protected final Rectangle regionBounds;
    protected final Rectangle imageBounds;
    protected final Rectangle finalBounds;
    protected final int c;
    protected final int w;
    protected final int h;
    protected int x;
    protected int y;
    protected int imgOff;
    protected int maskOff;
    protected boolean changed;
    protected boolean done;
    protected Object data;

    protected ImageDataIterator(IcyBufferedImage image, Rectangle boundsXY, BooleanMask2D maskXY, int channel) {
        this.regionBounds = maskXY != null ? maskXY.bounds : boundsXY;
        this.image = image;
        this.mask = maskXY;
        if (image != null) {
            this.imageBounds = image.getBounds();
            this.dataType = image.getDataType_();
            this.c = channel;
            image.lockRaster();
        } else {
            this.imageBounds = new Rectangle();
            this.dataType = DataType.UBYTE;
            this.c = 0;
        }
        this.finalBounds = this.regionBounds.intersection(this.imageBounds);
        this.w = this.finalBounds.width;
        this.h = this.finalBounds.height;
        this.changed = false;
        this.reset();
    }

    public ImageDataIterator(IcyBufferedImage image, Rectangle boundsXY, int channel) {
        this(image, boundsXY, null, channel);
    }

    @Deprecated
    public ImageDataIterator(IcyBufferedImage image, int startX, int endX, int startY, int endY, int startC, int endC) {
        this(image, new Rectangle(startX, startY, endX - startX + 1, endY - startY + 1), startC);
    }

    @Deprecated
    public ImageDataIterator(IcyBufferedImage image, int startX, int endX, int startY, int endY, int c) {
        this(image, new Rectangle(startX, startY, endX - startX + 1, endY - startY + 1), c);
    }

    public ImageDataIterator(IcyBufferedImage image, int c) {
        this(image, image.getBounds(), c);
    }

    @Deprecated
    public ImageDataIterator(IcyBufferedImage image) {
        this(image, image.getBounds(), 0);
    }

    public ImageDataIterator(IcyBufferedImage image, BooleanMask2D maskXY, int channel) {
        this(image, null, maskXY, channel);
    }

    @Deprecated
    public ImageDataIterator(IcyBufferedImage image, BooleanMask2D maskXY) {
        this(image, maskXY, 0);
    }

    @Deprecated
    public ImageDataIterator(IcyBufferedImage image, ROI roi) throws InterruptedException {
        this(image, roi.getBooleanMask2D(0, 0, 0, false));
    }

    protected void finalize() throws Throwable {
        this.flush();
        super.finalize();
    }

    public int getMinX() {
        return this.finalBounds.x;
    }

    public int getMaxX() {
        return this.finalBounds.x + this.w - 1;
    }

    public int getMinY() {
        return this.finalBounds.y;
    }

    public int getMaxY() {
        return this.finalBounds.y + this.h - 1;
    }

    @Override
    public void reset() {
        boolean bl = this.done = this.image == null || this.c < 0 || this.c >= this.image.getSizeC() || this.finalBounds.isEmpty();
        if (!this.done) {
            this.data = this.image.getDataXY(this.c);
            this.y = 0;
            this.x = -1;
            this.imgOff = this.finalBounds.x - this.imageBounds.x + (this.finalBounds.y - this.imageBounds.y) * this.imageBounds.width;
            --this.imgOff;
            if (this.mask != null) {
                this.maskOff = this.finalBounds.x - this.regionBounds.x + (this.finalBounds.y - this.regionBounds.y) * this.regionBounds.width;
                --this.maskOff;
            }
            this.next();
        }
    }

    @Override
    public void next() {
        this.nextPosition();
        if (this.mask != null) {
            while (!this.done && !this.mask.mask[this.maskOff]) {
                this.nextPosition();
            }
        }
    }

    protected void nextPosition() {
        if (this.mask != null) {
            ++this.imgOff;
            ++this.maskOff;
            if (++this.x >= this.w) {
                this.x = 0;
                this.imgOff += this.imageBounds.width - this.finalBounds.width;
                this.maskOff += this.regionBounds.width - this.finalBounds.width;
                if (++this.y >= this.h) {
                    this.done = true;
                }
            }
        } else {
            ++this.imgOff;
            if (++this.x >= this.w) {
                this.x = 0;
                this.imgOff += this.imageBounds.width - this.finalBounds.width;
                if (++this.y >= this.h) {
                    this.done = true;
                }
            }
        }
    }

    @Override
    public boolean done() {
        return this.done;
    }

    @Override
    public double get() {
        if (this.done) {
            throw new NoSuchElementException("ImageDataIterator.get() error: no more element !");
        }
        return Array1DUtil.getValue(this.data, this.imgOff, this.dataType);
    }

    @Override
    public void set(double value) {
        if (this.done) {
            throw new NoSuchElementException("ImageDataIterator.get() error: no more element !");
        }
        Array1DUtil.setValue(this.data, this.imgOff, this.dataType, value);
        this.changed = true;
    }

    public int getX() {
        return this.finalBounds.x + this.x;
    }

    public int getY() {
        return this.finalBounds.y + this.y;
    }

    public int getC() {
        return this.c;
    }

    @Deprecated
    public int getPositionX() {
        return this.getX();
    }

    @Deprecated
    public int getPositionY() {
        return this.getY();
    }

    @Deprecated
    public int getPositionC() {
        return this.getC();
    }

    public void flush() {
        if (this.image != null) {
            this.image.releaseRaster(this.changed);
        }
        this.changed = false;
    }
}

