/*
 * Decompiled with CFR 0.152.
 */
package icy.imagej;

import icy.common.listener.ProgressListener;
import icy.image.IcyBufferedImage;
import icy.math.ArrayMath;
import icy.roi.ROI;
import icy.roi.ROI2D;
import icy.sequence.Sequence;
import icy.system.thread.ThreadUtil;
import icy.type.DataType;
import icy.type.collection.array.Array1DUtil;
import icy.type.collection.array.Array2DUtil;
import icy.type.collection.array.ArrayUtil;
import icy.type.geom.areax.AreaX;
import ij.CompositeImage;
import ij.ImagePlus;
import ij.ImageStack;
import ij.LookUpTable;
import ij.gui.Line;
import ij.gui.OvalRoi;
import ij.gui.PointRoi;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.gui.ShapeRoi;
import ij.measure.Calibration;
import ij.plugin.frame.RoiManager;
import ij.process.FloatPolygon;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import plugins.kernel.roi.roi2d.ROI2DArea;
import plugins.kernel.roi.roi2d.ROI2DEllipse;
import plugins.kernel.roi.roi2d.ROI2DLine;
import plugins.kernel.roi.roi2d.ROI2DPath;
import plugins.kernel.roi.roi2d.ROI2DPoint;
import plugins.kernel.roi.roi2d.ROI2DPolyLine;
import plugins.kernel.roi.roi2d.ROI2DPolygon;
import plugins.kernel.roi.roi2d.ROI2DRectangle;
import plugins.kernel.roi.roi2d.ROI2DShape;

public class ImageJUtil {
    private static Object convertToIJType(Object array, boolean signed) {
        if (array instanceof double[]) {
            return Array1DUtil.arrayToFloatArray(array, signed);
        }
        if (array instanceof long[]) {
            return Array1DUtil.arrayToShortArray(array, signed);
        }
        if (array instanceof int[]) {
            return Array1DUtil.arrayToShortArray(array, signed);
        }
        return Array1DUtil.copyOf(array);
    }

    private static ImageStack appendToStack(IcyBufferedImage img, ImageStack stack) {
        ImageStack result = stack == null ? new ImageStack(img.getSizeX(), img.getSizeY(), LookUpTable.createGrayscaleColorModel((boolean)false)) : stack;
        for (int c = 0; c < img.getSizeC(); ++c) {
            result.addSlice(null, ImageJUtil.convertToIJType(img.getDataXY(c), img.isSignedDataType()));
        }
        return result;
    }

    private static ImagePlus createImagePlus(Sequence sequence, ProgressListener progressListener) {
        int sizeZ = sequence.getSizeZ();
        int sizeT = sequence.getSizeT();
        int len = sizeZ * sizeT;
        int position = 0;
        ImageStack stack = null;
        for (int t = 0; t < sizeT; ++t) {
            for (int z = 0; z < sizeZ; ++z) {
                if (Thread.currentThread().isInterrupted()) {
                    return new ImagePlus(sequence.getName(), stack);
                }
                if (progressListener != null) {
                    progressListener.notifyProgress(position, len);
                }
                stack = ImageJUtil.appendToStack(sequence.getImage(t, z), stack);
                ++position;
            }
        }
        return new ImagePlus(sequence.getName(), stack);
    }

    private static void calibrateIcySequence(Sequence sequence, Calibration cal) {
        if (cal != null) {
            if (cal.scaled()) {
                sequence.setPixelSizeX(cal.pixelWidth);
                sequence.setPixelSizeY(cal.pixelHeight);
                sequence.setPixelSizeZ(cal.pixelDepth);
            }
            sequence.setTimeInterval(cal.frameInterval);
        }
    }

    private static void calibrateImageJImage(ImagePlus image, Sequence seq) {
        double ti;
        Calibration cal = image.getCalibration();
        double psx = seq.getPixelSizeX();
        double psy = seq.getPixelSizeY();
        double psz = seq.getPixelSizeZ();
        if (psx != 1.0 || psy != 1.0 || psz != 1.0) {
            cal.pixelWidth = psx;
            cal.pixelHeight = psy;
            cal.pixelDepth = psz;
            cal.setUnit("\u00b5m");
        }
        if ((ti = seq.getTimeInterval()) != 0.1) {
            cal.frameInterval = ti;
            cal.setTimeUnit("sec");
        }
        image.setDimensions(seq.getSizeC(), seq.getSizeZ(), seq.getSizeT());
        image.setOpenAsHyperStack(image.getNDimensions() > 3);
    }

    public static IcyBufferedImage convertToIcyBufferedImage(ImagePlus image, int z, int t, int sizeX, int sizeY, int sizeC, int type, boolean signed16) {
        image.setPosition(1, z + 1, t + 1);
        if (sizeC == 1 && (type == 3 || type == 4)) {
            return IcyBufferedImage.createFrom(image.getBufferedImage());
        }
        ImageProcessor ip = image.getProcessor();
        Object data = Array1DUtil.copyOf(ip.getPixels());
        DataType dataType = ArrayUtil.getDataType(data);
        Object[] datas = Array2DUtil.createArray(dataType, sizeC);
        datas[0] = data;
        if (signed16) {
            datas[0] = ArrayMath.subtract(datas[0], (Number)32768.0);
        }
        for (int c = 1; c < sizeC; ++c) {
            image.setPosition(c + 1, z + 1, t + 1);
            datas[c] = Array1DUtil.copyOf(image.getProcessor().getPixels());
            if (!signed16) continue;
            datas[c] = ArrayMath.subtract((Object)datas, (Number)32768.0);
        }
        return new IcyBufferedImage(sizeX, sizeY, datas, signed16);
    }

    public static IcyBufferedImage convertToIcyBufferedImage(ImagePlus image, int z, int t) {
        int[] dim = image.getDimensions(true);
        return ImageJUtil.convertToIcyBufferedImage(image, z, t, dim[0], dim[1], dim[2], image.getType(), image.getLocalCalibration().isSigned16Bit());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static Sequence convertToIcySequence(ImagePlus image, ProgressListener progressListener) throws InterruptedException {
        Sequence result = new Sequence(image.getTitle());
        int[] dim = image.getDimensions(true);
        int sizeX = dim[0];
        int sizeY = dim[1];
        int sizeC = dim[2];
        int sizeZ = dim[3];
        int sizeT = dim[4];
        int type = image.getType();
        boolean signed16 = image.getLocalCalibration().isSigned16Bit();
        int len = sizeZ * sizeT;
        int position = 0;
        result.beginUpdate();
        try {
            for (int t = 0; t < sizeT; ++t) {
                for (int z = 0; z < sizeZ; ++z) {
                    if (Thread.currentThread().isInterrupted()) {
                        Sequence sequence = result;
                        return sequence;
                    }
                    if (progressListener != null) {
                        progressListener.notifyProgress(position, len);
                    }
                    result.setImage(t, z, (BufferedImage)ImageJUtil.convertToIcyBufferedImage(image, z, t, sizeX, sizeY, sizeC, type, signed16));
                    ++position;
                }
            }
            RoiManager roiManager = RoiManager.getInstance();
            Roi[] rois = roiManager != null ? roiManager.getRoisAsArray() : new Roi[]{};
            if (rois.length > 0) {
                void var17_23;
                Roi[] roiArray = rois;
                int n = roiArray.length;
                boolean bl = false;
                while (var17_23 < n) {
                    Roi ijRoi = roiArray[var17_23];
                    if (ijRoi != null) {
                        for (ROI rOI : ImageJUtil.convertToIcyRoi(ijRoi)) {
                            result.addROI(rOI);
                        }
                    }
                    ++var17_23;
                }
            } else {
                Roi roi = image.getRoi();
                if (roi != null) {
                    for (ROI rOI : ImageJUtil.convertToIcyRoi(roi)) {
                        result.addROI(rOI);
                    }
                }
            }
            ImageJUtil.calibrateIcySequence(result, image.getCalibration());
        }
        finally {
            result.endUpdate();
        }
        return result;
    }

    public static ImagePlus convertToImageJImage(Sequence sequence, boolean useRoiManager, ProgressListener progressListener) throws InterruptedException {
        ImagePlus result = ImageJUtil.createImagePlus(sequence, progressListener);
        ImageJUtil.calibrateImageJImage(result, sequence);
        ArrayList<Roi> ijRois = new ArrayList<Roi>();
        for (ROI2D roi : sequence.getROI2Ds()) {
            ijRois.add(ImageJUtil.convertToImageJRoi(roi));
        }
        if (ijRois.size() > 0) {
            if (ijRois.size() > 1 && useRoiManager) {
                RoiManager roiManager = RoiManager.getInstance();
                if (roiManager == null) {
                    ThreadUtil.invokeNow(new Runnable(){

                        @Override
                        public void run() {
                            new RoiManager();
                        }
                    });
                }
                roiManager = RoiManager.getInstance();
                int n = 0;
                for (Roi roi : ijRois) {
                    roiManager.add(result, roi, n++);
                }
            }
            result.setRoi((Roi)ijRois.get(0));
        }
        if (result.getNChannels() > 4) {
            return new CompositeImage(result, 2);
        }
        if (result.getNChannels() > 1) {
            return new CompositeImage(result, 1);
        }
        return result;
    }

    public static ImagePlus convertToImageJImage(Sequence sequence, ProgressListener progressListener) throws InterruptedException {
        return ImageJUtil.convertToImageJImage(sequence, false, progressListener);
    }

    public static List<ROI2D> convertToIcyRoi(Roi roi) throws InterruptedException {
        ArrayList<ROI2D> result = new ArrayList<ROI2D>();
        ArrayList<Point2D> pts = new ArrayList<Point2D>();
        switch (roi.getType()) {
            default: {
                result.add(new ROI2DRectangle(roi.getFloatBounds()));
                break;
            }
            case 1: {
                result.add(new ROI2DEllipse(roi.getFloatBounds()));
                break;
            }
            case 5: {
                Rectangle2D.Double rect = roi.getFloatBounds();
                double x = ((RectangularShape)rect).getX();
                double y = ((RectangularShape)rect).getY();
                result.add(new ROI2DLine((Point2D)new Point2D.Double(x, y), new Point2D.Double(x + ((RectangularShape)rect).getWidth(), y + ((RectangularShape)rect).getHeight())));
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                FloatPolygon fp = ((PolygonRoi)roi).getFloatPolygon();
                for (int p = 0; p < fp.npoints; ++p) {
                    pts.add(new Point2D.Float(fp.xpoints[p], fp.ypoints[p]));
                }
                ROI2DPolygon roiPolygon = new ROI2DPolygon();
                roiPolygon.setPoints((List<Point2D>)pts);
                if (roi.getType() == 4) {
                    result.add(new ROI2DArea(roiPolygon.getBooleanMask(true)));
                    break;
                }
                result.add(roiPolygon);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                FloatPolygon fp = ((PolygonRoi)roi).getFloatPolygon();
                for (int p = 0; p < fp.npoints; ++p) {
                    pts.add(new Point2D.Float(fp.xpoints[p], fp.ypoints[p]));
                }
                ROI2DPolyLine roiPolyline = new ROI2DPolyLine();
                roiPolyline.setPoints((List<Point2D>)pts);
                result.add(roiPolyline);
                break;
            }
            case 9: {
                ROI2DPath roiPath = new ROI2DPath(((ShapeRoi)roi).getShape());
                Rectangle2D.Double roiBounds = roi.getFloatBounds();
                if (roiPath.canSetPosition()) {
                    roiPath.setPosition2D(new Point2D.Double(roiBounds.x, roiBounds.y));
                }
                result.add(roiPath);
                break;
            }
            case 10: {
                FloatPolygon fp = ((PolygonRoi)roi).getFloatPolygon();
                for (int p = 0; p < fp.npoints; ++p) {
                    pts.add(new Point2D.Float(fp.xpoints[p], fp.ypoints[p]));
                }
                for (Point2D pt : pts) {
                    result.add(new ROI2DPoint(pt));
                }
            }
        }
        int ind = 0;
        for (ROI2D r : result) {
            r.setC(roi.getCPosition() - 1);
            r.setZ(roi.getZPosition() - 1);
            r.setT(roi.getTPosition() - 1);
            r.setSelected(false);
            if (result.size() > 1) {
                r.setName(roi.getName() + " " + ind);
            } else {
                r.setName(roi.getName());
            }
            Color c = roi.getStrokeColor();
            if (c == null) {
                c = roi.getFillColor();
            }
            if (c == null) continue;
            r.setColor(c);
        }
        return result;
    }

    public static Roi convertToImageJRoi(ROI2D roi) throws InterruptedException {
        Roi result;
        if (roi instanceof ROI2DShape) {
            ArrayList<Point2D> pts = ((ROI2DShape)roi).getPoints();
            if (roi instanceof ROI2DPoint) {
                Point2D p = (Point2D)pts.get(0);
                result = new PointRoi(p.getX(), p.getY());
            } else if (roi instanceof ROI2DLine) {
                Point2D p1 = (Point2D)pts.get(0);
                Point2D p2 = (Point2D)pts.get(1);
                result = new Line(p1.getX(), p1.getY(), p2.getX(), p2.getY());
            } else if (roi instanceof ROI2DRectangle) {
                Rectangle2D r = roi.getBounds2D();
                result = new Roi(r.getX(), r.getY(), r.getWidth(), r.getHeight(), 0);
            } else if (roi instanceof ROI2DEllipse) {
                Rectangle2D r = roi.getBounds2D();
                result = new OvalRoi(r.getX(), r.getY(), r.getWidth(), r.getHeight());
            } else if (roi instanceof ROI2DPolyLine || roi instanceof ROI2DPolygon) {
                FloatPolygon fp = new FloatPolygon();
                for (Point2D p : pts) {
                    fp.addPoint(p.getX(), p.getY());
                }
                result = roi instanceof ROI2DPolyLine ? new PolygonRoi(fp, 6) : new PolygonRoi(fp, 2);
            } else {
                result = new ShapeRoi(((ROI2DPath)roi).getShape());
            }
        } else if (roi instanceof ROI2DArea) {
            ROI2DArea roiArea = (ROI2DArea)roi;
            Point[] points = roiArea.getBooleanMask(true).getPoints();
            AreaX area = new AreaX();
            for (Point pt : points) {
                area.add(new AreaX(new Rectangle(pt.x, pt.y, 1, 1)));
            }
            result = new ShapeRoi((Shape)area);
        } else {
            Rectangle2D r = roi.getBounds2D();
            result = new Roi(r.getX(), r.getY(), r.getWidth(), r.getHeight());
        }
        result.setPosition(roi.getC() + 1, roi.getZ() + 1, roi.getT() + 1);
        result.setName(roi.getName());
        result.setStrokeColor(roi.getColor());
        return result;
    }

    @Deprecated
    public static PointRoi convertToImageJRoiPoint(List<ROI2DPoint> points) {
        int size = points.size();
        float[] x = new float[size];
        float[] y = new float[size];
        for (int i = 0; i < points.size(); ++i) {
            ROI2DPoint point = points.get(i);
            x[i] = (float)point.getPoint().getX();
            y[i] = (float)point.getPoint().getY();
        }
        return new PointRoi(x, y, size);
    }
}

