/*
 * Decompiled with CFR 0.152.
 */
package icy.painter;

import icy.painter.Anchor2D;
import icy.util.EventUtil;
import java.awt.Color;
import java.awt.event.InputEvent;
import java.awt.geom.Point2D;

public abstract class LineAnchor2D
extends Anchor2D {
    public LineAnchor2D(Point2D position, Color color, Color selectedColor) {
        super(position.getX(), position.getY(), color, selectedColor);
    }

    @Override
    protected boolean updateDrag(InputEvent e, double x, double y) {
        if (this.startDragMousePosition == null) {
            return false;
        }
        Anchor2D anchor = this.getPreviousPoint();
        if (EventUtil.isShiftDown(e) && anchor != null) {
            Point2D pos = anchor.getPosition();
            double dx = x - pos.getX();
            double dy = y - pos.getY();
            double absDx = Math.abs(dx);
            double absDy = Math.abs(dy);
            double dist = absDx != 0.0 && absDy != 0.0 ? absDx / absDy : 0.0;
            if (dist > 0.5 && dist < 1.5) {
                if (absDx > absDy) {
                    dx = dx >= 0.0 ? absDy : -absDy;
                } else {
                    dy = dy >= 0.0 ? absDx : -absDx;
                }
            } else if (absDx > absDy) {
                dy = 0.0;
            } else {
                dx = 0.0;
            }
            this.setPosition(pos.getX() + dx, pos.getY() + dy);
        } else {
            double dx = x - this.startDragMousePosition.getX();
            double dy = y - this.startDragMousePosition.getY();
            this.setPosition(this.startDragPainterPosition.getX() + dx, this.startDragPainterPosition.getY() + dy);
        }
        return true;
    }

    protected abstract Anchor2D getPreviousPoint();
}

