/*
 * Decompiled with CFR 0.152.
 */
package icy.plugin;

import icy.common.Version;
import icy.file.FileUtil;
import icy.file.xml.XMLPersistent;
import icy.file.xml.XMLPersistentHelper;
import icy.image.ImageUtil;
import icy.network.NetworkUtil;
import icy.network.URLUtil;
import icy.plugin.PluginLauncher;
import icy.plugin.PluginLoader;
import icy.plugin.abstract_.Plugin;
import icy.plugin.interface_.PluginBundled;
import icy.plugin.interface_.PluginImageAnalysis;
import icy.preferences.RepositoryPreferences;
import icy.resource.ResourceUtil;
import icy.util.ClassUtil;
import icy.util.StringUtil;
import icy.util.XMLUtil;
import java.awt.Image;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.swing.ImageIcon;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PluginDescriptor
implements XMLPersistent {
    public static final int ICON_SIZE = 64;
    public static final int IMAGE_SIZE = 256;
    public static final ImageIcon DEFAULT_ICON = ResourceUtil.getImageIcon(ResourceUtil.IMAGE_PLUGIN_SMALL);
    public static final Image DEFAULT_IMAGE = ResourceUtil.IMAGE_PLUGIN;
    @Deprecated
    public static final String ID_CLASSNAME = "classname";
    @Deprecated
    public static final String ID_REQUIRED_KERNEL_VERSION = "required_kernel_version";
    public static final String ID_URL = "url";
    public static final String ID_NAME = "name";
    public static final String ID_JAR_URL = "jar_url";
    public static final String ID_IMAGE_URL = "image_url";
    public static final String ID_ICON_URL = "icon_url";
    public static final String ID_AUTHOR = "author";
    public static final String ID_CHANGELOG = "changelog";
    public static final String ID_WEB = "web";
    public static final String ID_EMAIL = "email";
    public static final String ID_DESCRIPTION = "description";
    public static final String ID_DEPENDENCIES = "dependencies";
    public static final String ID_DEPENDENCY = "dependency";
    protected Class<? extends Plugin> pluginClass = null;
    protected ImageIcon icon = DEFAULT_ICON;
    protected Image image = DEFAULT_IMAGE;
    protected String name = "";
    protected PluginIdent ident = new PluginIdent();
    protected String localXmlUrl = "";
    protected String xmlUrl = "";
    protected String jarUrl = "";
    protected String imageUrl = "";
    protected String iconUrl = "";
    protected String author = "";
    protected String web = "";
    protected String email = "";
    protected String desc = "";
    protected String changeLog = "";
    protected boolean enabled = true;
    protected boolean descriptorLoaded = true;
    protected boolean iconLoaded = true;
    protected boolean imageLoaded = true;
    protected boolean changeLogLoaded = true;
    protected final List<PluginIdent> required = new ArrayList<PluginIdent>();
    protected RepositoryPreferences.RepositoryInfo repository = null;

    public static int getIndex(List<PluginDescriptor> list, PluginDescriptor plugin) {
        return PluginDescriptor.getIndex(list, plugin.getIdent());
    }

    public static int getIndex(List<PluginDescriptor> list, PluginIdent ident) {
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            if (!list.get(i).getIdent().equals(ident)) continue;
            return i;
        }
        return -1;
    }

    public static int getIndex(List<PluginDescriptor> list, String className) {
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            if (!list.get(i).getClassName().equals(className)) continue;
            return i;
        }
        return -1;
    }

    public static boolean existInList(List<PluginDescriptor> list, PluginDescriptor plugin) {
        return PluginDescriptor.existInList(list, plugin.getIdent());
    }

    public static boolean existInList(List<PluginDescriptor> list, PluginIdent ident) {
        return PluginDescriptor.getIndex(list, ident) != -1;
    }

    public static boolean existInList(List<PluginDescriptor> list, String className) {
        return PluginDescriptor.getIndex(list, className) != -1;
    }

    public static boolean existInList(Set<PluginDescriptor> plugins, PluginIdent ident) {
        for (PluginDescriptor plugin : plugins) {
            if (!plugin.getIdent().equals(ident)) continue;
            return true;
        }
        return false;
    }

    public static void addToList(List<PluginDescriptor> list, PluginDescriptor plugin, int position) {
        if (plugin != null && !PluginDescriptor.existInList(list, plugin)) {
            list.add(position, plugin);
        }
    }

    public static void addToList(List<PluginDescriptor> list, PluginDescriptor plugin) {
        if (plugin != null && !PluginDescriptor.existInList(list, plugin)) {
            list.add(plugin);
        }
    }

    public static boolean removeFromList(List<PluginDescriptor> list, String className) {
        for (int i = list.size() - 1; i >= 0; --i) {
            PluginDescriptor p = list.get(i);
            if (!p.getClassName().equals(className)) continue;
            list.remove(i);
            return true;
        }
        return false;
    }

    public static ArrayList<PluginDescriptor> getPlugins(List<PluginDescriptor> list, String className) {
        ArrayList<PluginDescriptor> result = new ArrayList<PluginDescriptor>();
        for (PluginDescriptor plugin : list) {
            if (!plugin.getClassName().equals(className)) continue;
            result.add(plugin);
        }
        return result;
    }

    public static PluginDescriptor getPlugin(List<PluginDescriptor> list, String className) {
        for (PluginDescriptor plugin : list) {
            if (!plugin.getClassName().equals(className)) continue;
            return plugin;
        }
        return null;
    }

    public static PluginDescriptor getPlugin(List<PluginDescriptor> list, PluginIdent ident, boolean acceptNewer) {
        if (acceptNewer) {
            for (PluginDescriptor plugin : list) {
                if (!plugin.getIdent().isNewerOrEqual(ident)) continue;
                return plugin;
            }
        } else {
            for (PluginDescriptor plugin : list) {
                if (!plugin.getIdent().equals(ident)) continue;
                return plugin;
            }
        }
        return null;
    }

    public PluginDescriptor() {
    }

    public PluginDescriptor(Class<? extends Plugin> clazz) {
        this();
        URL xmlUrl;
        URL imageUrl;
        String baseLocalName;
        String baseResourceName;
        this.pluginClass = clazz;
        boolean bundled = this.isBundled();
        if (bundled) {
            String jarPath = this.getPluginJarPath();
            baseResourceName = FileUtil.getFileName(jarPath, false);
            baseLocalName = FileUtil.setExtension(jarPath, "");
        } else {
            baseResourceName = clazz.getSimpleName();
            baseLocalName = ClassUtil.getPathFromQualifiedName(clazz.getName());
        }
        URL iconUrl = clazz.getResource(baseResourceName + this.getIconExtension());
        if (iconUrl == null) {
            iconUrl = URLUtil.getURL(baseLocalName + this.getIconExtension());
        }
        if ((imageUrl = clazz.getResource(baseResourceName + this.getImageExtension())) == null) {
            imageUrl = URLUtil.getURL(baseLocalName + this.getImageExtension());
        }
        if ((xmlUrl = clazz.getResource(baseResourceName + this.getXMLExtension())) == null) {
            xmlUrl = URLUtil.getURL(baseLocalName + this.getXMLExtension());
        }
        if (!this.loadFromXML(xmlUrl) || bundled) {
            this.name = this.pluginClass.getSimpleName();
            this.desc = bundled ? this.name + " plugin (Bundled)" + (!StringUtil.isEmpty(this.desc) ? "\n" + this.desc : "") : this.name + " plugin";
        }
        this.ident.setClassName(this.pluginClass.getName());
        this.iconUrl = iconUrl.toString();
        this.imageUrl = imageUrl.toString();
        this.localXmlUrl = xmlUrl.toString();
        this.descriptorLoaded = true;
        this.changeLogLoaded = false;
        this.iconLoaded = false;
        this.imageLoaded = false;
    }

    public PluginDescriptor(PluginOnlineIdent ident, RepositoryPreferences.RepositoryInfo repos) throws IllegalArgumentException {
        this();
        this.ident.setClassName(ident.getClassName());
        this.ident.setVersion(ident.getVersion());
        this.ident.setRequiredKernelVersion(ident.getRequiredKernelVersion());
        this.xmlUrl = ident.getUrl();
        this.name = ident.getName();
        this.repository = repos;
        this.descriptorLoaded = false;
        this.changeLogLoaded = false;
        this.iconLoaded = false;
        this.imageLoaded = false;
    }

    @Deprecated
    public boolean load(boolean loadImages) {
        if (this.loadDescriptor()) {
            this.loadChangeLog();
            if (loadImages) {
                return this.loadImages();
            }
        }
        return false;
    }

    public boolean loadDescriptor() {
        return this.loadDescriptor(false);
    }

    public boolean loadDescriptor(boolean reload) {
        if (this.descriptorLoaded && !reload) {
            return true;
        }
        this.descriptorLoaded = true;
        Document document = XMLUtil.loadDocument(this.xmlUrl, this.repository != null ? this.repository.getAuthenticationInfo() : null, true);
        if (document != null) {
            if (!this.loadFromXML(document.getDocumentElement())) {
                System.err.println("Can't find valid XML file from '" + this.xmlUrl + "' for plugin class '" + this.ident.getClassName() + "'");
                return false;
            }
            return true;
        }
        if (!reload) {
            System.err.println("Can't load XML file from '" + this.xmlUrl + "' for plugin class '" + this.ident.getClassName() + "'");
        }
        return false;
    }

    public boolean loadChangeLog() {
        if (this.changeLogLoaded) {
            return true;
        }
        this.changeLogLoaded = true;
        Document document = XMLUtil.loadDocument(this.xmlUrl, this.repository != null ? this.repository.getAuthenticationInfo() : null, true);
        if (document != null) {
            Element node = document.getDocumentElement();
            if (node != null) {
                this.setChangeLog(XMLUtil.getElementValue(node, ID_CHANGELOG, ""));
                return true;
            }
            System.err.println("Can't find valid XML file from '" + this.xmlUrl + "' for plugin class '" + this.ident.getClassName() + "'");
        }
        System.err.println("Can't load XML file from '" + this.xmlUrl + "' for plugin class '" + this.ident.getClassName() + "'");
        return false;
    }

    public boolean loadIcon() {
        if (this.iconLoaded) {
            return true;
        }
        this.loadDescriptor();
        this.iconLoaded = true;
        return this.loadIcon(URLUtil.getURL(this.iconUrl));
    }

    public boolean loadImage() {
        if (this.imageLoaded) {
            return true;
        }
        this.loadDescriptor();
        this.imageLoaded = true;
        return this.loadImage(URLUtil.getURL(this.imageUrl));
    }

    public boolean loadImages() {
        return this.loadIcon() & this.loadImage();
    }

    public boolean loadAll() {
        return this.loadDescriptor() & this.loadChangeLog() & this.loadImages();
    }

    public boolean isInstanceOf(Class<?> baseClazz) {
        return ClassUtil.isSubClass(this.pluginClass, baseClazz);
    }

    public boolean isAbstract() {
        return ClassUtil.isAbstract(this.pluginClass);
    }

    public boolean isPrivate() {
        return ClassUtil.isPrivate(this.pluginClass);
    }

    public boolean isInterface() {
        return this.pluginClass.isInterface();
    }

    public boolean isActionable() {
        return this.isClassLoaded() && !this.isPrivate() && !this.isAbstract() && !this.isInterface() && this.isInstanceOf(PluginImageAnalysis.class);
    }

    public boolean isBundled() {
        return this.isClassLoaded() && this.isInstanceOf(PluginBundled.class);
    }

    public boolean isBeta() {
        return this.getVersion().isBeta();
    }

    public boolean isKernelPlugin() {
        return this.getClassName().startsWith("plugins.kernel.");
    }

    boolean loadIcon(URL url) {
        if (url != null) {
            this.icon = ResourceUtil.getImageIcon(ImageUtil.load(NetworkUtil.getInputStream(url, this.repository != null ? this.repository.getAuthenticationInfo() : null, true, false), false), 64);
        }
        if (this.icon == null) {
            this.icon = DEFAULT_ICON;
            return false;
        }
        return true;
    }

    boolean loadImage(URL url) {
        if (url != null) {
            this.image = ImageUtil.scale(ImageUtil.load(NetworkUtil.getInputStream(url, this.repository != null ? this.repository.getAuthenticationInfo() : null, true, false), false), 256, 256);
        }
        if (this.image == null) {
            this.image = DEFAULT_IMAGE;
            return false;
        }
        return true;
    }

    public boolean loadFromXML(String path) {
        return XMLPersistentHelper.loadFromXML((XMLPersistent)this, path);
    }

    public boolean loadFromXML(URL xmlUrl) {
        return XMLPersistentHelper.loadFromXML((XMLPersistent)this, xmlUrl);
    }

    @Override
    public boolean loadFromXML(Node node) {
        return this.loadFromXML(node, false);
    }

    public boolean loadFromXML(Node node, boolean loadChangeLog) {
        if (node == null) {
            return false;
        }
        this.ident.loadFromXML(node);
        this.setName(XMLUtil.getElementValue(node, ID_NAME, ""));
        this.setXmlUrl(XMLUtil.getElementValue(node, ID_URL, ""));
        this.setJarUrl(XMLUtil.getElementValue(node, ID_JAR_URL, ""));
        this.setImageUrl(XMLUtil.getElementValue(node, ID_IMAGE_URL, ""));
        this.setIconUrl(XMLUtil.getElementValue(node, ID_ICON_URL, ""));
        this.setAuthor(XMLUtil.getElementValue(node, ID_AUTHOR, ""));
        this.setWeb(XMLUtil.getElementValue(node, ID_WEB, ""));
        this.setEmail(XMLUtil.getElementValue(node, ID_EMAIL, ""));
        this.setDescription(XMLUtil.getElementValue(node, ID_DESCRIPTION, ""));
        if (loadChangeLog) {
            this.setChangeLog(XMLUtil.getElementValue(node, ID_CHANGELOG, ""));
        } else {
            this.setChangeLog("");
        }
        Element nodeDependances = XMLUtil.getElement(node, ID_DEPENDENCIES);
        if (nodeDependances != null) {
            ArrayList<Node> nodesDependances = XMLUtil.getChildren(nodeDependances, ID_DEPENDENCY);
            for (Node n : nodesDependances) {
                PluginIdent ident = new PluginIdent();
                ident.loadFromXML(n);
                if (ident.isEmpty()) continue;
                this.required.add(ident);
            }
        }
        return true;
    }

    public boolean saveToXML() {
        return XMLPersistentHelper.saveToXML((XMLPersistent)this, this.getXMLFilename());
    }

    @Override
    public boolean saveToXML(Node node) {
        if (node == null) {
            return false;
        }
        this.ident.saveToXML(node);
        XMLUtil.setElementValue(node, ID_NAME, this.getName());
        XMLUtil.setElementValue(node, ID_URL, this.getXmlUrl());
        XMLUtil.setElementValue(node, ID_JAR_URL, this.getJarUrl());
        XMLUtil.setElementValue(node, ID_IMAGE_URL, this.getImageUrl());
        XMLUtil.setElementValue(node, ID_ICON_URL, this.getIconUrl());
        XMLUtil.setElementValue(node, ID_AUTHOR, this.getAuthor());
        XMLUtil.setElementValue(node, ID_WEB, this.getWeb());
        XMLUtil.setElementValue(node, ID_EMAIL, this.getEmail());
        XMLUtil.setElementValue(node, ID_DESCRIPTION, this.getDescription());
        this.loadChangeLog();
        XMLUtil.setElementValue(node, ID_CHANGELOG, this.getChangeLog());
        Element dependances = XMLUtil.setElement(node, ID_DEPENDENCIES);
        if (dependances != null) {
            XMLUtil.removeAllChildren(dependances);
            for (PluginIdent dep : this.required) {
                dep.saveToXML(XMLUtil.addElement(dependances, ID_DEPENDENCY));
            }
        }
        return true;
    }

    public boolean isClassLoaded() {
        return this.pluginClass != null;
    }

    public String getClassName() {
        return this.ident.getClassName();
    }

    public String getSimpleClassName() {
        return this.ident.getSimpleClassName();
    }

    public String getPackageName() {
        return this.ident.getPackageName();
    }

    public String getSimplePackageName() {
        return this.ident.getSimplePackageName();
    }

    public String getAuthorPackageName() {
        return this.ident.getAuthorPackageName();
    }

    @Deprecated
    public String getClassAsString() {
        if (this.pluginClass != null) {
            return this.pluginClass.toString();
        }
        return "";
    }

    public Class<? extends Plugin> getPluginClass() {
        return this.pluginClass;
    }

    public PluginDescriptor getMainPlugin() {
        if (!this.isBundled()) {
            return this;
        }
        try {
            return PluginLoader.getPlugin(((PluginBundled)((Object)PluginLauncher.create(this))).getMainPluginClassName());
        }
        catch (Throwable t) {
            ArrayList<PluginDescriptor> allPlugins = PluginLoader.getPlugins(false);
            String packageName = this.getPackageName();
            while (!StringUtil.isEmpty(packageName)) {
                PluginDescriptor matchingPlugin = null;
                for (PluginDescriptor p : allPlugins) {
                    if (!p.getClassName().startsWith(packageName)) continue;
                    if (matchingPlugin != null) {
                        matchingPlugin = this;
                        break;
                    }
                    matchingPlugin = p;
                }
                if (matchingPlugin == this) {
                    return null;
                }
                if (matchingPlugin != null) {
                    return matchingPlugin;
                }
                packageName = ClassUtil.getPackageName(packageName);
            }
            return null;
        }
    }

    public String getPluginJarPath() {
        if (this.pluginClass != null) {
            return ClassUtil.getJarPath(this.pluginClass);
        }
        return null;
    }

    public String getFilename() {
        return ClassUtil.getPathFromQualifiedName(this.getClassName());
    }

    public String getXMLExtension() {
        return ".xml";
    }

    public String getXMLFilename() {
        if (!StringUtil.isEmpty(this.localXmlUrl)) {
            return this.localXmlUrl;
        }
        return this.getFilename() + this.getXMLExtension();
    }

    public String getIconExtension() {
        return "_icon.png";
    }

    public String getIconFilename() {
        return this.getFilename() + this.getIconExtension();
    }

    public String getImageExtension() {
        return ".png";
    }

    public String getImageFilename() {
        return this.getFilename() + this.getImageExtension();
    }

    public String getJarExtension() {
        return ".jar";
    }

    public String getJarFilename() {
        return this.getFilename() + this.getJarExtension();
    }

    public ImageIcon getIcon() {
        this.loadIcon();
        return this.icon;
    }

    public Image getIconAsImage() {
        ImageIcon i = this.getIcon();
        if (i != null) {
            return i.getImage();
        }
        return null;
    }

    public Image getImage() {
        this.loadImage();
        return this.image;
    }

    public PluginIdent getIdent() {
        return this.ident;
    }

    public String getName() {
        return this.name;
    }

    public Version getVersion() {
        if (this.ident != null) {
            return this.ident.getVersion();
        }
        return new Version();
    }

    public String getUrl() {
        return this.getXmlUrl();
    }

    public String getXmlUrl() {
        return this.xmlUrl;
    }

    @Deprecated
    public String getDesc() {
        return this.getDescription();
    }

    public String getDescription() {
        return this.desc;
    }

    public void setXmlUrl(String xmlUrl) {
        this.xmlUrl = xmlUrl;
    }

    public void setRepository(RepositoryPreferences.RepositoryInfo repository) {
        this.repository = repository;
    }

    public String getJarUrl() {
        return this.jarUrl;
    }

    public void setJarUrl(String jarUrl) {
        this.jarUrl = jarUrl;
    }

    public String getImageUrl() {
        return this.imageUrl;
    }

    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    public String getIconUrl() {
        return this.iconUrl;
    }

    public void setIconUrl(String iconUrl) {
        this.iconUrl = iconUrl;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getWeb() {
        return this.web;
    }

    public String getEmail() {
        return this.email;
    }

    public String getChangeLog() {
        return this.changeLog;
    }

    @Deprecated
    public String getChangesLog() {
        return this.getChangeLog();
    }

    public Version getRequiredKernelVersion() {
        return this.ident.getRequiredKernelVersion();
    }

    public boolean isDescriptorLoaded() {
        return this.descriptorLoaded;
    }

    @Deprecated
    public boolean isLoaded() {
        return this.descriptorLoaded;
    }

    public boolean isChangeLogLoaded() {
        return this.changeLogLoaded;
    }

    public boolean isIconLoaded() {
        return this.iconLoaded;
    }

    public boolean isImageLoaded() {
        return this.imageLoaded;
    }

    public boolean isImagesLoaded() {
        return this.iconLoaded && this.imageLoaded;
    }

    public boolean isAllLoaded() {
        return this.descriptorLoaded && this.changeLogLoaded && this.iconLoaded && this.imageLoaded;
    }

    public List<PluginIdent> getRequired() {
        return new ArrayList<PluginIdent>(this.required);
    }

    public RepositoryPreferences.RepositoryInfo getRepository() {
        return this.repository;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isInstalled() {
        return FileUtil.exists(this.getJarFilename());
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public void setWeb(String web) {
        this.web = web;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setDescription(String desc) {
        this.desc = desc;
    }

    public void setChangeLog(String value) {
        this.changeLog = value;
    }

    @Deprecated
    public void setChangesLog(String value) {
        this.setChangeLog(value);
    }

    public boolean requires(PluginDescriptor plugin) {
        PluginIdent curIdent = plugin.getIdent();
        for (PluginIdent ident : this.required) {
            if (!ident.isOlderOrEqual(curIdent)) continue;
            return true;
        }
        return false;
    }

    public boolean isOlderOrEqual(PluginDescriptor plugin) {
        return this.ident.isOlderOrEqual(plugin.getIdent());
    }

    public boolean isOlder(PluginDescriptor plugin) {
        return this.ident.isOlder(plugin.getIdent());
    }

    public boolean isNewerOrEqual(PluginDescriptor plugin) {
        return this.ident.isNewerOrEqual(plugin.getIdent());
    }

    public boolean isNewer(PluginDescriptor plugin) {
        return this.ident.isNewer(plugin.getIdent());
    }

    public String toString() {
        return this.getName() + " " + this.getVersion().toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof PluginDescriptor) {
            PluginDescriptor plug = (PluginDescriptor)obj;
            return this.getClassName().equals(plug.getClassName()) && this.getVersion().equals(plug.getVersion());
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.getClassName().hashCode() ^ this.getVersion().hashCode();
    }

    public static class PluginIdent
    implements XMLPersistent {
        public static final String ID_CLASSNAME = "classname";
        public static final String ID_VERSION = "version";
        public static final String ID_REQUIRED_KERNEL_VERSION = "required_kernel_version";
        protected String className = "";
        protected Version version = new Version();
        protected Version requiredKernelVersion = new Version();

        public static int getIndex(List<PluginIdent> list, PluginIdent ident) {
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                if (!list.get(i).equals(ident)) continue;
                return i;
            }
            return -1;
        }

        public static int getIndex(List<? extends PluginIdent> list, String className) {
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                if (!list.get(i).getClassName().equals(className)) continue;
                return i;
            }
            return -1;
        }

        public boolean loadFromXMLShort(Node node) {
            if (node == null) {
                return false;
            }
            this.setClassName(XMLUtil.getElementValue(node, "classname", ""));
            this.setVersion(new Version(XMLUtil.getElementValue(node, ID_VERSION, "")));
            return true;
        }

        @Override
        public boolean loadFromXML(Node node) {
            if (!this.loadFromXMLShort(node)) {
                return false;
            }
            this.setRequiredKernelVersion(new Version(XMLUtil.getElementValue(node, "required_kernel_version", "")));
            return true;
        }

        public boolean saveToXMLShort(Node node) {
            if (node == null) {
                return false;
            }
            XMLUtil.setElementValue(node, "classname", this.getClassName());
            XMLUtil.setElementValue(node, ID_VERSION, this.getVersion().toString());
            return true;
        }

        @Override
        public boolean saveToXML(Node node) {
            if (!this.saveToXMLShort(node)) {
                return false;
            }
            XMLUtil.setElementValue(node, "required_kernel_version", this.getRequiredKernelVersion().toString());
            return true;
        }

        public boolean isEmpty() {
            return StringUtil.isEmpty(this.className) && this.version.isEmpty() && this.requiredKernelVersion.isEmpty();
        }

        public String getClassName() {
            return this.className;
        }

        public void setClassName(String className) {
            this.className = className;
        }

        public String getSimpleClassName() {
            return ClassUtil.getSimpleClassName(this.className);
        }

        public String getPackageName() {
            return ClassUtil.getPackageName(this.className);
        }

        public String getSimplePackageName() {
            String result = this.getPackageName();
            if (result.startsWith("icy.")) {
                result = result.substring(4);
            }
            if (result.startsWith("plugins")) {
                result = result.substring("plugins".length() + 1);
            }
            return result;
        }

        public String getAuthorPackageName() {
            String result = this.getSimplePackageName();
            int index = result.indexOf(46);
            if (index != -1) {
                return result.substring(0, index);
            }
            return result;
        }

        public void setVersion(Version version) {
            this.version = version;
        }

        public Version getVersion() {
            return this.version;
        }

        public Version getRequiredKernelVersion() {
            return this.requiredKernelVersion;
        }

        public void setRequiredKernelVersion(Version requiredKernelVersion) {
            this.requiredKernelVersion = requiredKernelVersion;
        }

        public boolean isOlderOrEqual(PluginIdent ident) {
            return this.className.equals(ident.getClassName()) && this.version.isOlderOrEqual(ident.getVersion());
        }

        public boolean isOlder(PluginIdent ident) {
            return this.className.equals(ident.getClassName()) && this.version.isOlder(ident.getVersion());
        }

        public boolean isNewerOrEqual(PluginIdent ident) {
            return this.className.equals(ident.getClassName()) && this.version.isNewerOrEqual(ident.getVersion());
        }

        public boolean isNewer(PluginIdent ident) {
            return this.className.equals(ident.getClassName()) && this.version.isNewer(ident.getVersion());
        }

        public boolean equals(Object obj) {
            if (obj instanceof PluginIdent) {
                PluginIdent ident = (PluginIdent)obj;
                return ident.getClassName().equals(this.className) && ident.getVersion().equals(this.getVersion());
            }
            return super.equals(obj);
        }

        public int hashCode() {
            return this.className.hashCode() ^ this.version.hashCode();
        }

        public String toString() {
            return this.className + " " + this.version.toString();
        }
    }

    public static class PluginOnlineIdent
    extends PluginIdent {
        protected String name = "";
        protected String url = "";

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        @Override
        public boolean loadFromXML(Node node) {
            if (super.loadFromXML(node)) {
                this.setName(XMLUtil.getElementValue(node, PluginDescriptor.ID_NAME, ""));
                this.setUrl(XMLUtil.getElementValue(node, PluginDescriptor.ID_URL, ""));
                return true;
            }
            return false;
        }

        @Override
        public boolean saveToXML(Node node) {
            if (super.saveToXML(node)) {
                XMLUtil.setElementValue(node, PluginDescriptor.ID_NAME, this.getName());
                XMLUtil.setElementValue(node, PluginDescriptor.ID_URL, this.getUrl());
                return true;
            }
            return false;
        }
    }

    public static class PluginClassNameSorter
    implements Comparator<PluginDescriptor> {
        public static PluginClassNameSorter instance = new PluginClassNameSorter();

        private PluginClassNameSorter() {
        }

        @Override
        public int compare(PluginDescriptor o1, PluginDescriptor o2) {
            return o1.getClassName().compareToIgnoreCase(o2.getClassName());
        }
    }

    public static class PluginNameSorter
    implements Comparator<PluginDescriptor> {
        public static PluginNameSorter instance = new PluginNameSorter();

        private PluginNameSorter() {
        }

        @Override
        public int compare(PluginDescriptor o1, PluginDescriptor o2) {
            return o1.toString().compareToIgnoreCase(o2.toString());
        }
    }

    public static class PluginKernelNameSorter
    implements Comparator<PluginDescriptor> {
        public static PluginKernelNameSorter instance = new PluginKernelNameSorter();

        private PluginKernelNameSorter() {
        }

        @Override
        public int compare(PluginDescriptor o1, PluginDescriptor o2) {
            String packageName1 = o1.getPackageName();
            String packageName2 = o2.getPackageName();
            if (packageName1.startsWith("plugins.kernel")) {
                if (!packageName2.startsWith("plugins.kernel")) {
                    return -1;
                }
            } else if (packageName2.startsWith("plugins.kernel")) {
                return 1;
            }
            return o1.toString().compareToIgnoreCase(o2.toString());
        }
    }
}

