/*
 * Decompiled with CFR 0.152.
 */
package icy.sequence;

import icy.common.CollapsibleEvent;
import icy.sequence.Sequence;
import icy.util.StringUtil;

public class SequenceEvent
implements CollapsibleEvent {
    private final Sequence sequence;
    private final SequenceEventSourceType sourceType;
    private SequenceEventType type;
    private Object source;
    private int param;

    public SequenceEvent(Sequence sequence, SequenceEventSourceType sourceType) {
        this(sequence, sourceType, null, SequenceEventType.CHANGED, -1);
    }

    public SequenceEvent(Sequence sequence, SequenceEventSourceType sourceType, Object source) {
        this(sequence, sourceType, source, SequenceEventType.CHANGED, -1);
    }

    public SequenceEvent(Sequence sequence, SequenceEventSourceType sourceType, Object source, int param) {
        this(sequence, sourceType, source, SequenceEventType.CHANGED, param);
    }

    public SequenceEvent(Sequence sequence, SequenceEventSourceType sourceType, SequenceEventType type) {
        this(sequence, sourceType, null, type, -1);
    }

    public SequenceEvent(Sequence sequence, SequenceEventSourceType sourceType, Object source, SequenceEventType type) {
        this(sequence, sourceType, source, type, -1);
    }

    public SequenceEvent(Sequence sequence, SequenceEventSourceType sourceType, Object source, SequenceEventType type, int param) {
        this.sequence = sequence;
        this.sourceType = sourceType;
        this.source = source;
        this.type = type;
        this.param = param;
    }

    public Sequence getSequence() {
        return this.sequence;
    }

    public SequenceEventSourceType getSourceType() {
        return this.sourceType;
    }

    public Object getSource() {
        return this.source;
    }

    public SequenceEventType getType() {
        return this.type;
    }

    public int getParam() {
        return this.param;
    }

    @Override
    public boolean collapse(CollapsibleEvent event) {
        if (this.equals(event)) {
            SequenceEvent e = (SequenceEvent)event;
            switch (this.sourceType.ordinal()) {
                case 2: 
                case 3: {
                    if (e.getParam() == this.param) break;
                    this.param = -1;
                    break;
                }
                case 4: {
                    if (e.getType() != this.type) {
                        this.type = SequenceEventType.CHANGED;
                    }
                    if (e.getSource() == this.source) break;
                    this.source = null;
                    break;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int res = this.sequence.hashCode() ^ this.sourceType.hashCode();
        switch (this.sourceType.ordinal()) {
            case 1: {
                if (this.source == null) break;
                res ^= this.source.hashCode();
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                res ^= this.type.hashCode();
                if (this.source == null) break;
                res ^= this.source.hashCode();
                break;
            }
        }
        return res;
    }

    @Override
    public boolean equals(Object obj) {
        SequenceEvent e;
        if (obj instanceof SequenceEvent && (e = (SequenceEvent)obj).getSequence() == this.sequence && e.getSourceType() == this.sourceType) {
            switch (this.sourceType.ordinal()) {
                case 1: {
                    return StringUtil.equals((String)e.getSource(), (String)this.source);
                }
                case 2: 
                case 3: {
                    return true;
                }
                case 4: {
                    return true;
                }
                case 5: 
                case 6: 
                case 7: {
                    return e.getType() == this.type && e.getSource() == this.source;
                }
                case 0: {
                    return true;
                }
            }
        }
        return super.equals(obj);
    }

    public static enum SequenceEventType {
        CHANGED,
        ADDED,
        REMOVED;

    }

    public static enum SequenceEventSourceType {
        SEQUENCE_TYPE,
        SEQUENCE_META,
        SEQUENCE_COLORMAP,
        SEQUENCE_COMPONENTBOUNDS,
        SEQUENCE_DATA,
        SEQUENCE_ROI,
        SEQUENCE_PAINTER,
        SEQUENCE_OVERLAY;

    }
}

