/*
 * Decompiled with CFR 0.152.
 */
package icy.sequence;

import icy.image.IcyBufferedImageCursor;
import icy.sequence.Sequence;
import icy.sequence.VolumetricImage;
import java.util.concurrent.atomic.AtomicBoolean;

public class VolumetricImageCursor {
    private VolumetricImage vol;
    private AtomicBoolean volumeChanged;
    private IcyBufferedImageCursor[] planeCursors;
    private IcyBufferedImageCursor currentCursor;
    private int currentZ;

    public VolumetricImageCursor(VolumetricImage vol) {
        this.vol = vol;
        this.planeCursors = new IcyBufferedImageCursor[vol.getSize()];
        this.volumeChanged = new AtomicBoolean(false);
        this.currentZ = -1;
    }

    public VolumetricImageCursor(Sequence seq, int t) {
        this(seq.getVolumetricImage(t));
    }

    public double get(int x, int y, int z, int c) throws IndexOutOfBoundsException, RuntimeException {
        return this.getPlaneCursor(z).get(x, y, c);
    }

    public synchronized void set(int x, int y, int z, int c, double val) throws IndexOutOfBoundsException, RuntimeException {
        this.getPlaneCursor(z).set(x, y, c, val);
        this.volumeChanged.set(true);
    }

    public synchronized void setSafe(int x, int y, int z, int c, double val) throws IndexOutOfBoundsException, RuntimeException {
        this.getPlaneCursor(z).setSafe(x, y, c, val);
        this.volumeChanged.set(true);
    }

    private synchronized IcyBufferedImageCursor getPlaneCursor(int z) throws IndexOutOfBoundsException {
        if (this.currentZ != z) {
            if (this.planeCursors[z] == null) {
                this.planeCursors[z] = new IcyBufferedImageCursor(this.vol.getImage(z));
            }
            this.currentCursor = this.planeCursors[z];
            this.currentZ = z;
        }
        return this.currentCursor;
    }

    public synchronized void commitChanges() {
        if (this.volumeChanged.get()) {
            for (int i = 0; i < this.planeCursors.length; ++i) {
                if (this.planeCursors[i] == null) continue;
                this.planeCursors[i].commitChanges();
            }
            this.volumeChanged.set(false);
        }
    }

    public String toString() {
        return "last Z=" + this.currentZ + " " + this.currentCursor != null ? this.currentCursor.toString() : "";
    }
}

