/*
 * Decompiled with CFR 0.152.
 */
package icy.type.geom.areax;

import icy.type.geom.areax.AreaX;
import icy.type.geom.areax.AreaXBody;
import icy.type.geom.areax.AreaXOperation;
import icy.type.geom.areax.AreaXRules;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;

public class BoundsRules
extends AreaXRules {
    boolean lookForDisconnectedShapes;
    boolean lookForInnerShapes;

    public BoundsRules() {
        this(true, true);
    }

    public BoundsRules(boolean lookForInnerShapes, boolean lookForDisconnectedShapes) {
        this.lookForInnerShapes = lookForInnerShapes;
        this.lookForDisconnectedShapes = lookForDisconnectedShapes;
    }

    @Override
    public AreaXBody execute(AreaXBody body, AreaXOperation[] operations) {
        ArrayList<Object> vector = new ArrayList<Object>();
        int startOfRun = this.getStartingIndex(-1, operations);
        while (startOfRun != -1 && startOfRun < operations.length) {
            int operator = operations[startOfRun].operator;
            int endOfRun = startOfRun;
            int k = startOfRun + 1;
            while (k < operations.length) {
                if (operations[k] != null) {
                    if (operations[k].operator == operator) {
                        endOfRun = k++;
                        continue;
                    }
                    endOfRun = k - 1;
                    k = operations.length;
                    continue;
                }
                ++k;
            }
            body = this.executeRun(body, operator, startOfRun, endOfRun, operations, vector);
            startOfRun = this.getStartingIndex(endOfRun + 1, operations);
        }
        return body;
    }

    private int getStartingIndex(int initialIndex, AreaXOperation[] operations) {
        int k;
        for (k = initialIndex; k < operations.length; ++k) {
            if (k < 0 || operations[k] == null) continue;
            return k;
        }
        return k;
    }

    private AreaXBody executeRun(AreaXBody body, int operator, int startIndex, int endIndex, AreaXOperation[] operations, List<Object> vector) {
        for (int a = startIndex; a <= endIndex; ++a) {
            Shape shape = operations[a].getOperand();
            if (shape instanceof AreaX) continue;
            AreaXBody newBody = AreaXBody.create(shape.getPathIterator(null), false);
            operations[a] = new AreaXOperation(new AreaX(newBody), operator);
        }
        if (this.lookForDisconnectedShapes || this.lookForInnerShapes) {
            boolean canSearchInnerShapes = operator == 0 || operator == 1;
            List<Object> listOfUnconnectedShapes = vector;
            if (operator != 3) {
                for (int a = startIndex; a < endIndex; ++a) {
                    listOfUnconnectedShapes.clear();
                    if (operations[a] == null) continue;
                    AreaX base = (AreaX)operations[a].getOperand();
                    Rectangle2D baseBounds = operations[a].getBounds();
                    vector.add(operations[a]);
                    for (int b = a + 1; b <= endIndex; ++b) {
                        Rectangle2D bBounds;
                        Rectangle2D rectangle2D = bBounds = operations[b] != null ? operations[b].getBounds() : null;
                        if (this.lookForInnerShapes && canSearchInnerShapes && operations[b] != null && baseBounds.contains(bBounds) && base.contains(operations[b].getBounds())) {
                            operations[b] = null;
                        }
                        if (!this.lookForDisconnectedShapes || operations[b] == null) continue;
                        boolean failed = false;
                        for (int c = 0; !failed && c < vector.size(); ++c) {
                            AreaXOperation op = (AreaXOperation)vector.get(c);
                            if (!bBounds.intersects(op.getBounds())) continue;
                            failed = true;
                        }
                        if (failed) continue;
                        listOfUnconnectedShapes.add(operations[b]);
                        operations[b] = null;
                    }
                    if (listOfUnconnectedShapes.size() <= 1) continue;
                    AreaXBody newBody = base != null ? base.getBody() : ((AreaX)operations[a].getOperand()).getBody();
                    int size = listOfUnconnectedShapes.size();
                    for (int b = 1; b < size; ++b) {
                        Shape shape = ((AreaXOperation)listOfUnconnectedShapes.get(b)).getOperand();
                        AreaXBody bodyB = ((AreaX)shape).getBody();
                        vector.set(b, bodyB);
                    }
                    newBody = newBody.merge(vector, 1, size - 1);
                    operations[a] = new AreaXOperation(new AreaX(newBody), operator);
                }
            }
        }
        return super.execute(body, startIndex, endIndex, operations);
    }
}

