/*
 * Decompiled with CFR 0.152.
 */
package icy.type.geom.areax;

import icy.type.geom.areax.CurveX;

abstract class CurveList {
    private static CurveX[] emptyCurves = new CurveX[0];
    protected CurveX[] elementData;
    protected int elementCount;
    private static final long serialVersionUID = 1L;

    protected CurveList(int initialCapacity) {
        this.elementData = initialCapacity == 0 ? emptyCurves : new CurveX[initialCapacity];
    }

    protected void ensureCapacity(int minCapacity) {
        int oldCapacity = this.elementData.length;
        if (minCapacity > oldCapacity) {
            CurveX[] oldData = this.elementData;
            int newCapacity = oldCapacity * 2;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            if (newCapacity < 4) {
                newCapacity = 4;
            }
            this.elementData = new CurveX[newCapacity];
            System.arraycopy(oldData, 0, this.elementData, 0, this.elementCount);
        }
    }

    protected int size() {
        return this.elementCount;
    }

    protected CurveX get(int index) {
        if (index >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return this.elementData[index];
    }

    protected boolean isEmpty() {
        return this.elementCount == 0;
    }

    protected void add(CurveX o) {
        this.ensureCapacity(this.elementCount + 1);
        this.elementData[this.elementCount++] = o;
    }
}

