/*
 * Decompiled with CFR 0.152.
 */
package icy.type.value;

import icy.type.value.AbstractValue;
import icy.util.StringUtil;

public class IntegerValue
extends AbstractValue<Integer> {
    public IntegerValue(Integer value) {
        super(value);
    }

    public IntegerValue(int value) {
        this((Integer)value);
    }

    @Override
    public Integer getDefaultValue() {
        return 0;
    }

    @Override
    public int compareTo(Integer i) {
        return ((Integer)this.value).compareTo(i);
    }

    @Override
    public boolean loadFromString(String s) {
        if (StringUtil.isEmpty(s)) {
            this.value = this.getDefaultValue();
            return true;
        }
        try {
            this.value = Integer.parseInt(s);
            return true;
        }
        catch (NumberFormatException E) {
            return false;
        }
    }
}

