/*
 * Decompiled with CFR 0.152.
 */
package icy.vtk;

import java.awt.Color;
import vtk.vtkActor;
import vtk.vtkArrowSource;
import vtk.vtkMapper;
import vtk.vtkPolyDataMapper;

public class VtkArrowObject {
    private final vtkArrowSource arrowSource = new vtkArrowSource();
    private final vtkMapper mapper;
    private final vtkActor actor;

    public VtkArrowObject() {
        this.arrowSource.SetTipLength(0.25);
        this.arrowSource.SetTipRadius(0.07);
        this.arrowSource.SetTipResolution(16);
        this.arrowSource.SetShaftRadius(0.03);
        this.arrowSource.SetShaftResolution(16);
        this.mapper = new vtkPolyDataMapper();
        this.mapper.SetInputConnection(this.arrowSource.GetOutputPort());
        this.actor = new vtkActor();
        this.actor.SetPickable(1);
        this.actor.SetMapper(this.mapper);
    }

    public void release() {
        this.actor.Delete();
        this.mapper.Delete();
        this.arrowSource.Delete();
    }

    public vtkActor getActor() {
        return this.actor;
    }

    public void setColor(Color color) {
        this.actor.GetProperty().SetColor((double)color.getRed() / 255.0, (double)color.getGreen() / 255.0, (double)color.getBlue() / 255.0);
    }

    public void setTipLenght(double value) {
        this.arrowSource.SetTipLength(value);
    }

    public void SetTipRadius(double value) {
        this.arrowSource.SetTipRadius(value);
    }

    public void SetShaftRadius(double value) {
        this.arrowSource.SetShaftRadius(value);
    }

    public void setScale(double[] value) {
        this.actor.SetScale(value);
    }

    public void setScale(double x, double y, double z) {
        this.actor.SetScale(x, y, z);
    }
}

