/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.blocks.lang;

import java.lang.reflect.Array;
import java.util.List;
import plugins.adufour.blocks.lang.Loop;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarMutable;
import plugins.adufour.vars.lang.VarMutableArray;
import plugins.adufour.vars.util.VarException;
import plugins.adufour.vars.util.VarListener;

public class Batch
extends Loop {
    private VarMutableArray array;
    private VarMutable element;

    public Var<?> getBatchSource() {
        if (this.array == null) {
            this.array = new VarMutableArray("array", null);
            this.array.addListener(new VarListener(){

                public void valueChanged(Var source, Object oldValue, Object newValue) {
                }

                public void referenceChanged(Var source, Var oldReference, Var newReference) {
                    if (oldReference == null) {
                        if (newReference != null) {
                            Batch.this.element.setType(newReference.getType().getComponentType());
                        }
                    } else if (Batch.this.element.isReferenced()) {
                        if (newReference != null && newReference.getType() != oldReference.getType()) {
                            throw new IllegalAccessError("Cannot change the type of a linked mutable variable");
                        }
                    } else if (newReference == null) {
                        Batch.this.element.setType(null);
                        Batch.this.array.setType(null);
                    } else {
                        Batch.this.element.setType(newReference.getType().getComponentType());
                    }
                }
            });
        }
        return this.array;
    }

    public Var<?> getBatchElement() {
        if (this.element == null) {
            this.element = new VarMutable("element", null);
        }
        return this.element;
    }

    @Override
    public void initializeLoop() {
        if (this.array == null || Array.getLength(this.array.getValue(true)) == 0) {
            throw new VarException(this.array, "Cannot loop on an empty array");
        }
    }

    @Override
    public void beforeIteration() {
        this.element.setValue(this.array.getElementAt(this.getIterationCounter().getValue()));
    }

    @Override
    public boolean isStopConditionReached() {
        return this.getIterationCounter().getValue() == Array.getLength(this.array.getValue());
    }

    @Override
    public void declareInput(VarList inputMap) {
        super.declareInput(inputMap);
        Var<?> batchSource = this.getBatchSource();
        inputMap.add(batchSource.getName(), this.getBatchSource());
    }

    @Override
    public void declareOutput(VarList outputMap) {
        super.declareOutput(outputMap);
        Var<?> batchElement = this.getBatchElement();
        outputMap.add(batchElement.getName(), batchElement);
    }

    @Override
    public void declareLoopVariables(List<Var<?>> loopVariables) {
        loopVariables.add(this.getBatchSource());
        loopVariables.add(this.getBatchElement());
    }
}

