/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.blocks.lang;

import icy.file.FileUtil;
import icy.gui.frame.progress.AnnounceFrame;
import icy.main.Icy;
import java.io.File;
import java.io.FileFilter;
import java.util.List;
import plugins.adufour.blocks.lang.Batch;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.gui.FileMode;
import plugins.adufour.vars.gui.model.FileTypeModel;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarBoolean;
import plugins.adufour.vars.lang.VarFile;
import plugins.adufour.vars.lang.VarString;
import plugins.adufour.vars.util.VarException;

public class FileBatch
extends Batch
implements FileFilter {
    private VarFile element;
    private VarFile folder;
    private VarString extension;
    private VarBoolean includeSubFolders;
    protected File[] files;

    @Override
    public Var<?> getBatchSource() {
        if (this.folder == null) {
            this.folder = new VarFile("folder", null);
            this.folder.setDefaultEditorModel(new FileTypeModel(null, FileMode.FOLDERS, null, false));
        }
        return this.folder;
    }

    @Override
    public boolean accept(File f) {
        String ext = (String)this.extension.getValue();
        return f.isDirectory() || ext.isEmpty() || f.getPath().toLowerCase().endsWith(ext.toLowerCase());
    }

    @Override
    public Var<?> getBatchElement() {
        if (this.element == null) {
            this.element = new VarFile("file", null);
        }
        return this.element;
    }

    @Override
    public void initializeLoop() {
        if (this.folder.getValue() == null) {
            throw new VarException(this.folder, "No folder indicated");
        }
        File file = (File)this.folder.getValue();
        if (!file.isDirectory()) {
            throw new VarException(this.folder, file.getAbsolutePath() + " is not a folder");
        }
        AnnounceFrame process = null;
        if (!Icy.getMainInterface().isHeadLess()) {
            process = new AnnounceFrame("Listing files...");
        }
        this.files = FileUtil.getFiles(file, (FileFilter)this, (boolean)((Boolean)this.includeSubFolders.getValue()), false, false);
        if (process != null) {
            process.close();
        }
    }

    @Override
    public void beforeIteration() {
        this.element.setValue(this.files[this.getIterationCounter().getValue()]);
    }

    @Override
    public boolean isStopConditionReached() {
        return this.getIterationCounter().getValue() == this.files.length;
    }

    @Override
    public void declareInput(VarList inputMap) {
        super.declareInput(inputMap);
        this.extension = new VarString("extension", "");
        inputMap.add("extension", this.extension);
        this.includeSubFolders = new VarBoolean("Include sub-folders", true);
        inputMap.add("Include sub-folders", this.includeSubFolders);
    }

    @Override
    public void declareLoopVariables(List<Var<?>> loopVariables) {
        super.declareLoopVariables(loopVariables);
        loopVariables.add(this.extension);
        loopVariables.add(this.includeSubFolders);
    }
}

