/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.blocks.lang;

import java.util.List;
import plugins.adufour.blocks.lang.Loop;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarInteger;

public class RangeLoop
extends Loop {
    private VarInteger startIndex;
    private VarInteger endIndex;
    private VarInteger step;
    private VarInteger index;

    public VarInteger getEndIndex() {
        return this.endIndex;
    }

    public VarInteger getIndex() {
        return this.index;
    }

    public VarInteger getStartIndex() {
        return this.startIndex;
    }

    public VarInteger getStep() {
        return this.step;
    }

    @Override
    public void initializeLoop() {
        this.index.setValue(this.startIndex.getValue());
    }

    @Override
    public void beforeIteration() {
    }

    @Override
    public void afterIteration() {
        this.index.setValue(this.index.getValue() + this.step.getValue());
    }

    @Override
    public boolean isStopConditionReached() {
        if (super.isStopConditionReached()) {
            return true;
        }
        if (this.step.getValue() > 0) {
            return this.index.getValue() >= this.endIndex.getValue();
        }
        return this.index.getValue() <= this.endIndex.getValue();
    }

    @Override
    public void declareInput(VarList inputMap) {
        super.declareInput(inputMap);
        this.startIndex = new VarInteger("start", 0);
        inputMap.add("start", this.startIndex);
        this.step = new VarInteger("step", 1);
        inputMap.add("step", this.step);
        this.endIndex = new VarInteger("end", 10);
        inputMap.add("end", this.endIndex);
    }

    @Override
    public void declareOutput(VarList outputMap) {
        super.declareOutput(outputMap);
        this.index = new VarInteger("index", (int)((Integer)this.startIndex.getDefaultValue()));
        outputMap.add("index", this.index);
    }

    @Override
    public void declareLoopVariables(List<Var<?>> loopVariables) {
        loopVariables.add(this.startIndex);
        loopVariables.add(this.endIndex);
        loopVariables.add(this.step);
        loopVariables.add(this.index);
        super.declareLoopVariables(loopVariables);
    }
}

