/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.ezplug;

import icy.gui.component.button.IcyButton;
import icy.network.NetworkUtil;
import icy.plugin.PluginDescriptor;
import icy.plugin.PluginLauncher;
import icy.plugin.PluginLoader;
import icy.plugin.interface_.PluginBundled;
import icy.resource.ResourceUtil;
import icy.resource.icon.IcyIcon;
import icy.system.thread.ThreadUtil;
import icy.util.ClassUtil;
import icy.util.StringUtil;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.filechooser.FileSystemView;
import plugins.adufour.ezplug.EzDialog;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzStoppable;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarDouble;
import plugins.adufour.vars.util.VarListener;

public class EzGUI
extends EzDialog
implements ActionListener {
    public static final int LOGO_HEIGHT = 32;
    private EzPlug ezPlug;
    private Thread executionThread;
    private JPanel jPanelBottom;
    private JPanel jPanelButtons;
    private JButton jButtonRun;
    private JButton jButtonStop;
    private JButton jButtonSaveParameters;
    private JButton jButtonLoadParameters;
    private JButton jButtonHelp;
    private boolean jButtonsParametersVisible = true;
    private JProgressBar jProgressBar;
    private final VarListener<Double> statusProgressListener = new VarListener<Double>(){

        @Override
        public void valueChanged(Var<Double> source, Double oldValue, final Double newValue) {
            ThreadUtil.invokeLater(new Runnable(){

                @Override
                public void run() {
                    EzGUI.this.jButtonRun.setEnabled(newValue == 0.0);
                    if (EzGUI.this.ezPlug instanceof EzStoppable) {
                        EzGUI.this.jButtonStop.setEnabled(newValue != 0.0);
                    }
                    if (!Double.isNaN(newValue)) {
                        EzGUI.this.jProgressBar.setValue((int)(Math.max(0.0, Math.min(1.0, newValue)) * 100.0));
                    }
                    EzGUI.this.jProgressBar.setIndeterminate(Double.isNaN(newValue));
                }
            });
        }

        @Override
        public void referenceChanged(Var<Double> source, Var<? extends Double> oldReference, Var<? extends Double> newReference) {
        }
    };
    private final VarListener<String> statusMessageListener = new VarListener<String>(){

        @Override
        public void valueChanged(Var<String> source, String oldValue, final String newValue) {
            ThreadUtil.invokeLater(new Runnable(){

                @Override
                public void run() {
                    EzGUI.this.jProgressBar.setString(newValue);
                    EzGUI.this.jProgressBar.setStringPainted(!newValue.trim().isEmpty());
                }
            });
        }

        @Override
        public void referenceChanged(Var<String> source, Var<? extends String> oldReference, Var<? extends String> newReference) {
        }
    };

    public EzGUI(EzPlug ezPlug) {
        super(ezPlug.getName(), false);
        this.ezPlug = ezPlug;
        this.jPanelBottom = new JPanel(new GridLayout(2, 1));
        this.jPanelButtons = new JPanel(new GridLayout(1, 5));
        this.jPanelBottom.add(this.jPanelButtons);
        this.jButtonRun = new IcyButton(new IcyIcon(ResourceUtil.getAlphaIconAsImage("playback_play.png")));
        this.jButtonRun.setToolTipText("Start the plug-in...");
        this.jButtonRun.addActionListener(this);
        this.jPanelButtons.add(this.jButtonRun);
        if (ezPlug instanceof EzStoppable) {
            this.jButtonStop = new IcyButton(new IcyIcon(ResourceUtil.getAlphaIconAsImage("playback_stop.png")));
            this.jButtonStop.setToolTipText("Stop the plug-in...");
            this.jButtonStop.setEnabled(false);
            this.jButtonStop.addActionListener(this);
            this.jPanelButtons.add(this.jButtonStop);
        }
        this.jButtonSaveParameters = new IcyButton(new IcyIcon(ResourceUtil.ICON_SAVE));
        this.jButtonSaveParameters.setToolTipText("Save the parameters to a file...");
        this.jButtonSaveParameters.addActionListener(this);
        this.jPanelButtons.add(this.jButtonSaveParameters);
        this.jButtonLoadParameters = new IcyButton(new IcyIcon(ResourceUtil.ICON_LOAD));
        this.jButtonLoadParameters.setToolTipText("Load the parameters from a file...");
        this.jButtonLoadParameters.addActionListener(this);
        this.jPanelButtons.add(this.jButtonLoadParameters);
        this.jButtonHelp = new IcyButton(new IcyIcon(ResourceUtil.ICON_HELP));
        this.jButtonHelp.setToolTipText("Access the online help for this plug-in...");
        this.jButtonHelp.addActionListener(this);
        this.jPanelButtons.add(this.jButtonHelp);
        this.jProgressBar = new JProgressBar();
        this.jProgressBar.setString("Running...");
        this.jPanelBottom.add(this.jProgressBar);
        ezPlug.getStatus().addProgressListener(this.statusProgressListener);
        ezPlug.getStatus().addMessageListener(this.statusMessageListener);
        this.getContentPane().add((Component)this.jPanelBottom, "South");
        this.pack();
        this.setOptimalLocation();
    }

    public void setRunButtonEnabled(final boolean enabled) {
        ThreadUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                EzGUI.this.jButtonRun.setEnabled(enabled);
            }
        });
    }

    public void setRunButtonText(final String text) {
        ThreadUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                EzGUI.this.jButtonRun.setText(text);
            }
        });
    }

    public void setStopButtonText(final String text) {
        ThreadUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                EzGUI.this.jButtonStop.setText(text);
            }
        });
    }

    @Deprecated
    public void setRunningState(boolean isRunning) {
        this.ezPlug.getStatus().setCompletion(isRunning ? Double.NaN : 0.0);
    }

    public void setActionPanelVisible(final boolean visible) {
        ThreadUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                EzGUI.this.jPanelBottom.setVisible(visible);
            }
        });
    }

    public VarDouble getProgressBarValue() {
        return this.ezPlug.getStatus().getProgressVariable();
    }

    public void setProgressBarMessage(String string) {
        this.ezPlug.getStatus().setMessage(string);
    }

    public void setProgressBarValue(double value) {
        this.ezPlug.getStatus().setCompletion(value);
    }

    public void setProgressBarVisible(final boolean visible) {
        ThreadUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                EzGUI.this.jProgressBar.setVisible(visible);
            }
        });
    }

    public void setParametersIOVisible(final boolean visible) {
        if (visible == this.jButtonsParametersVisible) {
            return;
        }
        ThreadUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (visible) {
                    EzGUI.this.jPanelButtons.add(EzGUI.this.jButtonLoadParameters);
                    EzGUI.this.jPanelButtons.add(EzGUI.this.jButtonSaveParameters);
                } else {
                    EzGUI.this.jPanelButtons.remove(EzGUI.this.jButtonLoadParameters);
                    EzGUI.this.jPanelButtons.remove(EzGUI.this.jButtonSaveParameters);
                }
            }
        });
        this.jButtonsParametersVisible = visible;
    }

    public void clickRun() {
        this.executionThread = new Thread((Runnable)this.ezPlug, this.ezPlug.getName());
        this.executionThread.start();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.jButtonRun)) {
            this.clickRun();
        } else if (e.getSource().equals(this.jButtonStop)) {
            if (this.ezPlug instanceof EzStoppable) {
                ((EzStoppable)((Object)this.ezPlug)).stopExecution();
            }
        } else if (e.getSource().equals(this.jButtonLoadParameters)) {
            JFileChooser jfc;
            JFileChooser jFileChooser = jfc = currentParametersPath == null ? new JFileChooser(FileSystemView.getFileSystemView()) : new JFileChooser(currentParametersPath);
            if (jfc.showOpenDialog(this.getContentPane()) != 0) {
                return;
            }
            currentParametersPath = jfc.getCurrentDirectory();
            this.ezPlug.loadParameters(jfc.getSelectedFile());
        } else if (e.getSource().equals(this.jButtonSaveParameters)) {
            JFileChooser jfc;
            JFileChooser jFileChooser = jfc = currentParametersPath == null ? new JFileChooser(FileSystemView.getFileSystemView()) : new JFileChooser(currentParametersPath);
            if (jfc.showSaveDialog(this.getContentPane()) != 0) {
                return;
            }
            currentParametersPath = jfc.getCurrentDirectory();
            this.ezPlug.saveParameters(jfc.getSelectedFile());
        } else if (e.getSource().equals(this.jButtonHelp)) {
            NetworkUtil.openBrowser(EzGUI.getMainPlugin(this.ezPlug.getDescriptor()).getWeb() + "#documentation");
        } else {
            throw new UnsupportedOperationException("Action event not recognized for source " + e.getSource());
        }
    }

    @Override
    public void onClosed() {
        super.onClosed();
        if (this.ezPlug == null) {
            return;
        }
        if (this.executionThread != null && this.executionThread.isAlive()) {
            this.ezPlug.stopExecution();
            if (!(this.ezPlug instanceof EzStoppable)) {
                this.executionThread.setUncaughtExceptionHandler(new EzStoppable.ForcedInterruptionHandler(this.ezPlug.getDescriptor()));
                this.executionThread.stop();
            }
        }
        this.ezPlug.cleanFromUI();
        this.jButtonRun.removeActionListener(this);
        if (this.jButtonStop != null) {
            this.jButtonStop.removeActionListener(this);
        }
        this.jButtonLoadParameters.removeActionListener(this);
        this.jButtonSaveParameters.removeActionListener(this);
        this.ezPlug.getStatus().removeProgressListener(this.statusProgressListener);
        this.ezPlug.getStatus().removeMessageListener(this.statusMessageListener);
        this.ezPlug = null;
    }

    private static PluginDescriptor getMainPlugin(PluginDescriptor bundledPlugin) {
        if (!bundledPlugin.isBundled()) {
            return bundledPlugin;
        }
        try {
            return PluginLoader.getPlugin(((PluginBundled)((Object)PluginLauncher.create(bundledPlugin))).getMainPluginClassName());
        }
        catch (Throwable t) {
            ArrayList<PluginDescriptor> allPlugins = PluginLoader.getPlugins(false);
            String packageName = bundledPlugin.getPackageName();
            while (!StringUtil.isEmpty(packageName)) {
                PluginDescriptor matchingPlugin = null;
                for (PluginDescriptor p : allPlugins) {
                    if (!p.getClassName().startsWith(packageName)) continue;
                    if (matchingPlugin != null) {
                        matchingPlugin = bundledPlugin;
                        break;
                    }
                    matchingPlugin = p;
                }
                if (matchingPlugin == bundledPlugin) {
                    return bundledPlugin;
                }
                if (matchingPlugin != null) {
                    return matchingPlugin;
                }
                packageName = ClassUtil.getPackageName(packageName);
            }
            return bundledPlugin;
        }
    }
}

