/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.protocols.gui.link;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.QuadCurve2D;
import java.util.ArrayList;
import plugins.adufour.blocks.lang.Link;
import plugins.adufour.protocols.gui.block.BlockPanel;
import plugins.adufour.protocols.gui.block.WorkFlowPanel;
import plugins.adufour.protocols.gui.link.Line;
import plugins.adufour.vars.lang.Var;

public class RoundedSquareLine
extends Line {
    private final ArrayList<Shape> shapes = new ArrayList();

    public RoundedSquareLine(BlockPanel srcPanel, BlockPanel dstPanel, Link<?> link) throws IllegalArgumentException {
        super(srcPanel, dstPanel, link);
    }

    public RoundedSquareLine(BlockPanel srcPanel, BlockPanel dstPanel, Var<?> exposedVariable) {
        super(srcPanel, dstPanel, exposedVariable);
    }

    @Override
    public void updateShape(Path2D path, Ellipse2D closeButton) {
        this.shapes.clear();
        float x1Control = Math.max(0.5f * (this.x1 + this.x2), this.x1 + 10.0f);
        float x2Control = Math.min(0.5f * (this.x1 + this.x2), this.x2 - 10.0f);
        if (x1Control <= x2Control) {
            float yGap = Math.min(Math.abs(this.y2 - this.y1), 10.0f);
            this.shapes.add(new Line2D.Float(this.x1, this.y1, x1Control - 10.0f, this.y1));
            if (Math.abs(this.y1 - this.y2) > 20.0f) {
                this.shapes.add(new QuadCurve2D.Float(x1Control - 10.0f, this.y1, x1Control, this.y1, x1Control, this.y1 < this.y2 ? this.y1 + yGap : this.y1 - yGap));
                this.shapes.add(new Line2D.Float(x1Control, this.y1 < this.y2 ? this.y1 + yGap : this.y1 - yGap, x1Control, this.y1 < this.y2 ? this.y2 - yGap : this.y2 + yGap));
                this.shapes.add(new QuadCurve2D.Float(x1Control, this.y1 < this.y2 ? this.y2 - yGap : this.y2 + yGap, x1Control, this.y2, x1Control + 10.0f, this.y2));
            } else {
                this.shapes.add(new CubicCurve2D.Float(x1Control - 10.0f, this.y1, x1Control + 9.0f, this.y1, x1Control - 9.0f, this.y2, x1Control + 10.0f, this.y2));
            }
            this.shapes.add(new Line2D.Float(x1Control + 10.0f, this.y2, this.x2, this.y2));
            for (Shape shape : this.shapes) {
                path.append(shape.getPathIterator(null), true);
            }
            Rectangle r = path.getBounds();
            closeButton.setFrame(r.x + r.width / 2 - 6, r.y + r.height / 2 - 6, 13.0, 13.0);
        } else {
            float yControl = 0.0f;
            if (this.dstPanel.getY() > this.srcPanel.getY() + this.srcPanel.getVarPanelHeight() + 5) {
                yControl = this.srcPanel.getY() + this.srcPanel.getVarPanelHeight() + 5;
            } else if (this.srcPanel.getY() > this.dstPanel.getY() + this.dstPanel.getVarPanelHeight() + 10) {
                yControl = this.srcPanel.getY() - 5;
            } else {
                if (this.srcPanel instanceof WorkFlowPanel || this.y2 < (float)(this.srcPanel.getY() + this.dstPanel.getVarPanelHeight()) && this.x2 > this.x1) {
                    closeButton.setFrame((int)(0.5f * (this.x1 + this.x2)) - 6, (int)(0.5f * (this.y1 + this.y2)) - 6, 13.0, 13.0);
                    float xShift = 30.0f + 0.1f * Math.abs(this.x2 - this.x1);
                    path.append(new CubicCurve2D.Float(this.x1, this.y1, this.x1 + xShift, this.y1, this.x2 - xShift, this.y2, this.x2, this.y2), false);
                    return;
                }
                yControl = Math.min(this.srcPanel.getY(), this.dstPanel.getY()) - 10;
                if ((float)this.dstPanel.getY() < this.y1) {
                    x1Control = Math.max(this.srcPanel.getX() + this.srcPanel.getWidth(), this.dstPanel.getX() + this.dstPanel.getWidth()) + 10;
                }
                if ((float)this.srcPanel.getY() < this.y2) {
                    x2Control = Math.min(this.srcPanel.getX(), this.dstPanel.getX()) - 10;
                }
            }
            float up1 = Math.signum(yControl - this.y1);
            float up2 = Math.signum(this.y2 - yControl);
            this.shapes.add(new Line2D.Float(this.x1, this.y1, x1Control - 10.0f, this.y1));
            this.shapes.add(new QuadCurve2D.Float(x1Control - 10.0f, this.y1, x1Control, this.y1, x1Control, this.y1 + 10.0f * up1));
            this.shapes.add(new Line2D.Float(x1Control, this.y1 + 10.0f * up1, x1Control, yControl - 10.0f * up1));
            if (x1Control - x2Control >= 20.0f) {
                this.shapes.add(new QuadCurve2D.Float(x1Control, yControl - 10.0f * up1, x1Control, yControl, x1Control - 10.0f, yControl));
                this.shapes.add(new Line2D.Float(x1Control - 10.0f, yControl, x2Control + 10.0f, yControl));
                this.shapes.add(new QuadCurve2D.Float(x2Control + 10.0f, yControl, x2Control, yControl, x2Control, yControl + 10.0f * up2));
            } else {
                this.shapes.add(new CubicCurve2D.Float(x1Control, yControl - 10.0f * up1, x1Control, yControl + 9.0f * up2, x2Control, yControl - 9.0f * up2, x2Control, yControl + 10.0f * up2));
            }
            this.shapes.add(new Line2D.Float(x2Control, yControl + 10.0f * up2, x2Control, this.y2 - 10.0f * up2));
            closeButton.setFrame(x2Control - 6.0f, (int)(0.5f * (yControl + this.y2)) - 6, 13.0, 13.0);
            this.shapes.add(new QuadCurve2D.Float(x2Control, this.y2 - 10.0f * up2, x2Control, this.y2, x2Control + 10.0f, this.y2));
            this.shapes.add(new Line2D.Float(x2Control + 10.0f, this.y2, this.x2, this.y2));
            for (Shape shape : this.shapes) {
                path.append(shape.getPathIterator(null), true);
            }
        }
    }

    @Override
    public boolean contains(double x, double y) {
        if (this.shapes.size() < 0) {
            return false;
        }
        for (Shape shape : this.shapes) {
            if (!shape.intersects(x - 2.0, y - 2.0, 3.0, 3.0)) continue;
            return true;
        }
        return this.isOverCloseButton(x, y);
    }
}

