/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.vars.gui.swing;

import icy.system.FileDrop;
import icy.system.thread.ThreadUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileFilter;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import plugins.adufour.vars.gui.FileMode;
import plugins.adufour.vars.gui.model.FileTypeModel;
import plugins.adufour.vars.gui.model.VarEditorModel;
import plugins.adufour.vars.gui.swing.SwingVarEditor;
import plugins.adufour.vars.lang.Var;

public class FileChooser
extends SwingVarEditor<File> {
    private ActionListener actionListener;

    public FileChooser(Var<File> variable) {
        super(variable);
    }

    @Override
    public JComponent createEditorComponent() {
        FileFilter filter;
        JButton jButton = new JButton();
        String path = null;
        FileMode fileMode = FileMode.ALL;
        boolean allowHidden = false;
        VarEditorModel model = this.variable.getDefaultEditorModel();
        if (model instanceof FileTypeModel) {
            path = ((FileTypeModel)model).getPath();
            fileMode = ((FileTypeModel)model).getMode();
            allowHidden = ((FileTypeModel)model).allowHidden();
            filter = ((FileTypeModel)model).getFilter();
        } else {
            filter = null;
        }
        final JFileChooser jFileChooser = new JFileChooser(path);
        switch (fileMode) {
            case FILES: {
                jFileChooser.setFileSelectionMode(0);
                jButton.setText("Choose file name...");
                break;
            }
            case FOLDERS: {
                jFileChooser.setFileSelectionMode(1);
                jButton.setText("Choose folder name...");
                break;
            }
            default: {
                jFileChooser.setFileSelectionMode(2);
                jButton.setText("Choose file or folder name...");
            }
        }
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.setFileHidingEnabled(!allowHidden);
        if (filter != null) {
            jFileChooser.setFileFilter(new javax.swing.filechooser.FileFilter(){

                @Override
                public String getDescription() {
                    return "Compatible files";
                }

                @Override
                public boolean accept(File f) {
                    return filter.accept(f);
                }
            });
        }
        this.actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FileChooser.this.variable.getValue() != null) {
                    jFileChooser.setSelectedFile((File)FileChooser.this.variable.getValue());
                }
                if (jFileChooser.showOpenDialog(null) != 0) {
                    return;
                }
                FileChooser.this.variable.setValue(jFileChooser.getSelectedFile());
            }
        };
        FileDrop.FileDropListener fileDropListener = this.getFileDropListener(fileMode);
        new FileDrop((Component)jButton, BorderFactory.createLineBorder(Color.blue.brighter(), 2), fileDropListener);
        return jButton;
    }

    private FileDrop.FileDropListener getFileDropListener(final FileMode fileMode) {
        return new FileDrop.FileDropListener(){

            @Override
            public void filesDropped(File[] files) {
                if (this.isActionListenerActive()) {
                    File singleFile;
                    File file = singleFile = files != null && files.length >= 1 ? files[0] : null;
                    if (singleFile != null) {
                        switch (fileMode) {
                            case FILES: {
                                if (!singleFile.isFile()) break;
                                FileChooser.this.variable.setValue(singleFile);
                                break;
                            }
                            case FOLDERS: {
                                if (!singleFile.isDirectory()) break;
                                FileChooser.this.variable.setValue(singleFile);
                                break;
                            }
                            default: {
                                FileChooser.this.variable.setValue(singleFile);
                            }
                        }
                    }
                }
            }

            private boolean isActionListenerActive() {
                for (ActionListener l : FileChooser.this.getEditorComponent().getActionListeners()) {
                    if (l != FileChooser.this.actionListener) continue;
                    return true;
                }
                return false;
            }
        };
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(100, 20);
    }

    public void setButtonText(final String text) {
        ThreadUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                FileChooser.this.getEditorComponent().setText(text);
            }
        });
    }

    @Override
    protected void updateInterfaceValue() {
        File newValue = (File)this.variable.getValue();
        if (newValue != null) {
            this.setButtonText(newValue.getAbsolutePath());
            String tooltip = "<html><pre><font size=3>";
            tooltip = tooltip + newValue.getAbsolutePath();
            if (newValue.isDirectory()) {
                tooltip = tooltip + "/";
            }
            tooltip = tooltip + "</font></pre></html>";
            this.getEditorComponent().setToolTipText(tooltip);
        }
    }

    @Override
    public JButton getEditorComponent() {
        return (JButton)super.getEditorComponent();
    }

    @Override
    protected void activateListeners() {
        this.getEditorComponent().addActionListener(this.actionListener);
    }

    @Override
    protected void deactivateListeners() {
        this.getEditorComponent().removeActionListener(this.actionListener);
    }
}

