/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.vars.gui.swing;

import icy.sequence.DimensionId;
import icy.sequence.Sequence;
import java.text.ParseException;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.text.DefaultFormatter;
import javax.swing.text.DefaultFormatterFactory;
import plugins.adufour.vars.gui.swing.Spinner;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.util.VarListener;

public abstract class SequenceDimensionSelector
extends Spinner<Integer> {
    protected Var<Sequence> sequence;
    protected DimensionId dimension;
    protected boolean allowAll;
    private final VarListener<Sequence> sequenceListener = new VarListener<Sequence>(){

        @Override
        public void valueChanged(Var<Sequence> source, Sequence oldValue, Sequence newValue) {
            SequenceDimensionSelector.this.updateInterfaceValue();
        }

        @Override
        public void referenceChanged(Var<Sequence> source, Var<? extends Sequence> oldReference, Var<? extends Sequence> newReference) {
            SequenceDimensionSelector.this.updateInterfaceValue();
        }
    };

    public SequenceDimensionSelector(Var<Integer> variable, Var<Sequence> sequence, DimensionId dim, boolean allowAll) {
        super(variable);
        this.sequence = sequence;
        this.dimension = dim;
        this.allowAll = allowAll;
    }

    @Override
    public JSpinner createEditorComponent() {
        JSpinner jSpinner = new JSpinner(new SpinnerNumberModel(){

            @Override
            public void setValue(Object channel) {
                SequenceDimensionSelector.this.variable.setValue((Integer)channel);
            }

            @Override
            public Integer getValue() {
                return (Integer)SequenceDimensionSelector.this.variable.getValue();
            }

            @Override
            public Integer getPreviousValue() {
                int minValue = SequenceDimensionSelector.this.allowAll ? -1 : 0;
                return Math.max(minValue, (Integer)SequenceDimensionSelector.this.variable.getValue() - 1);
            }

            @Override
            public Object getNextValue() {
                int maxValue = 65535;
                if (SequenceDimensionSelector.this.sequence != null && SequenceDimensionSelector.this.sequence.getValue() != null) {
                    maxValue = SequenceDimensionSelector.this.sequence.getValue().getSize(SequenceDimensionSelector.this.dimension) - 1;
                }
                return Math.min(maxValue, (Integer)SequenceDimensionSelector.this.variable.getValue() + 1);
            }
        });
        JFormattedTextField ftf = ((JSpinner.DefaultEditor)jSpinner.getEditor()).getTextField();
        ftf.setFormatterFactory(this.getFormatterFactory());
        return jSpinner;
    }

    protected JFormattedTextField.AbstractFormatterFactory getFormatterFactory() {
        final DefaultFormatter editFormatter = new DefaultFormatter(){

            @Override
            public String valueToString(Object value) throws ParseException {
                if (value == null) {
                    return "";
                }
                if (value.equals(-1)) {
                    return "ALL";
                }
                if (SequenceDimensionSelector.this.sequence == null || SequenceDimensionSelector.this.sequence.getValue() == null) {
                    return value.toString();
                }
                return SequenceDimensionSelector.this.toUserFriendlyString((Integer)value);
            }

            @Override
            public Object stringToValue(String text) throws ParseException {
                if (text.equalsIgnoreCase("ALL")) {
                    return -1;
                }
                if (SequenceDimensionSelector.this.sequence == null || SequenceDimensionSelector.this.sequence.getValue() == null) {
                    return Integer.parseInt(text);
                }
                try {
                    int value = SequenceDimensionSelector.this.toInteger(text);
                    if (value < -1) {
                        throw new ParseException(text, 0);
                    }
                    if (value == -1 && !SequenceDimensionSelector.this.allowAll) {
                        throw new ParseException(text, 0);
                    }
                    if (value >= SequenceDimensionSelector.this.sequence.getValue().getSize(SequenceDimensionSelector.this.dimension)) {
                        throw new ParseException(text, 0);
                    }
                    return value;
                }
                catch (NumberFormatException e) {
                    throw new ParseException(text, 0);
                }
            }
        };
        return new DefaultFormatterFactory(){

            @Override
            public JFormattedTextField.AbstractFormatter getDefaultFormatter() {
                return editFormatter;
            }
        };
    }

    protected String toUserFriendlyString(Integer value) {
        return value.toString();
    }

    protected Integer toInteger(String text) throws ParseException {
        return Integer.parseInt(text);
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @Override
    protected void updateInterfaceValue() {
        JFormattedTextField ftf = ((JSpinner.DefaultEditor)this.getEditorComponent().getEditor()).getTextField();
        ftf.setValue(this.variable.getValue());
    }

    @Override
    protected void activateListeners() {
        super.activateListeners();
        this.sequence.addListener(this.sequenceListener);
    }

    @Override
    protected void deactivateListeners() {
        this.sequence.removeListener(this.sequenceListener);
        super.deactivateListeners();
    }
}

