/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.vars.lang;

import icy.main.Icy;
import icy.sequence.Sequence;
import icy.util.StringUtil;
import icy.util.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import plugins.adufour.vars.gui.VarEditor;
import plugins.adufour.vars.gui.VarEditorFactory;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.util.VarListener;

public class VarSequence
extends Var<Sequence> {
    public static final String NO_SEQUENCE = "No Sequence";
    public static final String ACTIVE_SEQUENCE = "Active Sequence";
    private boolean activeSequenceSelected;

    public VarSequence(String name, Sequence defaultValue) {
        this(name, defaultValue, (VarListener<Sequence>)null);
    }

    public VarSequence(String name, Sequence defaultValue, VarListener<Sequence> defaultListener) {
        super(name, Sequence.class, defaultValue, defaultListener);
        Sequence seq = Icy.getMainInterface().getActiveSequence();
        if (seq != null && defaultValue == null) {
            this.activeSequenceSelected = true;
            this.setValue(seq);
        } else {
            this.activeSequenceSelected = false;
        }
    }

    @Override
    public boolean saveToXML(Node node) throws UnsupportedOperationException {
        XMLUtil.setAttributeValue((Element)node, "value", this.getValueAsString());
        return true;
    }

    @Override
    public boolean loadFromXML(Node node) {
        this.setValueAsString(XMLUtil.getAttributeValue((Element)node, "value", null));
        return true;
    }

    @Override
    public VarEditor<Sequence> createVarEditor() {
        return VarEditorFactory.getDefaultFactory().createSequenceChooser(this);
    }

    @Override
    public VarEditor<Sequence> createVarViewer() {
        return VarEditorFactory.getDefaultFactory().createSequenceViewer(this);
    }

    @Override
    public String getValueAsString() {
        Sequence s = (Sequence)this.getValue();
        if (this.isActiveSequenceSelected()) {
            return ACTIVE_SEQUENCE;
        }
        if (s == null) {
            return NO_SEQUENCE;
        }
        if (s.getFilename() != null) {
            return s.getFilename();
        }
        return s.getName();
    }

    public boolean isActiveSequenceSelected() {
        Var ref = this.getReference();
        if (ref instanceof VarSequence) {
            return ((VarSequence)ref).isActiveSequenceSelected();
        }
        return this.activeSequenceSelected;
    }

    public void setActiveSequenceSelected(boolean value) {
        this.activeSequenceSelected = value;
    }

    @Deprecated
    public boolean isNoSequenceSelected() {
        return StringUtil.equals(this.getValueAsString(), NO_SEQUENCE);
    }

    @Deprecated
    public void setNoSequenceSelection() {
        this.setValue(null);
    }

    @Override
    public void setValueAsString(String newValue) {
        if (StringUtil.equals(newValue, ACTIVE_SEQUENCE)) {
            boolean changed = !this.activeSequenceSelected;
            Sequence oldValue = (Sequence)this.getValue();
            Sequence seq = Icy.getMainInterface().getActiveSequence();
            this.setActiveSequenceSelected(true);
            super.setValue(seq);
            if (changed) {
                this.fireVariableChanged(oldValue, seq);
            }
        } else {
            this.setValue(null);
        }
    }

    @Override
    public void setValue(Sequence newValue) throws IllegalAccessError {
        boolean changed = this.activeSequenceSelected;
        Sequence oldValue = (Sequence)this.getValue();
        this.setActiveSequenceSelected(false);
        super.setValue(newValue);
        if (changed) {
            this.fireVariableChanged(oldValue, newValue);
        }
    }
}

