/*
 * Decompiled with CFR 0.152.
 */
package plugins.kernel.image.filtering.convolution;

import icy.sequence.Sequence;
import icy.system.thread.Processor;
import icy.type.DataType;
import icy.type.collection.array.Array1DUtil;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import plugins.kernel.image.filtering.convolution.Axis;
import plugins.kernel.image.filtering.convolution.ConvolutionException;

public class Convolution1D {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void convolve(Sequence sequence, double[] kernelX, double[] kernelY, double[] kernelZ) throws IllegalArgumentException, ConvolutionException, InterruptedException {
        if (kernelX == null && kernelY == null && kernelZ == null) {
            throw new IllegalArgumentException("Invalid argument: provide at least one non-null kernel");
        }
        if (kernelX != null && kernelX.length % 2 == 0) {
            throw new IllegalArgumentException("Invalid argument: kernel along X has even size");
        }
        if (kernelY != null && kernelY.length % 2 == 0) {
            throw new IllegalArgumentException("Invalid argument: kernel along Y has even size");
        }
        if (kernelZ != null && kernelZ.length % 2 == 0) {
            throw new IllegalArgumentException("Invalid argument: kernel along Z has even size");
        }
        DataType type = sequence.getDataType_();
        double[][] z_xy = new double[sequence.getSizeZ()][sequence.getSizeX() * sequence.getSizeY()];
        sequence.beginUpdate();
        try {
            for (int t = 0; t < sequence.getSizeT(); ++t) {
                for (int c = 0; c < sequence.getSizeC(); ++c) {
                    int z;
                    for (z = 0; z < sequence.getSizeZ(); ++z) {
                        Array1DUtil.arrayToDoubleArray(sequence.getDataXY(t, z, c), z_xy[z], type.isSigned());
                    }
                    Convolution1D.convolve(z_xy, sequence.getSizeX(), sequence.getSizeY(), kernelX, kernelY, kernelZ);
                    for (z = 0; z < sequence.getSizeZ(); ++z) {
                        Object dest = sequence.getDataXY(t, z, c);
                        Array1DUtil.doubleArrayToSafeArray(z_xy[z], dest, type.isSigned());
                        sequence.setDataXY(t, z, c, dest);
                    }
                    if (!Thread.interrupted()) continue;
                    throw new InterruptedException("Convolution operation interrupted.");
                }
            }
        }
        finally {
            sequence.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void convolve(double[][] array, int imageWidth, int imageHeight, double[] kernelX, double[] kernelY, double[] kernelZ) throws ConvolutionException {
        Processor service = new Processor(Runtime.getRuntime().availableProcessors() * 2);
        int sliceSize = array[0].length;
        double[][] temp = new double[array.length][sliceSize];
        try {
            if (array.length == 1) {
                if (kernelX == null) {
                    Convolution1D.convolve1D(service, array, temp, imageWidth, imageHeight, kernelY, Axis.Y);
                    for (int z = 0; z < array.length; ++z) {
                        System.arraycopy(temp[z], 0, array[z], 0, sliceSize);
                    }
                } else if (kernelY == null) {
                    Convolution1D.convolve1D(service, array, temp, imageWidth, imageHeight, kernelX, Axis.X);
                    for (int z = 0; z < array.length; ++z) {
                        System.arraycopy(temp[z], 0, array[z], 0, sliceSize);
                    }
                } else {
                    Convolution1D.convolve1D(service, array, temp, imageWidth, imageHeight, kernelX, Axis.X);
                    Convolution1D.convolve1D(service, temp, array, imageWidth, imageHeight, kernelY, Axis.Y);
                }
            } else if (kernelX == null) {
                if (kernelY == null) {
                    Convolution1D.convolve1D(service, array, temp, imageWidth, imageHeight, kernelZ, Axis.Z);
                    for (int z = 0; z < array.length; ++z) {
                        System.arraycopy(temp[z], 0, array[z], 0, sliceSize);
                    }
                } else if (kernelZ == null) {
                    Convolution1D.convolve1D(service, array, temp, imageWidth, imageHeight, kernelY, Axis.Y);
                    for (int z = 0; z < array.length; ++z) {
                        System.arraycopy(temp[z], 0, array[z], 0, sliceSize);
                    }
                } else {
                    Convolution1D.convolve1D(service, array, temp, imageWidth, imageHeight, kernelY, Axis.Y);
                    Convolution1D.convolve1D(service, temp, array, imageWidth, imageHeight, kernelZ, Axis.Z);
                }
            } else if (kernelY == null) {
                if (kernelZ == null) {
                    Convolution1D.convolve1D(service, array, temp, imageWidth, imageHeight, kernelX, Axis.X);
                    for (int z = 0; z < array.length; ++z) {
                        System.arraycopy(temp[z], 0, array[z], 0, sliceSize);
                    }
                } else {
                    Convolution1D.convolve1D(service, array, temp, imageWidth, imageHeight, kernelX, Axis.X);
                    Convolution1D.convolve1D(service, temp, array, imageWidth, imageHeight, kernelZ, Axis.Z);
                }
            } else if (kernelZ == null) {
                Convolution1D.convolve1D(service, array, temp, imageWidth, imageHeight, kernelX, Axis.X);
                Convolution1D.convolve1D(service, temp, array, imageWidth, imageHeight, kernelY, Axis.Y);
            } else {
                Convolution1D.convolve1D(service, array, temp, imageWidth, imageHeight, kernelX, Axis.X);
                Convolution1D.convolve1D(service, temp, array, imageWidth, imageHeight, kernelY, Axis.Y);
                Convolution1D.convolve1D(service, array, temp, imageWidth, imageHeight, kernelZ, Axis.Z);
                for (int z = 0; z < array.length; ++z) {
                    System.arraycopy(temp[z], 0, array[z], 0, sliceSize);
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        finally {
            service.shutdown();
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void convolve1D(ExecutorService service, final double[][] input, double[][] output, final int width, final int height, final double[] kernel, Axis axis) throws ConvolutionException, InterruptedException, ExecutionException {
        try {
            final int sliceSize = input[0].length;
            final int kRadius = (kernel.length - 1) / 2;
            switch (axis) {
                case X: {
                    ArrayList tasks = new ArrayList(input.length);
                    for (int z = 0; z < input.length; ++z) {
                        final double[] dArray = input[z];
                        final double[] dArray2 = output[z];
                        tasks.add(service.submit(new Runnable(){

                            @Override
                            public void run() {
                                int xy = 0;
                                for (int y = 0; y < height; ++y) {
                                    int kOffset;
                                    int kIndex;
                                    double value;
                                    int x = 0;
                                    int xStartOffset = xy;
                                    int xEndOffset = xy + width - 1;
                                    while (x < kRadius) {
                                        double value2 = 0.0;
                                        int kIndex2 = 0;
                                        int kOffset2 = -kRadius;
                                        while (kOffset2 <= kRadius) {
                                            int inOffset = xy + kOffset2;
                                            if (inOffset < xStartOffset) {
                                                inOffset = xStartOffset + (xStartOffset - inOffset);
                                            }
                                            value2 += dArray[inOffset] * kernel[kIndex2];
                                            ++kOffset2;
                                            ++kIndex2;
                                        }
                                        dArray2[xy] = value2;
                                        ++x;
                                        ++xy;
                                    }
                                    int eastBorder = width - kRadius;
                                    while (x < eastBorder) {
                                        value = 0.0;
                                        kIndex = 0;
                                        kOffset = -kRadius;
                                        while (kOffset <= kRadius) {
                                            value += dArray[xy + kOffset] * kernel[kIndex];
                                            ++kOffset;
                                            ++kIndex;
                                        }
                                        dArray2[xy] = value;
                                        ++x;
                                        ++xy;
                                    }
                                    while (x < width) {
                                        value = 0.0;
                                        kIndex = 0;
                                        kOffset = -kRadius;
                                        while (kOffset <= kRadius) {
                                            int inOffset = xy + kOffset;
                                            if (inOffset >= xEndOffset) {
                                                inOffset = xEndOffset - (inOffset - xEndOffset);
                                            }
                                            value += dArray[inOffset] * kernel[kIndex];
                                            ++kOffset;
                                            ++kIndex;
                                        }
                                        dArray2[xy] = value;
                                        ++x;
                                        ++xy;
                                    }
                                }
                            }
                        }));
                    }
                    for (Future future : tasks) {
                        future.get();
                    }
                    break;
                }
                case Y: {
                    void var11_22;
                    final int kRadiusY = kRadius * width;
                    ArrayList tasks = new ArrayList(input.length);
                    boolean bl = false;
                    while (var11_22 < input.length) {
                        final double[] dArray = input[var11_22];
                        final double[] out = output[var11_22];
                        tasks.add(service.submit(new Runnable(){

                            @Override
                            public void run() {
                                int x;
                                int kOffset;
                                int kIndex;
                                double value;
                                int y;
                                int xy = 0;
                                for (y = 0; y < kRadius; ++y) {
                                    int x2 = 0;
                                    while (x2 < width) {
                                        int yStartOffset = x2;
                                        value = 0.0;
                                        kIndex = 0;
                                        kOffset = -kRadiusY;
                                        while (kOffset <= kRadiusY) {
                                            int inOffset = xy + kOffset;
                                            if (inOffset < 0) {
                                                inOffset = yStartOffset - inOffset;
                                            }
                                            value += dArray[inOffset] * kernel[kIndex];
                                            kOffset += width;
                                            ++kIndex;
                                        }
                                        out[xy] = value;
                                        ++x2;
                                        ++xy;
                                    }
                                }
                                int southBorder = height - kRadius;
                                while (y < southBorder) {
                                    x = 0;
                                    while (x < width) {
                                        value = 0.0;
                                        kIndex = 0;
                                        kOffset = -kRadiusY;
                                        while (kOffset <= kRadiusY) {
                                            value += dArray[xy + kOffset] * kernel[kIndex];
                                            kOffset += width;
                                            ++kIndex;
                                        }
                                        out[xy] = value;
                                        ++x;
                                        ++xy;
                                    }
                                    ++y;
                                }
                                while (y < height) {
                                    x = 0;
                                    while (x < width) {
                                        int yEndOffset = sliceSize - width + x;
                                        double value2 = 0.0;
                                        int kIndex2 = 0;
                                        int kOffset2 = -kRadiusY;
                                        while (kOffset2 <= kRadiusY) {
                                            int inOffset = xy + kOffset2;
                                            if (inOffset >= sliceSize) {
                                                inOffset = yEndOffset - (inOffset - yEndOffset);
                                            }
                                            value2 += dArray[inOffset] * kernel[kIndex2];
                                            kOffset2 += width;
                                            ++kIndex2;
                                        }
                                        out[xy] = value2;
                                        ++x;
                                        ++xy;
                                    }
                                    ++y;
                                }
                            }
                        }));
                        ++var11_22;
                    }
                    for (Future future : tasks) {
                        future.get();
                    }
                    break;
                }
                case Z: {
                    ArrayList tasks = new ArrayList(input.length);
                    int z = 0;
                    while (z < kRadius) {
                        final double[] dArray = output[z];
                        final int n = z++;
                        tasks.add(service.submit(new Runnable(){

                            @Override
                            public void run() {
                                int xy = 0;
                                for (int y = 0; y < height; ++y) {
                                    int x = 0;
                                    while (x < width) {
                                        double value = 0.0;
                                        int kIndex = 0;
                                        int kOffset = -kRadius;
                                        while (kOffset <= kRadius) {
                                            int inSlice = n + kOffset;
                                            if (inSlice < 0) {
                                                inSlice = -inSlice;
                                            }
                                            value += input[inSlice][xy] * kernel[kIndex];
                                            ++kOffset;
                                            ++kIndex;
                                        }
                                        dArray[xy] = value;
                                        ++x;
                                        ++xy;
                                    }
                                }
                            }
                        }));
                    }
                    int n = input.length - kRadius;
                    while (z < n) {
                        final double[] dArray = output[z];
                        final int slice = z++;
                        tasks.add(service.submit(new Runnable(){

                            @Override
                            public void run() {
                                int xy = 0;
                                for (int y = 0; y < height; ++y) {
                                    int x = 0;
                                    while (x < width) {
                                        double value = 0.0;
                                        int kIndex = 0;
                                        int kOffset = -kRadius;
                                        while (kOffset <= kRadius) {
                                            value += input[slice + kOffset][xy] * kernel[kIndex];
                                            ++kOffset;
                                            ++kIndex;
                                        }
                                        dArray[xy] = value;
                                        ++x;
                                        ++xy;
                                    }
                                }
                            }
                        }));
                    }
                    final int n2 = input.length - 1;
                    while (z < input.length) {
                        final double[] out = output[z];
                        final int n3 = z++;
                        tasks.add(service.submit(new Runnable(){

                            @Override
                            public void run() {
                                int xy = 0;
                                for (int y = 0; y < height; ++y) {
                                    int x = 0;
                                    while (x < width) {
                                        double value = 0.0;
                                        int kIndex = 0;
                                        int kOffset = -kRadius;
                                        while (kOffset <= kRadius) {
                                            int inSlice = n3 + kOffset;
                                            if (inSlice >= input.length) {
                                                inSlice = n2 - (inSlice - n2);
                                            }
                                            value += input[inSlice][xy] * kernel[kIndex];
                                            ++kOffset;
                                            ++kIndex;
                                        }
                                        out[xy] = value;
                                        ++x;
                                        ++xy;
                                    }
                                }
                            }
                        }));
                    }
                    for (Future future : tasks) {
                        future.get();
                    }
                    break;
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ConvolutionException("Filter size is too large along " + axis.name(), e);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
    }
}

