/*
 * Decompiled with CFR 0.152.
 */
package plugins.kernel.roi.morphology.skeletonization;

import icy.image.IcyBufferedImage;
import icy.main.Icy;
import icy.sequence.Sequence;
import icy.sequence.SequenceCursor;
import icy.type.DataType;
import icy.type.dimension.Dimension3D;
import icy.type.point.Point3D;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.PriorityQueue;
import java.util.TreeSet;

public class TopologicalDescriptor {
    public static final double DEFAULT_VISITING_RADIUS_SCALE = 1.5;
    private Sequence distanceMap;
    private Sequence costMap;
    private Sequence minSpanningTree;
    private Dimension3D pixelSize;
    private double visitingRadiusScale;
    private PriorityQueue<CostElement> queue;
    private int currentBranchId;
    private Point3D.Integer rootPosition;
    private SequenceCursor distanceMapCursor;
    private SequenceCursor costMapCursor;
    private Sequence labels;
    private Sequence leafMap;
    private Sequence branchMap;
    private Sequence skeleton;
    private SequenceCursor labelsCursor;
    private SequenceCursor minSpanningTreeCursor;
    private SequenceCursor leafsCursor;
    private SequenceCursor skeletonCursor;
    private SequenceCursor branchesCursor;

    public TopologicalDescriptor(Sequence distanceMap, Sequence costMap, Sequence minSpanningTree, Dimension3D pixelSize) {
        this(distanceMap, costMap, minSpanningTree, pixelSize, 1.5);
    }

    public TopologicalDescriptor(Sequence distanceMap, Sequence costMap, Sequence minSpanningTree, Dimension3D pixelSize, double visitingRadiusScale) {
        this.distanceMap = distanceMap;
        this.costMap = costMap;
        this.minSpanningTree = minSpanningTree;
        this.pixelSize = pixelSize;
        this.visitingRadiusScale = visitingRadiusScale;
    }

    public void compute() {
        this.fillFloodQueue();
        this.initializeResult();
        this.currentBranchId = 1;
        if (!this.queue.isEmpty()) {
            this.rootPosition = this.queue.peek().point;
        }
        while (!this.queue.isEmpty()) {
            CostElement currentElement = this.queue.poll();
            Point3D.Integer currentPosition = currentElement.point;
            if (this.isPositionLabeled(currentPosition)) continue;
            this.visitSphere(currentPosition);
            this.setLeafPosition(currentPosition);
            Point3D.Integer parentPosition = this.getParentPosition(currentPosition);
            Point3D.Double distPos = new Point3D.Double();
            double dist = 0.0;
            double lastRadius = this.getDistanceMapCursor().get(currentPosition.x, currentPosition.y, currentPosition.z, 0, 0);
            do {
                currentPosition = parentPosition;
                parentPosition = this.getParentPosition(currentPosition);
                distPos.setLocation(parentPosition);
                distPos.z -= (double)currentPosition.z;
                distPos.y -= (double)currentPosition.y;
                distPos.x -= (double)currentPosition.x;
                distPos.x *= this.pixelSize.getSizeX();
                distPos.y *= this.pixelSize.getSizeY();
                distPos.z *= this.pixelSize.getSizeZ();
                dist += Math.sqrt(distPos.x * distPos.x + distPos.y * distPos.y + distPos.z * distPos.z);
                if (!this.isSkeletonPosition(currentPosition)) {
                    this.setSkeletonPosition(currentPosition);
                    if (!(dist > lastRadius * 1.1)) continue;
                    this.visitSphere(currentPosition);
                    continue;
                }
                this.setBranchPosition(currentPosition);
                this.visitSphere(currentPosition);
                ++this.currentBranchId;
                break;
            } while (!parentPosition.equals(currentElement.point));
            this.visitSphere(currentPosition);
        }
        this.commitChanges();
        Icy.getMainInterface().addSequence(this.distanceMap);
        Icy.getMainInterface().addSequence(this.labels);
        Icy.getMainInterface().addSequence(this.skeleton);
        Icy.getMainInterface().addSequence(this.leafMap);
        Icy.getMainInterface().addSequence(this.branchMap);
    }

    private void fillFloodQueue() {
        this.queue = new PriorityQueue();
        for (int z = 0; z < this.distanceMap.getSizeZ(); ++z) {
            for (int y = 0; y < this.distanceMap.getSizeY(); ++y) {
                for (int x = 0; x < this.distanceMap.getSizeX(); ++x) {
                    if (!(this.getDistanceMapCursor().get(x, y, z, 0, 0) > 0.0)) continue;
                    Point3D.Integer point = new Point3D.Integer(x, y, z);
                    CostElement ce = new CostElement(this.computeEndness(point), point);
                    this.queue.add(ce);
                }
            }
        }
    }

    private SequenceCursor getDistanceMapCursor() {
        if (this.distanceMapCursor == null) {
            this.distanceMapCursor = new SequenceCursor(this.distanceMap);
        }
        return this.distanceMapCursor;
    }

    private double computeEndness(Point3D.Integer point) {
        double distance = this.getDistanceMapCursor().get(point.x, point.y, point.z, 0, 0);
        return this.getCostMapCursor().get(point.x, point.y, point.z, 0, 0) / (distance * distance);
    }

    private SequenceCursor getCostMapCursor() {
        if (this.costMapCursor == null) {
            this.costMapCursor = new SequenceCursor(this.costMap);
        }
        return this.costMapCursor;
    }

    private void initializeResult() {
        this.labels = new Sequence("Labels");
        this.leafMap = new Sequence("LeafNodes");
        this.branchMap = new Sequence("BranchNodes");
        this.skeleton = new Sequence("Skeleton");
        for (int k = 0; k < this.distanceMap.getSizeZ(); ++k) {
            this.labels.addImage(new IcyBufferedImage(this.distanceMap.getSizeX(), this.distanceMap.getSizeY(), 1, DataType.INT));
            this.leafMap.addImage(new IcyBufferedImage(this.distanceMap.getSizeX(), this.distanceMap.getSizeY(), 1, DataType.BYTE));
            this.branchMap.addImage(new IcyBufferedImage(this.distanceMap.getSizeX(), this.distanceMap.getSizeY(), 1, DataType.BYTE));
            this.skeleton.addImage(new IcyBufferedImage(this.distanceMap.getSizeX(), this.distanceMap.getSizeY(), 1, DataType.BYTE));
        }
    }

    private void visitSphere(Point3D.Integer center) {
        if (!this.isPositionInSequence(center)) {
            return;
        }
        double sphereRadius = this.getDistanceMapCursor().get(center.x, center.y, center.z, 0, 0) * this.visitingRadiusScale;
        double squaredSphereRadius = Math.ceil(sphereRadius * sphereRadius);
        LinkedList<Point3D.Integer> sphereQueue = new LinkedList<Point3D.Integer>();
        sphereQueue.add(center);
        TreeSet<Point3D> visitedPoints = new TreeSet<Point3D>(Comparator.comparingDouble(Point3D::getX).thenComparingDouble(Point3D::getY).thenComparing(Point3D::getZ));
        while (!sphereQueue.isEmpty()) {
            Point3D.Integer currentPosition = (Point3D.Integer)sphereQueue.poll();
            if (visitedPoints.contains(currentPosition)) continue;
            visitedPoints.add(currentPosition);
            if (!this.isPositionLabeled(currentPosition)) {
                this.getLabelsCursor().set(currentPosition.x, currentPosition.y, currentPosition.z, 0, 0, this.currentBranchId);
            }
            for (int k = -1; k < 2; ++k) {
                for (int j = -1; j < 2; ++j) {
                    for (int i = -1; i < 2; ++i) {
                        Point3D.Integer candidatePosition = new Point3D.Integer(currentPosition.x + i, currentPosition.y + j, currentPosition.z + k);
                        if (!this.isPositionInSequence(candidatePosition) || visitedPoints.contains(candidatePosition) || this.getSquaredDistance(center, candidatePosition) > squaredSphereRadius) continue;
                        sphereQueue.add(candidatePosition);
                    }
                }
            }
        }
    }

    private double getSquaredDistance(Point3D.Integer a, Point3D.Integer b) {
        double dx = (double)(b.x - a.x) * this.pixelSize.getSizeX();
        double dy = (double)(b.y - a.y) * this.pixelSize.getSizeY();
        double dz = (double)(b.z - a.z) * this.pixelSize.getSizeZ();
        return dx * dx + dy * dy + dz * dz;
    }

    private boolean isPositionInSequence(Point3D.Integer p) {
        return p.x >= 0 && p.x < this.distanceMap.getSizeX() && p.y >= 0 && p.y < this.distanceMap.getSizeY() && p.z >= 0 && p.z < this.distanceMap.getSizeZ();
    }

    private boolean isPositionLabeled(Point3D.Integer point) {
        return this.getLabelsCursor().get(point.x, point.y, point.z, 0, 0) != 0.0;
    }

    private SequenceCursor getLabelsCursor() {
        if (this.labelsCursor == null) {
            this.labelsCursor = new SequenceCursor(this.labels);
        }
        return this.labelsCursor;
    }

    private Point3D.Integer getParentPosition(Point3D.Integer point) {
        Point3D.Integer parentPosition = new Point3D.Integer();
        parentPosition.x = (int)this.getMinSpanningTreeCursor().get(point.x, point.y, point.z, 0, 0);
        parentPosition.y = (int)this.getMinSpanningTreeCursor().get(point.x, point.y, point.z, 0, 1);
        parentPosition.z = (int)this.getMinSpanningTreeCursor().get(point.x, point.y, point.z, 0, 2);
        return parentPosition;
    }

    private SequenceCursor getMinSpanningTreeCursor() {
        if (this.minSpanningTreeCursor == null) {
            this.minSpanningTreeCursor = new SequenceCursor(this.minSpanningTree);
        }
        return this.minSpanningTreeCursor;
    }

    private void setLeafPosition(Point3D.Integer p) {
        this.setSkeletonPosition(p);
        this.getLeafsCursor().set(p.x, p.y, p.z, 0, 0, 1.0);
    }

    private void setSkeletonPosition(Point3D.Integer p) {
        this.getSkeletonCursor().set(p.x, p.y, p.z, 0, 0, 1.0);
    }

    private SequenceCursor getLeafsCursor() {
        if (this.leafsCursor == null) {
            this.leafsCursor = new SequenceCursor(this.leafMap);
        }
        return this.leafsCursor;
    }

    private boolean isSkeletonPosition(Point3D.Integer p) {
        return this.getSkeletonCursor().get(p.x, p.y, p.z, 0, 0) != 0.0;
    }

    private SequenceCursor getSkeletonCursor() {
        if (this.skeletonCursor == null) {
            this.skeletonCursor = new SequenceCursor(this.skeleton);
        }
        return this.skeletonCursor;
    }

    private void setBranchPosition(Point3D.Integer p) {
        this.getBranchCursor().set(p.x, p.y, p.z, 0, 0, 1.0);
    }

    private SequenceCursor getBranchCursor() {
        if (this.branchesCursor == null) {
            this.branchesCursor = new SequenceCursor(this.branchMap);
        }
        return this.branchesCursor;
    }

    private void commitChanges() {
        this.getLabelsCursor().commitChanges();
        this.getLabelsCursor().commitChanges();
        this.getBranchCursor().commitChanges();
        this.getSkeletonCursor().commitChanges();
    }

    public Point3D.Integer getRootPosition() {
        return this.rootPosition;
    }

    public static class CostElement
    implements Comparable<CostElement> {
        private final double cost;
        private final Point3D.Integer point;

        public CostElement(double cost, Point3D.Integer point) {
            this.cost = cost;
            this.point = point;
        }

        public double getCost() {
            return this.cost;
        }

        public Point3D.Integer getPoint() {
            return this.point;
        }

        @Override
        public int compareTo(CostElement ce) {
            if (this.cost > ce.getCost()) {
                return -1;
            }
            if (this.cost < ce.getCost()) {
                return 1;
            }
            return 0;
        }
    }
}

