/*
 * Decompiled with CFR 0.152.
 */
package icy.clipboard;

import icy.clipboard.TransferableNull;
import java.awt.Toolkit;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class Clipboard {
    private static final java.awt.datatransfer.Clipboard systemClipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
    private static final List<ClipboardListener> listeners = new ArrayList<ClipboardListener>();
    public static final String TYPE_SEQUENCEROILIST = "SequenceRoiList";
    public static final String TYPE_ROILIST = "RoiList";
    public static final String TYPE_ROILINKLIST = "RoiLinkList";
    public static final String TYPE_SEQUENCE = "Sequence";
    public static final String TYPE_IMAGE = "Image";
    private static String type = "";
    private static Object object = null;

    public static void clear() {
        type = "";
        object = null;
    }

    public static boolean isType(String t) {
        return type.equals(t);
    }

    public static String getType() {
        return type;
    }

    public static Object get() {
        return object;
    }

    public static Object get(String type) {
        if (Clipboard.type.equals(type)) {
            return object;
        }
        return null;
    }

    public static void put(String type, Object object) {
        if (type == null) {
            throw new IllegalArgumentException("Clipboard.put(type, object): type cannot be null !");
        }
        Clipboard.type = type;
        Clipboard.object = object;
        Clipboard.fireChangedEvent();
    }

    public static boolean hasTypeSystem(DataFlavor type) {
        return systemClipboard.isDataFlavorAvailable(type);
    }

    public static DataFlavor[] getAllTypeSystem() {
        return systemClipboard.getAvailableDataFlavors();
    }

    public static Object getSystem(DataFlavor type) throws UnsupportedFlavorException, IOException {
        if (Clipboard.hasTypeSystem(type)) {
            return systemClipboard.getData(type);
        }
        return null;
    }

    public static void clearSystem() {
        systemClipboard.setContents(new TransferableNull(), null);
    }

    public static void putSystem(Transferable contents, ClipboardOwner owner) {
        systemClipboard.setContents(contents, owner);
    }

    public static void addListener(ClipboardListener listener) {
        if (!listeners.contains(listener)) {
            listeners.add(listener);
        }
    }

    public static void removeListener(ClipboardListener listener) {
        listeners.remove(listener);
    }

    public static void fireChangedEvent() {
        for (ClipboardListener l : listeners) {
            l.clipboardChanged();
        }
    }

    public static interface ClipboardListener {
        public void clipboardChanged();
    }
}

