/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.component;

import icy.gui.component.button.IcyButton;
import icy.resource.ResourceUtil;
import icy.resource.icon.IcyIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class CloseableTabbedPane
extends JTabbedPane {
    private static final long serialVersionUID = 2105647353561738725L;

    public CloseableTabbedPane() {
    }

    public CloseableTabbedPane(int tabPlacement) {
        super(tabPlacement);
    }

    public CloseableTabbedPane(int tabPlacement, int tabLayoutPolicy) {
        super(tabPlacement, tabLayoutPolicy);
    }

    public boolean isTabClosable(int index) {
        return ((CloseableTabComponent)this.getTabComponentAt(index)).isClosable();
    }

    public void setTabClosable(int index, boolean value) {
        ((CloseableTabComponent)this.getTabComponentAt(index)).setClosable(value);
    }

    @Override
    public void setIconAt(int index, Icon icon) {
        super.setIconAt(index, icon);
        CloseableTabComponent comp = (CloseableTabComponent)this.getTabComponentAt(index);
        if (comp != null) {
            comp.setIcon(icon);
        }
    }

    @Override
    public void setDisabledIconAt(int index, Icon disabledIcon) {
        super.setDisabledIconAt(index, disabledIcon);
        CloseableTabComponent comp = (CloseableTabComponent)this.getTabComponentAt(index);
        if (comp != null) {
            comp.setDisabledIcon(disabledIcon);
        }
    }

    @Override
    public void setBackgroundAt(int index, Color background) {
        super.setBackgroundAt(index, background);
        CloseableTabComponent comp = (CloseableTabComponent)this.getTabComponentAt(index);
        if (comp != null) {
            comp.setBackgroundAll(background);
        }
    }

    @Override
    public void setForegroundAt(int index, Color foreground) {
        super.setForegroundAt(index, foreground);
        CloseableTabComponent comp = (CloseableTabComponent)this.getTabComponentAt(index);
        if (comp != null) {
            comp.setForegroundAll(foreground);
        }
    }

    @Override
    public void setTitleAt(int index, String title) {
        super.setTitleAt(index, title);
        CloseableTabComponent comp = (CloseableTabComponent)this.getTabComponentAt(index);
        if (comp != null) {
            comp.setTitle(title);
        }
    }

    @Override
    public void insertTab(String title, Icon icon, Component component, String tip, int index) {
        super.insertTab(title, icon, component, tip, index);
        this.setTabComponentAt(index, new CloseableTabComponent(title, icon));
    }

    protected void fireTabClosed(int index, String text) {
        for (CloseableTabbedPaneListener l : (CloseableTabbedPaneListener[])this.listenerList.getListeners(CloseableTabbedPaneListener.class)) {
            l.tabClosed(index, text);
        }
    }

    protected boolean fireTabClosing(int index, String text) {
        for (CloseableTabbedPaneListener l : (CloseableTabbedPaneListener[])this.listenerList.getListeners(CloseableTabbedPaneListener.class)) {
            if (l.tabClosing(index, text)) continue;
            return false;
        }
        return true;
    }

    public void addCloseableTabbedPaneListener(CloseableTabbedPaneListener l) {
        this.listenerList.add(CloseableTabbedPaneListener.class, l);
    }

    public void removeCloseableTabbedPaneListener(CloseableTabbedPaneListener l) {
        this.listenerList.remove(CloseableTabbedPaneListener.class, l);
    }

    private class CloseableTabComponent
    extends JPanel {
        private static final long serialVersionUID = 6828288788693627610L;
        private final IcyButton closeButton;
        private final JLabel label;
        private final Component sep;

        public CloseableTabComponent(String title, Icon icon) {
            this.setLayout(new BoxLayout(this, 2));
            this.setBorder(BorderFactory.createEmptyBorder());
            this.setOpaque(false);
            this.label = new JLabel(title, icon, 0);
            this.label.setOpaque(false);
            this.sep = Box.createHorizontalStrut(6);
            this.closeButton = new IcyButton(new IcyIcon(ResourceUtil.ICON_DELETE, 12));
            this.closeButton.setFlat(true);
            this.closeButton.setContentAreaFilled(false);
            this.closeButton.setToolTipText("close");
            this.closeButton.addActionListener(new ActionListener(){
                final /* synthetic */ CloseableTabComponent this$1;
                {
                    this.this$1 = this$1;
                }

                @Override
                public void actionPerformed(ActionEvent actionevent) {
                    int index = this.this$1.CloseableTabbedPane.this.indexOfTabComponent(this.this$1);
                    if (index != -1 && this.this$1.CloseableTabbedPane.this.fireTabClosing(index, this.this$1.getTitle())) {
                        this.this$1.CloseableTabbedPane.this.removeTabAt(index);
                        this.this$1.CloseableTabbedPane.this.fireTabClosed(index, this.this$1.getTitle());
                    }
                }
            });
            this.add(this.label);
            this.add(this.sep);
            this.add(this.closeButton);
            this.validate();
        }

        public boolean isClosable() {
            return this.closeButton.isVisible();
        }

        public void setClosable(boolean value) {
            this.sep.setVisible(value);
            this.closeButton.setVisible(value);
        }

        public String getTitle() {
            return this.label.getText();
        }

        public void setTitle(String title) {
            this.label.setText(title);
        }

        public void setIcon(Icon icon) {
            this.label.setIcon(icon);
        }

        public void setDisabledIcon(Icon disabledIcon) {
            this.label.setDisabledIcon(disabledIcon);
        }

        public void setBackgroundAll(Color background) {
            this.label.setBackground(background);
            this.closeButton.setBackground(background);
        }

        public void setForegroundAll(Color foreground) {
            this.label.setForeground(foreground);
            this.closeButton.setForeground(foreground);
        }
    }

    public static interface CloseableTabbedPaneListener
    extends EventListener {
        public boolean tabClosing(int var1, String var2);

        public void tabClosed(int var1, String var2);
    }
}

