/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.component;

import icy.gui.component.NumberTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Region2DComponent
extends JPanel
implements NumberTextField.ValueChangeListener {
    protected NumberTextField xStartField;
    protected NumberTextField yStartField;
    protected NumberTextField widthField;
    protected NumberTextField heightField;

    public Region2DComponent(double x, double y, double w, double h, boolean integer) {
        this.initialize();
        this.xStartField.setInteger(integer);
        this.yStartField.setInteger(integer);
        this.widthField.setInteger(integer);
        this.heightField.setInteger(integer);
        this.xStartField.setNumericValue(x);
        this.yStartField.setNumericValue(y);
        this.widthField.setNumericValue(w);
        this.heightField.setNumericValue(h);
    }

    public Region2DComponent(double x, double y, double w, double h) {
        this(x, y, w, h, false);
    }

    public Region2DComponent(boolean integer) {
        this(0.0, 0.0, 100.0, 100.0, integer);
    }

    public Region2DComponent() {
        this(0.0, 0.0, 100.0, 100.0, false);
    }

    protected void initialize() {
        this.setBorder(null);
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0, 0, 0, 0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0};
        gridBagLayout.columnWeights = new double[]{1.0, 1.0, 0.0, 1.0, 1.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        this.xStartField = new NumberTextField();
        this.xStartField.setToolTipText("Start X position of the region");
        this.xStartField.addValueListener(this);
        GridBagConstraints gbc_xStartField = new GridBagConstraints();
        gbc_xStartField.fill = 2;
        gbc_xStartField.insets = new Insets(0, 0, 0, 2);
        gbc_xStartField.gridx = 0;
        gbc_xStartField.gridy = 0;
        this.add((Component)this.xStartField, gbc_xStartField);
        this.yStartField = new NumberTextField();
        this.yStartField.setToolTipText("Start Y position of the region");
        this.yStartField.addValueListener(this);
        GridBagConstraints gbc_yStartField = new GridBagConstraints();
        gbc_yStartField.fill = 2;
        gbc_yStartField.insets = new Insets(0, 0, 0, 2);
        gbc_yStartField.gridx = 1;
        gbc_yStartField.gridy = 0;
        this.add((Component)this.yStartField, gbc_yStartField);
        this.heightField = new NumberTextField();
        this.heightField.setToolTipText("Height of the region");
        this.heightField.addValueListener(this);
        this.widthField = new NumberTextField();
        this.widthField.setToolTipText("Width of the region");
        this.widthField.addValueListener(this);
        JLabel sepLabel = new JLabel("-");
        GridBagConstraints gbc_sepLabel = new GridBagConstraints();
        gbc_sepLabel.fill = 3;
        gbc_sepLabel.insets = new Insets(0, 0, 0, 2);
        gbc_sepLabel.gridx = 2;
        gbc_sepLabel.gridy = 0;
        this.add((Component)sepLabel, gbc_sepLabel);
        GridBagConstraints gbc_widthField = new GridBagConstraints();
        gbc_widthField.fill = 2;
        gbc_widthField.insets = new Insets(0, 0, 0, 2);
        gbc_widthField.gridx = 3;
        gbc_widthField.gridy = 0;
        this.add((Component)this.widthField, gbc_widthField);
        GridBagConstraints gbc_heightField = new GridBagConstraints();
        gbc_heightField.fill = 2;
        gbc_heightField.gridx = 4;
        gbc_heightField.gridy = 0;
        this.add((Component)this.heightField, gbc_heightField);
        this.validate();
    }

    public void setRegion(double x, double y, double w, double h) {
        this.xStartField.setNumericValue(x);
        this.yStartField.setNumericValue(y);
        this.widthField.setNumericValue(w);
        this.heightField.setNumericValue(h);
    }

    public void setRegion(int x, int y, int w, int h) {
        this.xStartField.setNumericValue(x);
        this.yStartField.setNumericValue(y);
        this.widthField.setNumericValue(w);
        this.heightField.setNumericValue(h);
    }

    public void setRegion(Rectangle region) {
        this.setRegion(region.x, region.y, region.width, region.height);
    }

    public Rectangle2D getRegion() {
        if (this.isInteger()) {
            return new Rectangle((int)this.xStartField.getNumericValue(), (int)this.yStartField.getNumericValue(), (int)this.widthField.getNumericValue(), (int)this.heightField.getNumericValue());
        }
        return new Rectangle2D.Double(this.xStartField.getNumericValue(), this.yStartField.getNumericValue(), this.widthField.getNumericValue(), this.heightField.getNumericValue());
    }

    public boolean isInteger() {
        return this.xStartField.isInteger();
    }

    public void setInteger(boolean value) {
        this.xStartField.setInteger(value);
        this.yStartField.setInteger(value);
        this.widthField.setInteger(value);
        this.heightField.setInteger(value);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.xStartField.setEnabled(enabled);
        this.yStartField.setEnabled(enabled);
        this.widthField.setEnabled(enabled);
        this.heightField.setEnabled(enabled);
        super.setEnabled(enabled);
    }

    protected void fireChangedEvent() {
        ChangeEvent event = new ChangeEvent(this);
        for (ChangeListener listener : (ChangeListener[])this.getListeners(ChangeListener.class)) {
            listener.stateChanged(event);
        }
    }

    public void addChangeListener(ChangeListener listener) {
        this.listenerList.add(ChangeListener.class, listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.listenerList.remove(ChangeListener.class, listener);
    }

    @Override
    public void valueChanged(double newValue, boolean validate) {
        if (validate) {
            this.fireChangedEvent();
        }
    }
}

