/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.component.button;

import icy.action.IcyAbstractAction;
import icy.resource.icon.IcyIcon;
import icy.util.StringUtil;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.pushingpixels.flamingo.api.common.JCommandToggleButton;
import org.pushingpixels.flamingo.api.common.icon.ResizableIcon;

public class IcyCommandToggleButton
extends JCommandToggleButton {
    private static final long serialVersionUID = 6540972110297834178L;
    private boolean internalEnabled = this.isEnabled();
    private IcyAbstractAction action = null;
    private final PropertyChangeListener actionPropertyChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (StringUtil.equals("enabled", evt.getPropertyName())) {
                IcyCommandToggleButton.this.refreshEnabled();
            }
        }
    };

    public IcyCommandToggleButton(String title, IcyIcon icon) {
        super(title, (ResizableIcon)icon);
    }

    @Deprecated
    public IcyCommandToggleButton(String title, String iconName) {
        this(title, new IcyIcon(iconName));
    }

    public IcyCommandToggleButton(IcyIcon icon) {
        this(null, icon);
    }

    public IcyCommandToggleButton(String title) {
        this(title, (IcyIcon)null);
    }

    public IcyCommandToggleButton(IcyAbstractAction action) {
        this(null, (IcyIcon)null);
        this.setAction(action);
    }

    @Deprecated
    public IcyCommandToggleButton(icy.common.IcyAbstractAction action) {
        this(null, (IcyIcon)null);
        this.setAction(action);
    }

    public IcyCommandToggleButton() {
        this(null, (IcyIcon)null);
    }

    public IcyIcon getIcyIcon() {
        ResizableIcon icon = this.getIcon();
        if (icon instanceof IcyIcon) {
            return (IcyIcon)icon;
        }
        return null;
    }

    public String getIconName() {
        IcyIcon icon = this.getIcyIcon();
        if (icon != null) {
            return icon.getName();
        }
        return null;
    }

    public void setIconName(String iconName) {
        IcyIcon icon = this.getIcyIcon();
        if (icon != null) {
            icon.setName(iconName);
        }
    }

    public void setEnabled(boolean b) {
        this.internalEnabled = b;
        this.refreshEnabled();
    }

    protected void refreshEnabled() {
        super.setEnabled(this.internalEnabled && (this.action == null || this.action.isEnabled()));
    }

    public void setAction(IcyAbstractAction value) {
        if (this.action != value) {
            if (this.action != null) {
                this.removeActionListener(this.action);
                this.action.removePropertyChangeListener(this.actionPropertyChangeListener);
            }
            this.action = value;
            this.setText(this.action.getName());
            IcyIcon icon = this.action.getIcon();
            if (icon != null) {
                this.setIcon(new IcyIcon(icon));
            } else {
                this.setIcon(null);
            }
            if (value != null) {
                this.setActionRichTooltip(this.action.getRichToolTip());
                this.addActionListener(value);
                value.addPropertyChangeListener(this.actionPropertyChangeListener);
            }
            this.refreshEnabled();
        }
    }

    public IcyAbstractAction getAction() {
        return this.action;
    }
}

