/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.component.pool;

import icy.main.Icy;
import icy.swimmingPool.SwimmingObject;
import icy.swimmingPool.SwimmingPoolEvent;
import icy.swimmingPool.SwimmingPoolListener;
import icy.swimmingPool.WeakSwimmingPoolListener;
import icy.util.StringUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;

public class SwimmingObjectChooser
extends JComboBox
implements SwimmingPoolListener {
    private static final long serialVersionUID = 1594001236878708868L;
    private List<SwimmingObjectChooserListener> listeners;
    private final Class<? extends Object> itemClass;

    public SwimmingObjectChooser(Class<? extends Object> itemClass) {
        this(itemClass, 50, "No valid object to display in SwimmingPool");
    }

    public SwimmingObjectChooser(Class<? extends Object> itemClass, final int maxSize, final String defaultMessage) {
        this.itemClass = itemClass;
        this.listeners = new ArrayList<SwimmingObjectChooserListener>();
        Icy.getMainInterface().getSwimmingPool().addListener(new WeakSwimmingPoolListener(this));
        this.setRenderer(new ListCellRenderer(){
            final /* synthetic */ SwimmingObjectChooser this$0;
            {
                this.this$0 = this$0;
            }

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (value == null) {
                    return new JLabel(defaultMessage);
                }
                if (value instanceof SwimmingObject) {
                    JLabel label = new JLabel(StringUtil.limit(((SwimmingObject)value).getName(), maxSize));
                    label.setToolTipText(((SwimmingObject)value).getName());
                    return label;
                }
                return new JLabel(value.toString());
            }
        });
    }

    public Object getSelectedObject() {
        Object o = this.getSelectedItem();
        if (o != null) {
            return ((SwimmingObject)o).getObject();
        }
        return null;
    }

    @Override
    public void swimmingPoolChangeEvent(final SwimmingPoolEvent event) {
        SwingUtilities.invokeLater(new Runnable(){
            final /* synthetic */ SwimmingObjectChooser this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                Object obj;
                this.this$0.refreshList();
                SwimmingObject swimObj = event.getResult();
                if (swimObj != null && (obj = swimObj.getObject()) != null) {
                    this.this$0.setSelectedItem(obj);
                }
            }
        });
    }

    void refreshList() {
        Object oldSelected = this.getSelectedItem();
        this.setModel(new DefaultComboBoxModel<Object>(this.getSwimmingObjects()));
        this.setSelectedItem(oldSelected);
    }

    Object[] getSwimmingObjects() {
        ArrayList<SwimmingObject> objectList = new ArrayList<SwimmingObject>();
        ArrayList<SwimmingObject> objects = Icy.getMainInterface().getSwimmingPool().getObjects();
        for (SwimmingObject so : objects) {
            if (!this.itemClass.isInstance(so.getObject())) continue;
            objectList.add(so);
        }
        return objectList.toArray();
    }

    public void addListener(SwimmingObjectChooserListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(SwimmingObjectChooserListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void fireItemStateChanged(ItemEvent e) {
        for (SwimmingObjectChooserListener listener : this.listeners) {
            listener.objectChanged(this.getSelectedObject());
        }
        super.fireItemStateChanged(e);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        for (SwimmingObjectChooserListener listener : this.listeners) {
            listener.objectChanged(this.getSelectedObject());
        }
        super.actionPerformed(e);
    }

    public static interface SwimmingObjectChooserListener {
        public void objectChanged(Object var1);
    }
}

