/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.component.sequence;

import icy.common.listener.AcceptListener;
import icy.gui.main.GlobalSequenceListener;
import icy.gui.util.ComponentUtil;
import icy.main.Icy;
import icy.sequence.Sequence;
import icy.util.StringUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class SequenceChooser
extends JComboBox
implements GlobalSequenceListener {
    private static final long serialVersionUID = -6108163762809540675L;
    public static final String SEQUENCE_SELECT_CMD = "sequence_select";
    AcceptListener filter;
    final String nullEntryName;
    protected final List<SequenceChooserListener> listeners;
    protected WeakReference<Sequence> previousSelectedSequence;
    protected final SequenceComboModel model;
    protected final Sequence activeSequence;

    public SequenceChooser(boolean activeSequenceEntry, final String nullEntryName, final int nameMaxLength) {
        this.nullEntryName = nullEntryName;
        this.activeSequence = activeSequenceEntry ? new Sequence("active sequence") : null;
        this.model = new SequenceComboModel();
        this.setModel(this.model);
        this.setRenderer(new ListCellRenderer(){
            final /* synthetic */ SequenceChooser this$0;
            {
                this.this$0 = this$0;
            }

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel result = new JLabel();
                if (value instanceof Sequence) {
                    String name = ((Sequence)value).getName();
                    result.setText(StringUtil.limit(name, nameMaxLength));
                    result.setToolTipText(name);
                } else if (value == null) {
                    result.setText(nullEntryName);
                }
                return result;
            }
        });
        this.addActionListener(this);
        this.listeners = new ArrayList<SequenceChooserListener>();
        this.setActionCommand(SEQUENCE_SELECT_CMD);
        this.previousSelectedSequence = new WeakReference<Object>(null);
        this.setSelectedItem(null);
        ComponentUtil.setFixedHeight(this, 26);
    }

    @Deprecated
    public SequenceChooser(int sequenceNameMaxLength, boolean nullEntry, boolean autoSelectIfNull, String nullEntryName) {
        this(false, nullEntry ? nullEntryName : null, sequenceNameMaxLength);
    }

    @Deprecated
    public SequenceChooser(int maxLength, boolean nullEntry, boolean autoSelectIfNull) {
        this(false, nullEntry ? "no sequence" : null, maxLength);
    }

    @Deprecated
    public SequenceChooser(int maxLength, boolean nullEntry) {
        this(false, nullEntry ? "no sequence" : null, maxLength);
    }

    public SequenceChooser(boolean activeSequenceEntry, String nullEntryName) {
        this(activeSequenceEntry, nullEntryName, 64);
    }

    @Deprecated
    public SequenceChooser(int nameMaxLength) {
        this(false, "no sequence", nameMaxLength);
    }

    public SequenceChooser() {
        this(true, null, 64);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        Icy.getMainInterface().addGlobalSequenceListener(this);
    }

    @Override
    public void removeNotify() {
        Icy.getMainInterface().removeGlobalSequenceListener(this);
        super.removeNotify();
    }

    public AcceptListener getFilter() {
        return this.filter;
    }

    public void setFilter(AcceptListener filter) {
        if (this.filter != filter) {
            this.filter = filter;
            this.model.updateList();
        }
    }

    public Sequence getSelectedSequence() {
        Sequence result = (Sequence)this.getSelectedItem();
        if (result == this.activeSequence) {
            return Icy.getMainInterface().getActiveSequence();
        }
        return result;
    }

    public void setActiveSequenceSelected() {
        if (this.activeSequence != null) {
            this.setSelectedItem(this.activeSequence);
        }
    }

    public void setSelectedSequence(Sequence sequence) {
        if (sequence != this.getSelectedSequence()) {
            this.setSelectedItem(sequence);
        }
    }

    @Deprecated
    public void setSequenceSelected(Sequence sequence) {
        this.setSelectedSequence(sequence);
    }

    private void sequenceChanged(Sequence sequence) {
        this.fireSequenceChanged(sequence);
    }

    private void fireSequenceChanged(Sequence sequence) {
        for (SequenceChooserListener listener : this.getListeners()) {
            listener.sequenceChanged(sequence);
        }
    }

    public ArrayList<SequenceChooserListener> getListeners() {
        return new ArrayList<SequenceChooserListener>(this.listeners);
    }

    public void addListener(SequenceChooserListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(SequenceChooserListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Sequence selected = this.getSelectedSequence();
        if (this.previousSelectedSequence.get() != selected) {
            this.previousSelectedSequence = new WeakReference<Sequence>(selected);
            this.sequenceChanged(selected);
        }
    }

    @Override
    public void sequenceOpened(Sequence sequence) {
        this.model.updateList();
    }

    @Override
    public void sequenceClosed(Sequence sequence) {
        this.model.updateList();
    }

    private class SequenceComboModel
    extends DefaultComboBoxModel {
        private static final long serialVersionUID = -1402261337279171323L;
        final List<WeakReference<Sequence>> cachedList = new ArrayList<WeakReference<Sequence>>();

        public SequenceComboModel() {
            this.updateList();
        }

        public void updateList() {
            ArrayList<Sequence> sequences;
            Object selected = this.getSelectedItem();
            int oldSize = this.cachedList.size();
            this.cachedList.clear();
            if (SequenceChooser.this.nullEntryName != null) {
                this.cachedList.add(new WeakReference<Object>(null));
            }
            if ((sequences = Icy.getMainInterface().getSequences()).size() > 0 && SequenceChooser.this.activeSequence != null) {
                this.cachedList.add(new WeakReference<Sequence>(SequenceChooser.this.activeSequence));
            }
            for (Sequence seq : sequences) {
                if (SequenceChooser.this.filter != null && !SequenceChooser.this.filter.accept(seq)) continue;
                this.cachedList.add(new WeakReference<Sequence>(seq));
            }
            int newSize = this.cachedList.size();
            if (newSize < oldSize) {
                this.fireIntervalRemoved(this, newSize, oldSize - 1);
            } else if (newSize > oldSize) {
                this.fireIntervalAdded(this, oldSize, newSize - 1);
            }
            this.fireContentsChanged(this, 0, newSize - 1);
            this.setSelectedItem(selected);
        }

        @Override
        public Object getElementAt(int index) {
            return this.cachedList.get(index).get();
        }

        @Override
        public int getSize() {
            return this.cachedList.size();
        }
    }

    public static interface SequenceChooserListener {
        public void sequenceChanged(Sequence var1);
    }
}

